/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.standalone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.accessControl.AcademicAuthorizationGroup;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFile;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFileType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.standalone.StandaloneIndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.standalone.StandaloneIndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.standalone.StandaloneIndividualCandidacyProcess_Base;
import org.fenixedu.academic.domain.candidacyProcess.standalone.StandaloneIndividualCandidacyResultBean;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.StartActivity;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.commons.CurricularCourseByExecutionSemesterBean;
import org.fenixedu.bennu.core.domain.User;

public class StandaloneIndividualCandidacyProcess
extends StandaloneIndividualCandidacyProcess_Base {
    private static final List<Activity> activities = new ArrayList<Activity>();

    private StandaloneIndividualCandidacyProcess() {
    }

    public StandaloneIndividualCandidacyProcess(StandaloneIndividualCandidacyProcessBean bean) {
        this();
        this.init(bean);
    }

    protected void checkParameters(CandidacyProcess process2) {
        if (process2 == null || process2.getCandidacyPeriod() == null) {
            throw new DomainException("error.StandaloneIndividualCandidacyProcess.invalid.candidacy.process", new String[0]);
        }
    }

    protected void createIndividualCandidacy(IndividualCandidacyProcessBean bean) {
        new StandaloneIndividualCandidacy(this, (StandaloneIndividualCandidacyProcessBean)bean);
    }

    public boolean canExecuteActivity(User userView) {
        return StandaloneIndividualCandidacyProcess.isAllowedToManageProcess(this, userView);
    }

    public List<Activity> getActivities() {
        return activities;
    }

    public StandaloneIndividualCandidacy getCandidacy() {
        return (StandaloneIndividualCandidacy)((Object)super.getCandidacy());
    }

    public ExecutionSemester getCandidacyExecutionInterval() {
        return (ExecutionSemester)((Object)super.getCandidacyExecutionInterval());
    }

    public List<CurricularCourseByExecutionSemesterBean> getCurricularCourseBeans() {
        ArrayList<CurricularCourseByExecutionSemesterBean> result = new ArrayList<CurricularCourseByExecutionSemesterBean>(this.getCandidacy().getCurricularCoursesSet().size());
        for (CurricularCourse curricularCourse : this.getCandidacy().getCurricularCoursesSet()) {
            result.add(new CurricularCourseByExecutionSemesterBean(curricularCourse, this.getCandidacyExecutionInterval()));
        }
        return result;
    }

    public Collection<CurricularCourse> getCurricularCourses() {
        return this.getCandidacy().getCurricularCoursesSet();
    }

    public StandaloneIndividualCandidacyProcess editCandidacyInformation(StandaloneIndividualCandidacyProcessBean bean) {
        this.getCandidacy().editCandidacyInformation(bean.getCandidacyDate(), bean.getCurricularCourses());
        return this;
    }

    public Degree getCandidacySelectedDegree() {
        return Degree.readEmptyDegree();
    }

    private static boolean isAllowedToManageProcess(StandaloneIndividualCandidacyProcess process2, User userView) {
        Set programs = AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_INDIVIDUAL_CANDIDACIES, userView.getPerson().getUser()).collect(Collectors.toSet());
        if (process2 == null || process2.getCandidacy() == null) {
            return AcademicAuthorizationGroup.get(AcademicOperationType.MANAGE_INDIVIDUAL_CANDIDACIES).isMember(userView);
        }
        if (process2.getCandidacy().getCurricularCoursesSet().isEmpty()) {
            return true;
        }
        for (CurricularCourse course : process2.getCandidacy().getCurricularCoursesSet()) {
            if (!programs.contains(course.getDegreeCurricularPlan().getDegree())) continue;
            return true;
        }
        return false;
    }

    public Boolean isCandidacyProcessComplete() {
        return null;
    }

    public List<IndividualCandidacyDocumentFileType> getMissingRequiredDocumentFiles() {
        return null;
    }

    protected void executeOperationsBeforeDocumentFileBinding(IndividualCandidacyDocumentFile documentFile) {
    }

    static {
        activities.add(new CandidacyPayment());
        activities.add(new EditCandidacyPersonalInformation());
        activities.add(new EditCandidacyInformation());
        activities.add(new IntroduceCandidacyResult());
        activities.add(new CancelCandidacy());
        activities.add(new CreateRegistration());
        activities.add(new BindPersonToCandidacy());
    }

    private static class BindPersonToCandidacy
    extends Activity<StandaloneIndividualCandidacyProcess> {
        private BindPersonToCandidacy() {
        }

        @Override
        public void checkPreConditions(StandaloneIndividualCandidacyProcess process2, User userView) {
            if (!StandaloneIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyInternal().booleanValue()) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected StandaloneIndividualCandidacyProcess executeActivity(StandaloneIndividualCandidacyProcess process2, User userView, Object object) {
            StandaloneIndividualCandidacyProcessBean bean = (StandaloneIndividualCandidacyProcessBean)object;
            process2.editPersonalCandidacyInformation(bean.getPersonBean());
            process2.bindPerson(bean.getChoosePersonBean());
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class CreateRegistration
    extends Activity<StandaloneIndividualCandidacyProcess> {
        private CreateRegistration() {
        }

        @Override
        public void checkPreConditions(StandaloneIndividualCandidacyProcess process2, User userView) {
            if (!StandaloneIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isCandidacyAccepted()) {
                throw new PreConditionNotValidException();
            }
            if (process2.hasRegistrationForCandidacy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected StandaloneIndividualCandidacyProcess executeActivity(StandaloneIndividualCandidacyProcess process2, User userView, Object object) {
            this.createRegistration(process2);
            return process2;
        }

        private void createRegistration(StandaloneIndividualCandidacyProcess process2) {
            process2.getCandidacy().createRegistration(DegreeCurricularPlan.readEmptyDegreeCurricularPlan(), null, IngressionType.findByPredicate(IngressionType::isIsolatedCurricularUnits).orElse(null));
        }
    }

    private static class CancelCandidacy
    extends Activity<StandaloneIndividualCandidacyProcess> {
        private CancelCandidacy() {
        }

        @Override
        public void checkPreConditions(StandaloneIndividualCandidacyProcess process2, User userView) {
            if (!StandaloneIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected StandaloneIndividualCandidacyProcess executeActivity(StandaloneIndividualCandidacyProcess process2, User userView, Object object) {
            process2.cancelCandidacy(userView.getPerson());
            return process2;
        }
    }

    private static class IntroduceCandidacyResult
    extends Activity<StandaloneIndividualCandidacyProcess> {
        private IntroduceCandidacyResult() {
        }

        @Override
        public void checkPreConditions(StandaloneIndividualCandidacyProcess process2, User userView) {
            if (!StandaloneIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isSentToCoordinator() && !process2.isSentToScientificCouncil()) {
                throw new PreConditionNotValidException();
            }
            if (process2.getCandidacy().getEvent() == null || process2.getCandidacy().getEvent().isCancelled()) {
                return;
            }
            if (!process2.isCandidacyDebtPayed()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected StandaloneIndividualCandidacyProcess executeActivity(StandaloneIndividualCandidacyProcess process2, User userView, Object object) {
            process2.getCandidacy().editCandidacyResult((StandaloneIndividualCandidacyResultBean)object);
            return process2;
        }
    }

    private static class EditCandidacyInformation
    extends Activity<StandaloneIndividualCandidacyProcess> {
        private EditCandidacyInformation() {
        }

        @Override
        public void checkPreConditions(StandaloneIndividualCandidacyProcess process2, User userView) {
            if (!StandaloneIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled() || process2.isCandidacyAccepted()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected StandaloneIndividualCandidacyProcess executeActivity(StandaloneIndividualCandidacyProcess process2, User userView, Object object) {
            return process2.editCandidacyInformation((StandaloneIndividualCandidacyProcessBean)object);
        }
    }

    private static class EditCandidacyPersonalInformation
    extends Activity<StandaloneIndividualCandidacyProcess> {
        private EditCandidacyPersonalInformation() {
        }

        @Override
        public void checkPreConditions(StandaloneIndividualCandidacyProcess process2, User userView) {
            if (!StandaloneIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected StandaloneIndividualCandidacyProcess executeActivity(StandaloneIndividualCandidacyProcess process2, User userView, Object object) {
            StandaloneIndividualCandidacyProcessBean bean = (StandaloneIndividualCandidacyProcessBean)object;
            process2.editPersonalCandidacyInformation(bean.getPersonBean());
            return process2;
        }
    }

    private static class CandidacyPayment
    extends Activity<StandaloneIndividualCandidacyProcess> {
        private CandidacyPayment() {
        }

        @Override
        public void checkPreConditions(StandaloneIndividualCandidacyProcess process2, User userView) {
            if (!StandaloneIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected StandaloneIndividualCandidacyProcess executeActivity(StandaloneIndividualCandidacyProcess process2, User userView, Object object) {
            return process2;
        }
    }

    @StartActivity
    public static class IndividualCandidacyInformation
    extends Activity<StandaloneIndividualCandidacyProcess> {
        @Override
        public void checkPreConditions(StandaloneIndividualCandidacyProcess process2, User userView) {
            if (!StandaloneIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected StandaloneIndividualCandidacyProcess executeActivity(StandaloneIndividualCandidacyProcess dummy, User userView, Object object) {
            return new StandaloneIndividualCandidacyProcess((StandaloneIndividualCandidacyProcessBean)object);
        }
    }
}

