/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.over23;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessDocumentUploadBean;
import org.fenixedu.academic.domain.candidacyProcess.DegreeOfficePublicCandidacyHashCode;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFile;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFileType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.PrecedentDegreeInformationForIndividualCandidacyFactory;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacyProcess_Base;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacyResultBean;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.StartActivity;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.User;

public class Over23IndividualCandidacyProcess
extends Over23IndividualCandidacyProcess_Base {
    private static List<Activity> activities = new ArrayList<Activity>();

    protected Over23IndividualCandidacyProcess() {
    }

    private Over23IndividualCandidacyProcess(Over23IndividualCandidacyProcessBean bean) {
        this();
        this.init(bean);
        this.setSpecificIndividualCandidacyDocumentFiles(bean);
    }

    protected void checkParameters(CandidacyProcess process2) {
        if (process2 == null || process2.getCandidacyPeriod() == null) {
            throw new DomainException("error.Over23IndividualCandidacyProcess.invalid.candidacy.process", new String[0]);
        }
    }

    protected void createIndividualCandidacy(IndividualCandidacyProcessBean bean) {
        new Over23IndividualCandidacy(this, (Over23IndividualCandidacyProcessBean)bean);
    }

    public Over23IndividualCandidacy getCandidacy() {
        return (Over23IndividualCandidacy)((Object)super.getCandidacy());
    }

    public boolean canExecuteActivity(User userView) {
        return Over23IndividualCandidacyProcess.isAllowedToManageProcess(this, userView);
    }

    public List<Activity> getActivities() {
        return activities;
    }

    private Over23IndividualCandidacyProcess editCandidacyInformation(Over23IndividualCandidacyProcessBean bean) {
        this.getCandidacy().editCandidacyInformation(bean.getCandidacyDate(), bean.getSelectedDegrees(), bean.getDisabilities(), bean.getEducation(), bean.getLanguagesRead(), bean.getLanguagesWrite(), bean.getLanguagesSpeak());
        PrecedentDegreeInformationForIndividualCandidacyFactory.edit(bean);
        return this;
    }

    public List<Degree> getSelectedDegreesSortedByOrder() {
        return this.getCandidacy().getSelectedDegreesSortedByOrder();
    }

    public String getDisabilities() {
        return this.getCandidacy().getDisabilities();
    }

    public String getEducation() {
        return this.getCandidacy().getEducation();
    }

    public String getLanguages() {
        return this.getCandidacy().getLanguages();
    }

    public String getLanguagesRead() {
        return this.getCandidacy().getLanguagesRead();
    }

    public String getLanguagesWrite() {
        return this.getCandidacy().getLanguagesWrite();
    }

    public String getLanguagesSpeak() {
        return this.getCandidacy().getLanguagesSpeak();
    }

    public Degree getAcceptedDegree() {
        return this.getCandidacy().getAcceptedDegree();
    }

    public boolean hasAcceptedDegree() {
        return this.getAcceptedDegree() != null;
    }

    public ExecutionYear getCandidacyExecutionInterval() {
        return (ExecutionYear)((Object)super.getCandidacyExecutionInterval());
    }

    private static boolean isAllowedToManageProcess(Over23IndividualCandidacyProcess process2, User userView) {
        Set programs = AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_INDIVIDUAL_CANDIDACIES, userView.getPerson().getUser()).collect(Collectors.toSet());
        if (process2 == null || process2.getCandidacy() == null) {
            return false;
        }
        return !Collections.disjoint(programs, process2.getCandidacy().getSelectedDegrees());
    }

    private void setSpecificIndividualCandidacyDocumentFiles(Over23IndividualCandidacyProcessBean bean) {
        this.bindIndividualCandidacyDocumentFile(bean.getCurriculumVitaeDocument());
        this.bindIndividualCandidacyDocumentFile(bean.getHandicapProofDocument());
        for (CandidacyProcessDocumentUploadBean documentBean : bean.getHabilitationCertificateList()) {
            this.bindIndividualCandidacyDocumentFile(documentBean);
        }
        for (CandidacyProcessDocumentUploadBean documentBean : bean.getReportOrWorkDocumentList()) {
            this.bindIndividualCandidacyDocumentFile(documentBean);
        }
    }

    private void saveChosenDegrees(List<Degree> degrees) {
        this.getCandidacy().saveChoosedDegrees(degrees);
    }

    private void saveLanguagesReadWriteSpeak(Over23IndividualCandidacyProcessBean bean) {
        this.getCandidacy().setLanguagesRead(bean.getLanguagesRead());
        this.getCandidacy().setLanguagesSpeak(bean.getLanguagesSpeak());
        this.getCandidacy().setLanguagesWrite(bean.getLanguagesWrite());
    }

    public Boolean isCandidacyProcessComplete() {
        return this.isCandidacyPersonalInformationComplete() && this.isCandidacyInformationComplete() && this.isCandidacyCommonInformationComplete();
    }

    private boolean isCandidacyCommonInformationComplete() {
        return true;
    }

    private boolean isCandidacyInformationComplete() {
        return !this.getCandidacy().getOver23IndividualCandidacyDegreeEntriesSet().isEmpty();
    }

    private boolean isCandidacyPersonalInformationComplete() {
        return true;
    }

    public List<IndividualCandidacyDocumentFileType> getMissingRequiredDocumentFiles() {
        ArrayList<IndividualCandidacyDocumentFileType> missingDocumentFiles = new ArrayList<IndividualCandidacyDocumentFileType>();
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.PHOTO) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.PHOTO);
        }
        if (this.requireCV() && this.getActiveFileForType(IndividualCandidacyDocumentFileType.CV_DOCUMENT) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.CV_DOCUMENT);
        }
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.HABILITATION_CERTIFICATE_DOCUMENT) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.HABILITATION_CERTIFICATE_DOCUMENT);
        }
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.DOCUMENT_IDENTIFICATION) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.DOCUMENT_IDENTIFICATION);
        }
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.PAYMENT_DOCUMENT) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.PAYMENT_DOCUMENT);
        }
        if (this.requireFiscalIdDoc() && this.getActiveFileForType(IndividualCandidacyDocumentFileType.VAT_CARD_DOCUMENT) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.VAT_CARD_DOCUMENT);
        }
        return missingDocumentFiles;
    }

    private boolean requireCV() {
        Boolean doNotRequireCV = this.getCandidacy().getCandidacyProcess().getCandidacyProcess().getDoNotRequireCV();
        return doNotRequireCV == null || doNotRequireCV == false;
    }

    private boolean requireFiscalIdDoc() {
        Boolean doNotRequireFiscalIdDocument = this.getCandidacy().getCandidacyProcess().getCandidacyProcess().getDoNotRequireFiscalIdDocument();
        return doNotRequireFiscalIdDocument == null || doNotRequireFiscalIdDocument == false;
    }

    protected void executeOperationsBeforeDocumentFileBinding(IndividualCandidacyDocumentFile documentFile) {
        IndividualCandidacyDocumentFileType type = documentFile.getCandidacyFileType();
        IndividualCandidacyDocumentFile file = this.getActiveFileForType(type);
        if (file == null) {
            return;
        }
        if (IndividualCandidacyDocumentFileType.REPORT_OR_WORK_DOCUMENT.equals((Object)type)) {
            return;
        }
        if (IndividualCandidacyDocumentFileType.PAYMENT_DOCUMENT.equals((Object)type)) {
            throw new DomainException("error.over23.uploading.payment.document.more.than.once", new String[0]);
        }
        file.setCandidacyFileActive(false);
    }

    static {
        activities.add(new CandidacyPayment());
        activities.add(new EditCandidacyPersonalInformation());
        activities.add(new EditCandidacyInformation());
        activities.add(new IntroduceCandidacyResult());
        activities.add(new CancelCandidacy());
        activities.add(new CreateRegistration());
        activities.add(new EditPublicCandidacyPersonalInformation());
        activities.add(new EditPublicCandidacyDocumentFile());
        activities.add(new EditPublicCandidacyHabilitations());
        activities.add(new EditDocuments());
        activities.add(new BindPersonToCandidacy());
        activities.add(new ChangeProcessCheckedState());
        activities.add(new SendEmailForApplicationSubmission());
        activities.add(new ChangePaymentCheckedState());
        activities.add(new RevokeDocumentFile());
        activities.add(new MoveCandidacy());
    }

    protected static class RevokeDocumentFile
    extends Activity<Over23IndividualCandidacyProcess> {
        protected RevokeDocumentFile() {
        }

        @Override
        public void checkPreConditions(Over23IndividualCandidacyProcess process2, User userView) {
            if (!Over23IndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23IndividualCandidacyProcess executeActivity(Over23IndividualCandidacyProcess process2, User userView, Object object) {
            ((CandidacyProcessDocumentUploadBean)object).getDocumentFile().setCandidacyFileActive(Boolean.FALSE);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class MoveCandidacy
    extends Activity<Over23IndividualCandidacyProcess> {
        private MoveCandidacy() {
        }

        @Override
        public void checkPreConditions(Over23IndividualCandidacyProcess process2, User userView) {
            if (!Over23IndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled() || !process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23IndividualCandidacyProcess executeActivity(Over23IndividualCandidacyProcess process2, User userView, Object object) {
            CandidacyProcess candidacyProcess = (CandidacyProcess)((Object)object);
            process2.setCandidacyProcess(candidacyProcess);
            return process2;
        }
    }

    private static class ChangePaymentCheckedState
    extends Activity<Over23IndividualCandidacyProcess> {
        private ChangePaymentCheckedState() {
        }

        @Override
        public void checkPreConditions(Over23IndividualCandidacyProcess process2, User userView) {
            if (!Over23IndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23IndividualCandidacyProcess executeActivity(Over23IndividualCandidacyProcess process2, User userView, Object object) {
            process2.setPaymentChecked(((IndividualCandidacyProcessBean)object).getPaymentChecked());
            return process2;
        }
    }

    private static class SendEmailForApplicationSubmission
    extends Activity<Over23IndividualCandidacyProcess> {
        private SendEmailForApplicationSubmission() {
        }

        @Override
        public void checkPreConditions(Over23IndividualCandidacyProcess process2, User userView) {
        }

        @Override
        protected Over23IndividualCandidacyProcess executeActivity(Over23IndividualCandidacyProcess process2, User userView, Object object) {
            DegreeOfficePublicCandidacyHashCode hashCode = (DegreeOfficePublicCandidacyHashCode)((Object)object);
            hashCode.sendEmailForApplicationSuccessfullySubmited();
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class ChangeProcessCheckedState
    extends Activity<Over23IndividualCandidacyProcess> {
        private ChangeProcessCheckedState() {
        }

        @Override
        public void checkPreConditions(Over23IndividualCandidacyProcess process2, User userView) {
            if (!Over23IndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23IndividualCandidacyProcess executeActivity(Over23IndividualCandidacyProcess process2, User userView, Object object) {
            process2.setProcessChecked(((IndividualCandidacyProcessBean)object).getProcessChecked());
            return process2;
        }
    }

    private static class EditDocuments
    extends Activity<Over23IndividualCandidacyProcess> {
        private EditDocuments() {
        }

        @Override
        public void checkPreConditions(Over23IndividualCandidacyProcess process2, User userView) {
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23IndividualCandidacyProcess executeActivity(Over23IndividualCandidacyProcess process2, User userView, Object object) {
            CandidacyProcessDocumentUploadBean bean = (CandidacyProcessDocumentUploadBean)object;
            process2.bindIndividualCandidacyDocumentFile(bean);
            return process2;
        }
    }

    private static class EditPublicCandidacyHabilitations
    extends Activity<Over23IndividualCandidacyProcess> {
        private EditPublicCandidacyHabilitations() {
        }

        @Override
        public void checkPreConditions(Over23IndividualCandidacyProcess process2, User userView) {
            if (!process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23IndividualCandidacyProcess executeActivity(Over23IndividualCandidacyProcess process2, User userView, Object object) {
            IndividualCandidacyProcessBean bean = (IndividualCandidacyProcessBean)object;
            process2.editCandidacyHabilitations(bean);
            process2.saveChosenDegrees(((Over23IndividualCandidacyProcessBean)object).getSelectedDegrees());
            process2.saveLanguagesReadWriteSpeak((Over23IndividualCandidacyProcessBean)object);
            process2.getCandidacy().setDisabilities(((Over23IndividualCandidacyProcessBean)object).getDisabilities());
            process2.editPrecedentDegreeInformation(bean);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class EditPublicCandidacyDocumentFile
    extends Activity<Over23IndividualCandidacyProcess> {
        private EditPublicCandidacyDocumentFile() {
        }

        @Override
        public void checkPreConditions(Over23IndividualCandidacyProcess process2, User userView) {
            if (!process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23IndividualCandidacyProcess executeActivity(Over23IndividualCandidacyProcess process2, User userView, Object object) {
            CandidacyProcessDocumentUploadBean bean = (CandidacyProcessDocumentUploadBean)object;
            process2.bindIndividualCandidacyDocumentFile(bean);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class EditPublicCandidacyPersonalInformation
    extends Activity<Over23IndividualCandidacyProcess> {
        private EditPublicCandidacyPersonalInformation() {
        }

        @Override
        public void checkPreConditions(Over23IndividualCandidacyProcess process2, User userView) {
            if (!process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23IndividualCandidacyProcess executeActivity(Over23IndividualCandidacyProcess process2, User userView, Object object) {
            process2.editPersonalCandidacyInformation(((IndividualCandidacyProcessBean)object).getPersonBean());
            process2.saveLanguagesReadWriteSpeak((Over23IndividualCandidacyProcessBean)object);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class BindPersonToCandidacy
    extends Activity<Over23IndividualCandidacyProcess> {
        private BindPersonToCandidacy() {
        }

        @Override
        public void checkPreConditions(Over23IndividualCandidacyProcess process2, User userView) {
            if (!Over23IndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyInternal().booleanValue()) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23IndividualCandidacyProcess executeActivity(Over23IndividualCandidacyProcess process2, User userView, Object object) {
            IndividualCandidacyProcessBean bean = (IndividualCandidacyProcessBean)object;
            process2.editPersonalCandidacyInformation(bean.getPersonBean());
            process2.bindPerson(bean.getChoosePersonBean());
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class CreateRegistration
    extends Activity<Over23IndividualCandidacyProcess> {
        private CreateRegistration() {
        }

        @Override
        public void checkPreConditions(Over23IndividualCandidacyProcess process2, User userView) {
            if (!Over23IndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isCandidacyAccepted()) {
                throw new PreConditionNotValidException();
            }
            if (process2.hasRegistrationForCandidacy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23IndividualCandidacyProcess executeActivity(Over23IndividualCandidacyProcess process2, User userView, Object object) {
            this.createRegistration(process2);
            return process2;
        }

        private void createRegistration(Over23IndividualCandidacyProcess candidacyProcess) {
            candidacyProcess.getCandidacy().createRegistration(this.getDegreeCurricularPlan(candidacyProcess), CycleType.FIRST_CYCLE, IngressionType.findByPredicate(IngressionType::isOver23).orElse(null));
        }

        private DegreeCurricularPlan getDegreeCurricularPlan(Over23IndividualCandidacyProcess candidacyProcess) {
            return candidacyProcess.getAcceptedDegree().getLastActiveDegreeCurricularPlan();
        }
    }

    private static class CancelCandidacy
    extends Activity<Over23IndividualCandidacyProcess> {
        private CancelCandidacy() {
        }

        @Override
        public void checkPreConditions(Over23IndividualCandidacyProcess process2, User userView) {
            if (!Over23IndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.hasAnyPaymentForCandidacy() || !process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23IndividualCandidacyProcess executeActivity(Over23IndividualCandidacyProcess process2, User userView, Object object) {
            process2.cancelCandidacy(userView.getPerson());
            return process2;
        }
    }

    private static class IntroduceCandidacyResult
    extends Activity<Over23IndividualCandidacyProcess> {
        private IntroduceCandidacyResult() {
        }

        @Override
        public void checkPreConditions(Over23IndividualCandidacyProcess process2, User userView) {
            if (!Over23IndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isCandidacyDebtPayed()) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isSentToJury()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23IndividualCandidacyProcess executeActivity(Over23IndividualCandidacyProcess process2, User userView, Object object) {
            Over23IndividualCandidacyResultBean bean = (Over23IndividualCandidacyResultBean)object;
            process2.getCandidacy().editCandidacyResult(bean.getState(), bean.getAcceptedDegree());
            return process2;
        }
    }

    private static class EditCandidacyInformation
    extends Activity<Over23IndividualCandidacyProcess> {
        private EditCandidacyInformation() {
        }

        @Override
        public void checkPreConditions(Over23IndividualCandidacyProcess process2, User userView) {
            if (!Over23IndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isInStandBy() || process2.isCandidacyCancelled() || process2.isCandidacyAccepted()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23IndividualCandidacyProcess executeActivity(Over23IndividualCandidacyProcess process2, User userView, Object object) {
            process2.editCandidacyHabilitations((IndividualCandidacyProcessBean)object);
            return process2.editCandidacyInformation((Over23IndividualCandidacyProcessBean)object);
        }
    }

    private static class EditCandidacyPersonalInformation
    extends Activity<Over23IndividualCandidacyProcess> {
        private EditCandidacyPersonalInformation() {
        }

        @Override
        public void checkPreConditions(Over23IndividualCandidacyProcess process2, User userView) {
            if (!Over23IndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23IndividualCandidacyProcess executeActivity(Over23IndividualCandidacyProcess process2, User userView, Object object) {
            IndividualCandidacyProcessBean bean = (IndividualCandidacyProcessBean)object;
            process2.editPersonalCandidacyInformation(bean.getPersonBean());
            return process2;
        }
    }

    private static class CandidacyPayment
    extends Activity<Over23IndividualCandidacyProcess> {
        private CandidacyPayment() {
        }

        @Override
        public void checkPreConditions(Over23IndividualCandidacyProcess process2, User userView) {
            if (!Over23IndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23IndividualCandidacyProcess executeActivity(Over23IndividualCandidacyProcess process2, User userView, Object object) {
            return process2;
        }
    }

    @StartActivity
    public static class IndividualCandidacyInformation
    extends Activity<Over23IndividualCandidacyProcess> {
        @Override
        public void checkPreConditions(Over23IndividualCandidacyProcess process2, User userView) {
        }

        @Override
        protected Over23IndividualCandidacyProcess executeActivity(Over23IndividualCandidacyProcess dummy, User userView, Object object) {
            return new Over23IndividualCandidacyProcess((Over23IndividualCandidacyProcessBean)object);
        }
    }
}

