/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.over23;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessSelectDegreesBean;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessState;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23CandidacyProcess_Base;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacyProcess;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.StartActivity;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.CandidacyProcessCandidacyPeriod;
import org.fenixedu.academic.domain.period.Over23CandidacyPeriod;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class Over23CandidacyProcess
extends Over23CandidacyProcess_Base {
    private static List<Activity> activities;
    private static final Predicate<DegreeType> ALLOWED_DEGREE_TYPES;

    private Over23CandidacyProcess() {
    }

    private Over23CandidacyProcess(ExecutionYear executionYear, DateTime start, DateTime end, String name) {
        this();
        this.checkParameters((ExecutionInterval)((Object)executionYear), start, end);
        this.setState(CandidacyProcessState.STAND_BY);
        this.setName(name);
        new Over23CandidacyPeriod(this, executionYear, start, end);
    }

    private void checkParameters(ExecutionInterval executionInterval, DateTime start, DateTime end) {
        if (executionInterval == null) {
            throw new DomainException("error.Over23CandidacyProcess.invalid.executionInterval", new String[0]);
        }
        if (start == null || end == null || start.isAfter((ReadableInstant)end)) {
            throw new DomainException("error.Over23CandidacyProcess.invalid.interval", new String[0]);
        }
    }

    private void edit(DateTime start, DateTime end) {
        this.checkParameters(this.getCandidacyPeriod().getExecutionInterval(), start, end);
        this.getCandidacyPeriod().edit(start, end);
    }

    public boolean canExecuteActivity(User userView) {
        return Over23CandidacyProcess.isAllowedToManageProcess(userView) || RoleType.SCIENTIFIC_COUNCIL.isMember(userView.getPerson().getUser());
    }

    public List<Activity> getActivities() {
        return activities;
    }

    public List<Over23IndividualCandidacyProcess> getOver23IndividualCandidaciesThatCanBeSendToJury() {
        ArrayList<Over23IndividualCandidacyProcess> result = new ArrayList<Over23IndividualCandidacyProcess>();
        for (IndividualCandidacyProcess child : this.getChildProcessesSet()) {
            Over23IndividualCandidacyProcess over23CP = (Over23IndividualCandidacyProcess)((Object)child);
            if (!over23CP.isCandidacyValid()) continue;
            result.add(over23CP);
        }
        return result;
    }

    public List<Over23IndividualCandidacyProcess> getAcceptedOver23IndividualCandidacies() {
        ArrayList<Over23IndividualCandidacyProcess> result = new ArrayList<Over23IndividualCandidacyProcess>();
        for (IndividualCandidacyProcess child : this.getChildProcessesSet()) {
            if (!child.isCandidacyValid() || !child.isCandidacyAccepted()) continue;
            result.add((Over23IndividualCandidacyProcess)((Object)child));
        }
        return result;
    }

    private static boolean isAllowedToManageProcess(User userView) {
        for (AcademicProgram program : AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_CANDIDACY_PROCESSES, userView.getPerson().getUser()).collect(Collectors.toSet())) {
            if (!ALLOWED_DEGREE_TYPES.test(program.getDegreeType())) continue;
            return true;
        }
        return false;
    }

    static {
        Over23CandidacyProcess.getRelationCandidacyPeriodCandidacyProcess().addListener((RelationListener)new RelationAdapter<CandidacyProcess, CandidacyProcessCandidacyPeriod>(){

            public void beforeAdd(CandidacyProcess candidacyProcess, CandidacyProcessCandidacyPeriod candidacyPeriod) {
                super.beforeAdd((DomainObject)candidacyProcess, (DomainObject)candidacyPeriod);
                if (candidacyProcess != null && candidacyPeriod != null && candidacyPeriod instanceof Over23CandidacyPeriod && !candidacyPeriod.getCandidacyProcessesSet().isEmpty()) {
                    throw new DomainException("error.Over23CandidacyProcess.candidacy.period.already.has.process", new String[0]);
                }
            }
        });
        activities = new ArrayList<Activity>();
        activities.add(new EditCandidacyPeriod());
        activities.add(new SendInformationToJury());
        activities.add(new PrintCandidacies());
        activities.add(new SelectAvailableDegrees());
        ALLOWED_DEGREE_TYPES = DegreeType.oneOf(DegreeType::isBolonhaDegree, DegreeType::isIntegratedMasterDegree);
    }

    private static class SelectAvailableDegrees
    extends Activity<Over23CandidacyProcess> {
        private SelectAvailableDegrees() {
        }

        @Override
        public void checkPreConditions(Over23CandidacyProcess process2, User userView) {
            if (!Over23CandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23CandidacyProcess executeActivity(Over23CandidacyProcess process2, User userView, Object object) {
            CandidacyProcessSelectDegreesBean bean = (CandidacyProcessSelectDegreesBean)object;
            List<Degree> degrees = bean.getDegrees();
            process2.getDegreeSet().addAll(degrees);
            process2.getDegreeSet().retainAll(degrees);
            return process2;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return Boolean.FALSE;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return Boolean.FALSE;
        }
    }

    private static class PrintCandidacies
    extends Activity<Over23CandidacyProcess> {
        private PrintCandidacies() {
        }

        @Override
        public void checkPreConditions(Over23CandidacyProcess process2, User userView) {
            if (!Over23CandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23CandidacyProcess executeActivity(Over23CandidacyProcess process2, User userView, Object object) {
            return process2;
        }
    }

    private static class SendInformationToJury
    extends Activity<Over23CandidacyProcess> {
        private SendInformationToJury() {
        }

        @Override
        public void checkPreConditions(Over23CandidacyProcess process2, User userView) {
            if (!Over23CandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isInStandBy()) {
                throw new PreConditionNotValidException();
            }
            if (process2.getCandidacyPeriod() == null || !process2.hasStarted() || process2.hasOpenCandidacyPeriod()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23CandidacyProcess executeActivity(Over23CandidacyProcess process2, User userView, Object object) {
            process2.setState(CandidacyProcessState.SENT_TO_JURY);
            return process2;
        }
    }

    private static class EditCandidacyPeriod
    extends Activity<Over23CandidacyProcess> {
        private EditCandidacyPeriod() {
        }

        @Override
        public void checkPreConditions(Over23CandidacyProcess process2, User userView) {
            if (!Over23CandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23CandidacyProcess executeActivity(Over23CandidacyProcess process2, User userView, Object object) {
            CandidacyProcessBean bean = (CandidacyProcessBean)object;
            process2.edit(bean.getStart(), bean.getEnd());
            return process2;
        }
    }

    @StartActivity
    public static class CreateCandidacyPeriod
    extends Activity<Over23CandidacyProcess> {
        @Override
        public void checkPreConditions(Over23CandidacyProcess process2, User userView) {
            if (!Over23CandidacyProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected Over23CandidacyProcess executeActivity(Over23CandidacyProcess process2, User userView, Object object) {
            CandidacyProcessBean bean = (CandidacyProcessBean)object;
            return new Over23CandidacyProcess((ExecutionYear)((Object)bean.getExecutionInterval()), bean.getStart(), bean.getEnd(), bean.getName());
        }
    }
}

