/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.degreeTransfer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessDocumentUploadBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFileType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessWithPrecedentDegreeInformationBean;
import org.fenixedu.academic.domain.candidacyProcess.PrecedentDegreeInformationBeanFactory;
import org.fenixedu.academic.domain.candidacyProcess.degreeTransfer.DegreeTransferCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.degreeTransfer.DegreeTransferIndividualCandidacyProcess;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.joda.time.LocalDate;

public class DegreeTransferIndividualCandidacyProcessBean
extends IndividualCandidacyProcessWithPrecedentDegreeInformationBean {
    private Degree selectDegree;

    public DegreeTransferIndividualCandidacyProcessBean() {
        this.setCandidacyDate(new LocalDate());
        this.initializeDocumentUploadBeans();
        this.setObservations("");
    }

    public DegreeTransferIndividualCandidacyProcessBean(DegreeTransferIndividualCandidacyProcess process2) {
        this.setIndividualCandidacyProcess((IndividualCandidacyProcess)((Object)process2));
        this.setCandidacyProcess((CandidacyProcess)((Object)process2.getCandidacyProcess()));
        this.setCandidacyDate(process2.getCandidacyDate());
        this.setSelectedDegree(process2.getCandidacySelectedDegree());
        this.setPrecedentDegreeType(IndividualCandidacyProcessWithPrecedentDegreeInformationBean.PrecedentDegreeType.valueOf(process2.getPrecedentDegreeInformation()));
        this.setPrecedentDegreeInformation(PrecedentDegreeInformationBeanFactory.createBean((IndividualCandidacy)((Object)process2.getCandidacy())));
        this.initializeFormation(process2.getCandidacy().getFormationsSet());
        this.setObservations(process2.getCandidacy().getObservations());
        this.setProcessChecked(process2.getProcessChecked());
        this.setPaymentChecked(process2.getPaymentChecked());
        this.setUtlStudent(process2.getCandidacy().getUtlStudent());
    }

    @Override
    protected List<CycleType> getValidPrecedentCycleTypes() {
        return Collections.singletonList(CycleType.FIRST_CYCLE);
    }

    @Override
    protected boolean isPreBolonhaPrecedentDegreeAllowed() {
        return true;
    }

    public ExecutionYear getCandidacyExecutionInterval() {
        return (ExecutionYear)((Object)super.getCandidacyExecutionInterval());
    }

    @Override
    public List<StudentCurricularPlan> getPrecedentStudentCurricularPlans() {
        Student student = this.getStudent();
        if (student == null) {
            return Collections.emptyList();
        }
        ArrayList<StudentCurricularPlan> studentCurricularPlans = new ArrayList<StudentCurricularPlan>();
        block0: for (Registration registration : student.getRegistrationsSet()) {
            if (registration.isBolonha()) {
                StudentCurricularPlan studentCurricularPlan = registration.getLastStudentCurricularPlan();
                for (CycleType cycleType : this.getValidPrecedentCycleTypes()) {
                    CycleCurriculumGroup cycle;
                    if (!studentCurricularPlan.hasCycleCurriculumGroup(cycleType) || (cycle = studentCurricularPlan.getCycle(cycleType)).isConclusionProcessed() || cycle.isConcluded()) continue;
                    studentCurricularPlans.add(registration.getLastStudentCurricularPlan());
                    continue block0;
                }
                continue;
            }
            if (!this.isPreBolonhaPrecedentDegreeAllowed() || registration.isConcluded() || registration.isRegistrationConclusionProcessed()) continue;
            studentCurricularPlans.add(registration.getLastStudentCurricularPlan());
        }
        return studentCurricularPlans;
    }

    public DegreeTransferCandidacyProcess getCandidacyProcess() {
        return (DegreeTransferCandidacyProcess)((Object)super.getCandidacyProcess());
    }

    public Degree getSelectedDegree() {
        return this.selectDegree;
    }

    public void setSelectedDegree(Degree selectDegree) {
        this.selectDegree = selectDegree;
    }

    @Override
    protected void initializeDocumentUploadBeans() {
        this.setPhotoDocument(new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.PHOTO));
    }

    @Override
    public boolean isDegreeTransfer() {
        return true;
    }
}

