/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy.util;

import com.google.common.io.ByteStreams;
import com.lowagie.text.pdf.PdfReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.candidacy.GenericApplication;
import org.fenixedu.academic.domain.candidacy.GenericApplicationFile;
import org.fenixedu.academic.domain.candidacy.GenericApplicationLetterOfRecomentation;
import org.fenixedu.academic.domain.candidacy.GenericApplicationRecomentation;
import org.fenixedu.academic.domain.candidacy.util.GenericApplicationUploadBean$callable$uploadTo;
import org.fenixedu.academic.domain.candidacy.util.GenericApplicationUploadBean$callable$uploadTo$1;
import org.fenixedu.academic.domain.exceptions.DomainException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class GenericApplicationUploadBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient InputStream stream;
    protected long fileSize;
    protected String fileName;
    protected String displayName;
    protected static final int MAX_FILE_SIZE = 3698688;
    public static final Advice advice$uploadTo = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$uploadTo$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public InputStream getStream() throws FileNotFoundException {
        return this.stream;
    }

    public void setStream(InputStream stream) throws IOException {
        this.stream = stream;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    protected byte[] readStreamContents() throws IOException {
        try (InputStream stream = this.getStream();){
            if (stream == null || this.getFileSize() == 0L) {
                byte[] byArray = null;
                return byArray;
            }
            if (this.getFileSize() > 3698688L) {
                throw new DomainException("error.file.to.big", new String[0]);
            }
            byte[] contents = ByteStreams.toByteArray((InputStream)stream);
            new PdfReader(contents);
            byte[] byArray = contents;
            return byArray;
        }
    }

    public GenericApplicationFile uploadTo(GenericApplication genericApplication) {
        return (GenericApplicationFile)((Object)advice$uploadTo.perform((Callable)new GenericApplicationUploadBean$callable$uploadTo(this, genericApplication)));
    }

    static /* synthetic */ GenericApplicationFile advised$uploadTo(GenericApplicationUploadBean this_, GenericApplication application) {
        try {
            byte[] content = this_.readStreamContents();
            if (content != null && content.length > 0) {
                return new GenericApplicationFile(application, this_.displayName, this_.fileName, content);
            }
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
        return null;
    }

    public GenericApplicationLetterOfRecomentation uploadTo(GenericApplicationRecomentation genericApplicationRecomentation) {
        return (GenericApplicationLetterOfRecomentation)((Object)advice$uploadTo$1.perform((Callable)new GenericApplicationUploadBean$callable$uploadTo$1(this, genericApplicationRecomentation)));
    }

    static /* synthetic */ GenericApplicationLetterOfRecomentation advised$uploadTo(GenericApplicationUploadBean this_, GenericApplicationRecomentation recomentation) {
        try {
            byte[] content = this_.readStreamContents();
            if (content != null && content.length > 0) {
                if (recomentation.getLetterOfRecomentation() != null) {
                    recomentation.getLetterOfRecomentation().delete();
                }
                return new GenericApplicationLetterOfRecomentation(recomentation, this_.displayName, this_.fileName, content);
            }
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
        return null;
    }
}

