/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.gratuity;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.gratuity.DfaGratuityEvent;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.DFAGratuityByEnrolmentsPR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class DFAGratuityByEnrolmentsPR
extends DFAGratuityByEnrolmentsPR_Base {
    private static final int SCALE_FOR_INTERMEDIATE_CALCULATIONS = 8;

    protected DFAGratuityByEnrolmentsPR() {
    }

    public DFAGratuityByEnrolmentsPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money dfaTotalAmount, BigDecimal partialAcceptedPercentage, Money dfaAmountPerEnrolment) {
        this.init(EntryType.GRATUITY_FEE, EventType.GRATUITY, startDate, endDate, serviceAgreementTemplate, dfaTotalAmount, partialAcceptedPercentage, dfaAmountPerEnrolment);
    }

    protected void init(EntryType entryType, EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money dfaTotalAmount, BigDecimal dfaPartialAcceptedPercentage, Money dfaAmountPerEnrolment) {
        super.init(entryType, eventType, startDate, endDate, serviceAgreementTemplate, dfaTotalAmount, dfaPartialAcceptedPercentage);
        this.checkParameters(dfaAmountPerEnrolment);
        super.setDfaAmountPerEnrolment(dfaAmountPerEnrolment);
    }

    private void checkParameters(Money dfaAmountPerEnrolment) {
        if (dfaAmountPerEnrolment == null) {
            throw new DomainException("error.accounting.postingRules.gratuity.DFAGratuityByAmountPerEctsPR.dfaAmountPerEnrolment.cannot.be.null", new String[0]);
        }
    }

    protected Money calculateDFAGratuityTotalAmountToPay(Event event) {
        DfaGratuityEvent dfaGratuity = (DfaGratuityEvent)((Object)event);
        return this.getDfaAmountPerEnrolment().multiply(dfaGratuity.getRegistration().getEnrolments(dfaGratuity.getExecutionYear()).size());
    }

    public void setDfaAmountPerEnrolment(Money dfaAmountPerEnrolment) {
        throw new DomainException("error.accounting.postingRules.gratuity.DFAGratuityByEnrolmentsPR.cannot.modify.dfaAmountPerEnrolment", new String[0]);
    }

    public DFAGratuityByEnrolmentsPR edit(Money dfaTotalAmount, Money dfaAmountPerEnrolment, BigDecimal partialAcceptedPercentage) {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        return this.edit(new DateTime(), dfaTotalAmount, dfaAmountPerEnrolment, partialAcceptedPercentage);
    }

    public DFAGratuityByEnrolmentsPR edit(DateTime startDate, Money dfaTotalAmount, Money dfaAmountPerEnrolment, BigDecimal partialAcceptedPercentage) {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        this.deactivate(startDate);
        return new DFAGratuityByEnrolmentsPR(startDate, null, this.getServiceAgreementTemplate(), dfaTotalAmount, partialAcceptedPercentage, dfaAmountPerEnrolment);
    }
}

