/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.paymentPlans;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.Installment;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEventWithPaymentPlan;
import org.fenixedu.academic.domain.accounting.paymentPlanRules.PaymentPlanRule;
import org.fenixedu.academic.domain.accounting.paymentPlans.GratuityPaymentPlan_Base;
import org.fenixedu.academic.domain.accounting.serviceAgreementTemplates.DegreeCurricularPlanServiceAgreementTemplate;

public class GratuityPaymentPlan
extends GratuityPaymentPlan_Base {
    protected GratuityPaymentPlan() {
    }

    public GratuityPaymentPlan(ExecutionYear executionYear, DegreeCurricularPlanServiceAgreementTemplate serviceAgreementTemplate) {
        this(executionYear, serviceAgreementTemplate, false);
    }

    public GratuityPaymentPlan(ExecutionYear executionYear, DegreeCurricularPlanServiceAgreementTemplate serviceAgreementTemplate, Boolean defaultPlan) {
        this();
        super.init(executionYear, (ServiceAgreementTemplate)((Object)serviceAgreementTemplate), defaultPlan);
    }

    public boolean isToApplyPenalty(Event event, Installment installment) {
        return !((GratuityEventWithPaymentPlan)((Object)event)).hasPenaltyExemptionFor(installment);
    }

    public boolean isGratuityPaymentPlan() {
        return true;
    }

    protected Collection<PaymentPlanRule> getSpecificPaymentPlanRules() {
        return Collections.emptyList();
    }

    protected Set<Class<? extends GratuityPaymentPlan>> getPaymentPlansWhichHasPrecedence() {
        return Collections.EMPTY_SET;
    }

    public boolean hasPrecedenceOver(Class<? extends GratuityPaymentPlan> plan) {
        return this.getPaymentPlansWhichHasPrecedence().contains(plan);
    }
}

