/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.Exemption_Base;
import org.fenixedu.academic.domain.accounting.events.ExemptionJustification;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public abstract class Exemption
extends Exemption_Base {
    protected Exemption() {
        super.setRootDomainObject(Bennu.getInstance());
        super.setWhenCreated(new DateTime());
    }

    protected void init(Person responsible, Event event, ExemptionJustification exemptionJustification) {
        this.checkParameters(event, exemptionJustification);
        super.setResponsible(responsible);
        super.setEvent(event);
        super.setExemptionJustification(exemptionJustification);
    }

    private void checkParameters(Event event, ExemptionJustification exemptionJustification) {
        if (event == null) {
            throw new DomainException("error.accounting.Exemption.event.cannot.be.null", new String[0]);
        }
        if (exemptionJustification == null) {
            throw new DomainException("error.accounting.Exemption.exemptionJustification.cannot.be.null", new String[0]);
        }
    }

    public void setEvent(Event event) {
        throw new DomainException("error.domain.accounting.Exemption.cannot.modify.event", new String[0]);
    }

    public void setResponsible(Person responsible) {
        throw new DomainException("error.accounting.Exemption.cannot.modify.responsible", new String[0]);
    }

    public void setWhenCreated(DateTime whenCreated) {
        throw new DomainException("error.accounting.Exemption.cannot.modify.whenCreated", new String[0]);
    }

    public void setExemptionJustification(ExemptionJustification exemptionJustification) {
        throw new DomainException("error.accounting.Exemption.cannot.modify.exemptionJustification", new String[0]);
    }

    public void delete() {
        this.delete(true);
    }

    public void delete(boolean recalculateEventState) {
        this.setRootDomainObject(null);
        super.setResponsible(null);
        this.getExemptionJustification().delete();
        Event event = this.getEvent();
        super.setEvent(null);
        if (recalculateEventState) {
            event.recalculateState(new DateTime());
        }
        super.deleteDomainObject();
    }

    public void removeResponsible() {
        super.setResponsible(null);
    }

    public void removeEvent() {
        super.setEvent(null);
    }

    public LabelFormatter getDescription() {
        return this.getExemptionJustification().getDescription();
    }

    public String getReason() {
        return this.getExemptionJustification().getReason();
    }

    public boolean isAdministrativeOfficeFeeAndInsuranceExemption() {
        return false;
    }

    public boolean isAdministrativeOfficeFeeExemption() {
        return false;
    }

    public boolean isForAdministrativeOfficeFee() {
        return false;
    }

    public boolean isInsuranceExemption() {
        return false;
    }

    public boolean isForInsurance() {
        return false;
    }

    public boolean isAcademicEventExemption() {
        return false;
    }

    public boolean isGratuityExemption() {
        return false;
    }

    public boolean isPenaltyExemption() {
        return false;
    }

    public boolean isPhdEventExemption() {
        return false;
    }

    public boolean isSecondCycleIndividualCandidacyExemption() {
        return false;
    }

    static {
        Exemption.getRelationExemptionEvent().addListener((RelationListener)new RelationAdapter<Exemption, Event>(){

            public void beforeAdd(Exemption exemption, Event event) {
                if (event != null && !event.isExemptionAppliable()) {
                    throw new DomainException("error.accounting.Exemption.event.does.not.support.exemption", new String[0]);
                }
            }
        });
    }
}

