/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransactionDetail;
import org.fenixedu.academic.domain.accounting.AccountingTransaction_Base;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.PaymentMode;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class AccountingTransaction
extends AccountingTransaction_Base {
    public static Comparator<AccountingTransaction> COMPARATOR_BY_WHEN_REGISTERED = new Comparator<AccountingTransaction>(){

        @Override
        public int compare(AccountingTransaction leftAccountingTransaction, AccountingTransaction rightAccountingTransaction) {
            int comparationResult = leftAccountingTransaction.getWhenRegistered().compareTo((ReadableInstant)rightAccountingTransaction.getWhenRegistered());
            return comparationResult == 0 ? leftAccountingTransaction.getExternalId().compareTo(rightAccountingTransaction.getExternalId()) : comparationResult;
        }
    };

    protected AccountingTransaction() {
        super.setRootDomainObject(Bennu.getInstance());
    }

    public AccountingTransaction(User responsibleUser, Event event, Entry debit, Entry credit, AccountingTransactionDetail transactionDetail) {
        this();
        this.init(responsibleUser, event, debit, credit, transactionDetail);
    }

    private AccountingTransaction(User responsibleUser, Entry debit, Entry credit, AccountingTransactionDetail transactionDetail, AccountingTransaction transactionToAdjust) {
        this();
        this.init(responsibleUser, transactionToAdjust.getEvent(), debit, credit, transactionDetail, transactionToAdjust);
    }

    protected void init(User responsibleUser, Event event, Entry debit, Entry credit, AccountingTransactionDetail transactionDetail) {
        this.init(responsibleUser, event, debit, credit, transactionDetail, null);
    }

    protected void init(User responsibleUser, Event event, Entry debit, Entry credit, AccountingTransactionDetail transactionDetail, AccountingTransaction transactionToAdjust) {
        this.checkParameters(event, debit, credit);
        super.setEvent(event);
        super.setResponsibleUser(responsibleUser);
        super.addEntries(debit);
        super.addEntries(credit);
        super.setAdjustedTransaction(transactionToAdjust);
        super.setTransactionDetail(transactionDetail);
    }

    private void checkParameters(Event event, Entry debit, Entry credit) {
        if (event == null) {
            throw new DomainException("error.accounting.accountingTransaction.event.cannot.be.null", new String[0]);
        }
        if (debit == null) {
            throw new DomainException("error.accounting.accountingTransaction.debit.cannot.be.null", new String[0]);
        }
        if (credit == null) {
            throw new DomainException("error.accounting.accountingTransaction.credit.cannot.be.null", new String[0]);
        }
    }

    public void addEntries(Entry entries) {
        throw new DomainException("error.accounting.accountingTransaction.cannot.add.entries", new String[0]);
    }

    public Set<Entry> getEntriesSet() {
        return Collections.unmodifiableSet(super.getEntriesSet());
    }

    public void removeEntries(Entry entries) {
        throw new DomainException("error.accounting.accountingTransaction.cannot.remove.entries", new String[0]);
    }

    public void setEvent(Event event) {
        super.setEvent(event);
    }

    public void setResponsibleUser(User responsibleUser) {
        throw new DomainException("error.accounting.accountingTransaction.cannot.modify.responsibleUser", new String[0]);
    }

    public void setAdjustedTransaction(AccountingTransaction adjustedTransaction) {
        throw new DomainException("error.accounting.accountingTransaction.cannot.modify.adjustedTransaction", new String[0]);
    }

    public void setTransactionDetail(AccountingTransactionDetail transactionDetail) {
        throw new DomainException("error.accounting.AccountingTransaction.cannot.modify.transactionDetail", new String[0]);
    }

    public void addAdjustmentTransactions(AccountingTransaction accountingTransaction) {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.AccountingTransaction.cannot.add.accountingTransaction", new String[0]);
    }

    public Set<AccountingTransaction> getAdjustmentTransactionsSet() {
        return Collections.unmodifiableSet(super.getAdjustmentTransactionsSet());
    }

    public void removeAdjustmentTransactions(AccountingTransaction adjustmentTransactions) {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.AccountingTransaction.cannot.remove.accountingTransaction", new String[0]);
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        return this.getEvent().getDescriptionForEntryType(entryType);
    }

    public Account getFromAccount() {
        return this.getEntry(false).getAccount();
    }

    public Account getToAccount() {
        return this.getEntry(true).getAccount();
    }

    public Entry getToAccountEntry() {
        return this.getEntry(true);
    }

    public Entry getFromAccountEntry() {
        return this.getEntry(false);
    }

    private Entry getEntry(boolean positive) {
        for (Entry entry : this.getEntriesSet()) {
            if (entry.isPositiveAmount() != positive) continue;
            return entry;
        }
        throw new DomainException("error.accounting.accountingTransaction.transaction.data.is.corrupted", new String[0]);
    }

    public AccountingTransaction reimburse(User responsibleUser, PaymentMode paymentMode, Money amountToReimburse) {
        return this.reimburse(responsibleUser, paymentMode, amountToReimburse, null);
    }

    public AccountingTransaction reimburse(User responsibleUser, PaymentMode paymentMode, Money amountToReimburse, String comments) {
        return this.reimburse(responsibleUser, paymentMode, amountToReimburse, comments, true);
    }

    public AccountingTransaction reimburse(User responsibleUser, PaymentMode paymentMode, Money amountToReimburse, DateTime reimburseDate, String comments) {
        return this.reimburse(responsibleUser, paymentMode, amountToReimburse, comments, true, reimburseDate);
    }

    public AccountingTransaction reimburseWithoutRules(User responsibleUser, PaymentMode paymentMode, Money amountToReimburse) {
        return this.reimburseWithoutRules(responsibleUser, paymentMode, amountToReimburse, null);
    }

    public AccountingTransaction reimburseWithoutRules(User responsibleUser, PaymentMode paymentMode, Money amountToReimburse, String comments) {
        return this.reimburse(responsibleUser, paymentMode, amountToReimburse, comments, false);
    }

    public void annul(User responsibleUser, String reason) {
        if (StringUtils.isEmpty((String)reason)) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.AccountingTransaction.cannot.annul.without.reason", new String[0]);
        }
        this.checkRulesToAnnul();
        this.reimburseWithoutRules(responsibleUser, this.getTransactionDetail().getPaymentMode(), this.getAmountWithAdjustment(), reason);
    }

    private void checkRulesToAnnul() {
        if (this.getToAccountEntry().isAssociatedToAnyActiveReceipt()) {
            throw new DomainException("error.accounting.AccountingTransaction.cannot.annul.while.associated.to.active.receipt", new String[0]);
        }
    }

    private AccountingTransaction reimburse(User responsibleUser, PaymentMode paymentMode, Money amountToReimburse, String comments, boolean checkRules) {
        return this.reimburse(responsibleUser, paymentMode, amountToReimburse, comments, checkRules, new DateTime());
    }

    private AccountingTransaction reimburse(User responsibleUser, PaymentMode paymentMode, Money amountToReimburse, String comments, boolean checkRules, DateTime reimburseDate) {
        if (checkRules && !this.canApplyReimbursement(amountToReimburse)) {
            throw new DomainException("error.accounting.AccountingTransaction.cannot.reimburse.events.that.may.open", new String[0]);
        }
        if (!this.getToAccountEntry().canApplyReimbursement(amountToReimburse)) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.AccountingTransaction.amount.to.reimburse.exceeds.entry.amount", this.getToAccountEntry().getDescription());
        }
        AccountingTransaction transaction = new AccountingTransaction(responsibleUser, new Entry(EntryType.ADJUSTMENT, amountToReimburse.negate(), this.getToAccount()), new Entry(EntryType.ADJUSTMENT, amountToReimburse, this.getFromAccount()), new AccountingTransactionDetail(reimburseDate, paymentMode, comments), this);
        this.getEvent().recalculateState(this.getWhenRegistered());
        return transaction;
    }

    public DateTime getWhenRegistered() {
        return this.getTransactionDetail().getWhenRegistered();
    }

    public DateTime getWhenProcessed() {
        return this.getTransactionDetail().getWhenProcessed();
    }

    public String getComments() {
        return this.getTransactionDetail().getComments();
    }

    public boolean isPayed(int civilYear) {
        return this.getWhenRegistered().getYear() == civilYear;
    }

    public boolean isAdjustingTransaction() {
        return this.getAdjustedTransaction() != null;
    }

    public boolean hasBeenAdjusted() {
        return !this.getAdjustmentTransactionsSet().isEmpty();
    }

    public Entry getEntryFor(Account account) {
        for (Entry accountingEntry : this.getEntriesSet()) {
            if (accountingEntry.getAccount() != account) continue;
            return accountingEntry;
        }
        throw new DomainException("error.accounting.accountingTransaction.transaction.data.is.corrupted.because.no.entry.belongs.to.account", new String[0]);
    }

    private boolean canApplyReimbursement(Money amount) {
        return this.getEvent().canApplyReimbursement(amount);
    }

    public boolean isSourceAccountFromParty(Party party) {
        return this.getFromAccount().getParty() == party;
    }

    public void delete() {
        super.setAdjustedTransaction(null);
        while (!this.getAdjustmentTransactionsSet().isEmpty()) {
            this.getAdjustmentTransactionsSet().iterator().next().delete();
        }
        if (this.getTransactionDetail() != null) {
            this.getTransactionDetail().delete();
        }
        while (!this.getEntriesSet().isEmpty()) {
            this.getEntriesSet().iterator().next().delete();
        }
        super.setResponsibleUser(null);
        super.setEvent(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public Money getAmountWithAdjustment() {
        return this.getToAccountEntry().getAmountWithAdjustment();
    }

    public boolean isInsidePeriod(YearMonthDay startDate, YearMonthDay endDate) {
        return this.isInsidePeriod(startDate.toLocalDate(), endDate.toLocalDate());
    }

    public boolean isInsidePeriod(LocalDate startDate, LocalDate endDate) {
        return !this.getWhenRegistered().toLocalDate().isBefore((ReadablePartial)startDate) && !this.getWhenRegistered().toLocalDate().isAfter((ReadablePartial)endDate);
    }

    public boolean isInstallment() {
        return false;
    }

    public PaymentMode getPaymentMode() {
        return this.getTransactionDetail().getPaymentMode();
    }

    public Money getOriginalAmount() {
        return this.getToAccountEntry().getOriginalAmount();
    }
}

