/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Comparator;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.academic.domain.GroupsAndShiftsManagementLog;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.StudentGroup_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class StudentGroup
extends StudentGroup_Base {
    public static final Comparator<StudentGroup> COMPARATOR_BY_GROUP_NUMBER = new BeanComparator("groupNumber");

    public boolean wasDeleted() {
        return this.getValid() == false;
    }

    public StudentGroup() {
        super.setValid(Boolean.valueOf(true));
        this.setRootDomainObject(Bennu.getInstance());
    }

    public StudentGroup(Integer groupNumber, Grouping grouping) {
        this();
        super.setGroupNumber(groupNumber);
        super.setGrouping(grouping);
    }

    public StudentGroup(Integer groupNumber, Grouping grouping, Shift shift) {
        this();
        super.setGroupNumber(groupNumber);
        super.setGrouping(grouping);
        super.setShift(shift);
    }

    public void delete() {
        List<ExecutionCourse> ecs = this.getGrouping().getExecutionCourses();
        for (ExecutionCourse ec : ecs) {
            GroupsAndShiftsManagementLog.createLog(ec, "resources.MessagingResources", "log.executionCourse.groupAndShifts.grouping.group.removed", this.getGroupNumber().toString(), this.getGrouping().getName(), ec.getNome(), ec.getDegreePresentationString());
        }
        if (!this.getProjectSubmissionsSet().isEmpty() && this.getGrouping().isPersonTeacher(AccessControl.getPerson())) {
            this.setValid(false);
        } else if (this.getProjectSubmissionsSet().isEmpty() && this.getAttendsSet().isEmpty()) {
            if (this.getStudentGroupGroup() != null) {
                this.setValid(false);
            } else {
                this.setShift(null);
                this.setGrouping(null);
                this.setRootDomainObject(null);
                this.deleteDomainObject();
            }
        } else {
            throw new DomainException("student.group.cannot.be.deleted", new String[0]);
        }
    }

    public void editShift(Shift shift) {
        if (this.getGrouping().getShiftType() == null || !shift.containsType(this.getGrouping().getShiftType())) {
            throw new DomainException(((Object)((Object)this)).getClass().getName(), "");
        }
        this.setShift(shift);
    }

    public boolean isPersonInStudentGroup(Person person) {
        for (Attends attend : this.getAttendsSet()) {
            if (!attend.getRegistration().getStudent().getPerson().equals((Object)person)) continue;
            return true;
        }
        return false;
    }

    static {
        StudentGroup.getRelationStudentGroupAttend().addListener((RelationListener)new StudentGroupAttendListener());
    }

    private static class StudentGroupAttendListener
    extends RelationAdapter<StudentGroup, Attends> {
        private StudentGroupAttendListener() {
        }

        public void beforeRemove(StudentGroup studentGroup, Attends attends) {
            if (!studentGroup.getProjectSubmissionsSet().isEmpty() && !studentGroup.getGrouping().isPersonTeacher(AccessControl.getPerson())) {
                throw new DomainException("error.studentGroup.cannotRemoveAttendsBecauseAlreadyHasProjectSubmissions", new String[0]);
            }
            super.beforeRemove((DomainObject)studentGroup, (DomainObject)attends);
        }
    }
}

