/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.OptionalEnrolment_Base;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curriculum.EnrollmentCondition;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.OptionalCurricularCourse;
import org.fenixedu.academic.domain.enrolment.EnroledOptionalEnrolment;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.log.OptionalEnrolmentLog;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.util.EnrolmentAction;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.security.Authenticate;

public class OptionalEnrolment
extends OptionalEnrolment_Base {
    protected OptionalEnrolment() {
    }

    public OptionalEnrolment(StudentCurricularPlan studentCurricularPlan, CurriculumGroup curriculumGroup, CurricularCourse curricularCourse, ExecutionSemester executionSemester, EnrollmentCondition enrolmentCondition, String createdBy, OptionalCurricularCourse optionalCurricularCourse) {
        if (studentCurricularPlan == null || curriculumGroup == null || curricularCourse == null || executionSemester == null || enrolmentCondition == null || createdBy == null || optionalCurricularCourse == null) {
            throw new DomainException("invalid arguments", new String[0]);
        }
        this.checkInitConstraints(studentCurricularPlan, curricularCourse, executionSemester, optionalCurricularCourse);
        this.initializeAsNew(studentCurricularPlan, curriculumGroup, curricularCourse, executionSemester, enrolmentCondition, createdBy);
        this.setOptionalCurricularCourse(optionalCurricularCourse);
        this.createCurriculumLineLog(EnrolmentAction.ENROL);
    }

    protected void checkInitConstraints(StudentCurricularPlan studentCurricularPlan, CurricularCourse curricularCourse, ExecutionSemester executionSemester, OptionalCurricularCourse optionalCurricularCourse) {
        super.checkInitConstraints(studentCurricularPlan, curricularCourse, executionSemester);
        OptionalEnrolment optionalEnrolment = (OptionalEnrolment)((Object)studentCurricularPlan.findEnrolmentFor((CurricularCourse)((Object)optionalCurricularCourse), executionSemester));
        if (optionalEnrolment != null && optionalEnrolment.isValid(executionSemester)) {
            throw new DomainException("error.OptionalEnrolment.duplicate.enrolment", optionalCurricularCourse.getName());
        }
    }

    protected void createCurriculumLineLog(EnrolmentAction action) {
        new OptionalEnrolmentLog(action, this.getRegistration(), this.getCurricularCourse(), this.getOptionalCurricularCourse(), this.getExecutionPeriod(), this.getCurrentUser());
    }

    public final boolean isApproved(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        if (executionSemester == null || this.getExecutionPeriod().isBeforeOrEquals(executionSemester)) {
            return this.isApproved() && this.hasCurricularCourseOrOptionalCurricularCourse(curricularCourse, executionSemester);
        }
        return false;
    }

    private boolean hasCurricularCourseOrOptionalCurricularCourse(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return this.hasCurricularCourse(this.getCurricularCourse(), curricularCourse, executionSemester) || this.hasCurricularCourse((CurricularCourse)((Object)this.getOptionalCurricularCourse()), curricularCourse, executionSemester);
    }

    public final boolean isEnroledInExecutionPeriod(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return this.getExecutionPeriod().equals(executionSemester) && (this.getCurricularCourse().equals((Object)curricularCourse) || this.getOptionalCurricularCourse().equals((Object)curricularCourse));
    }

    public boolean isOptional() {
        return true;
    }

    public MultiLanguageString getName() {
        ExecutionSemester executionSemester = this.getExecutionPeriod();
        return new MultiLanguageString().with(MultiLanguageString.pt, this.getOptionalCurricularCourse().getName(executionSemester)).with(MultiLanguageString.en, this.getOptionalCurricularCourse().getNameEn(executionSemester));
    }

    public MultiLanguageString getPresentationName() {
        String namePt = String.format("%s (%s)", this.getOptionalCurricularCourse().getName(this.getExecutionPeriod()), this.getCurricularCourse().getName(this.getExecutionPeriod()));
        String nameEn = String.format("%s (%s)", this.getOptionalCurricularCourse().getNameEn(this.getExecutionPeriod()), this.getCurricularCourse().getNameEn(this.getExecutionPeriod()));
        return new MultiLanguageString().with(MultiLanguageString.pt, namePt).with(MultiLanguageString.en, nameEn);
    }

    public boolean hasDegreeModule(DegreeModule degreeModule) {
        return super.hasDegreeModule(degreeModule) || this.hasOptionalCurricularCourse(degreeModule);
    }

    private boolean hasOptionalCurricularCourse(DegreeModule degreeModule) {
        return this.getOptionalCurricularCourse() == degreeModule;
    }

    protected void deleteInformation() {
        super.deleteInformation();
        this.setOptionalCurricularCourse(null);
    }

    public Set<IDegreeModuleToEvaluate> getDegreeModulesToEvaluate(ExecutionSemester executionSemester) {
        if (this.isValid(executionSemester) && this.isEnroled()) {
            HashSet<IDegreeModuleToEvaluate> result = new HashSet<IDegreeModuleToEvaluate>(1);
            result.add(new EnroledOptionalEnrolment((CurriculumModule)((Object)this), this.getOptionalCurricularCourse(), executionSemester));
            return result;
        }
        return Collections.emptySet();
    }

    static OptionalEnrolment createBasedOn(Enrolment enrolment, CurriculumGroup curriculumGroup, OptionalCurricularCourse optionalCurricularCourse) {
        OptionalEnrolment.checkParameters(enrolment, curriculumGroup, optionalCurricularCourse);
        OptionalEnrolment optionalEnrolment = new OptionalEnrolment();
        optionalEnrolment.setCurricularCourse(enrolment.getCurricularCourse());
        optionalEnrolment.setWeigth(enrolment.getWeigth());
        optionalEnrolment.setEnrollmentState(enrolment.getEnrollmentState());
        optionalEnrolment.setExecutionPeriod(enrolment.getExecutionPeriod());
        optionalEnrolment.setEvaluationSeason(enrolment.getEvaluationSeason());
        optionalEnrolment.setCreatedBy(Authenticate.getUser().getUsername());
        optionalEnrolment.setCreationDateDateTime(enrolment.getCreationDateDateTime());
        optionalEnrolment.setEnrolmentCondition(enrolment.getEnrolmentCondition());
        optionalEnrolment.setCurriculumGroup(curriculumGroup);
        optionalEnrolment.setOptionalCurricularCourse(optionalCurricularCourse);
        optionalEnrolment.getEvaluationsSet().addAll(enrolment.getEvaluationsSet());
        optionalEnrolment.getProgramCertificateRequestsSet().addAll(enrolment.getProgramCertificateRequestsSet());
        optionalEnrolment.getCourseLoadRequestsSet().addAll(enrolment.getCourseLoadRequestsSet());
        optionalEnrolment.getExtraExamRequestsSet().addAll(enrolment.getExtraExamRequestsSet());
        optionalEnrolment.getEnrolmentWrappersSet().addAll(enrolment.getEnrolmentWrappersSet());
        optionalEnrolment.getThesesSet().addAll(enrolment.getThesesSet());
        optionalEnrolment.getExamDateCertificateRequestsSet().addAll(enrolment.getExamDateCertificateRequestsSet());
        OptionalEnrolment.changeAttends((Enrolment)enrolment, (Enrolment)((Object)optionalEnrolment));
        optionalEnrolment.createCurriculumLineLog(EnrolmentAction.ENROL);
        return optionalEnrolment;
    }

    private static void checkParameters(Enrolment enrolment, CurriculumGroup curriculumGroup, OptionalCurricularCourse optionalCurricularCourse) {
        if (enrolment == null || enrolment.isOptional()) {
            throw new DomainException("error.OptionalEnrolment.invalid.enrolment", new String[0]);
        }
        if (curriculumGroup == null) {
            throw new DomainException("error.OptionalEnrolment.invalid.curriculumGroup", new String[0]);
        }
        if (optionalCurricularCourse == null) {
            throw new DomainException("error.OptionalEnrolment.invalid.optional.curricularCourse", new String[0]);
        }
    }
}

