/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jvstm.cps.ConsistencyPredicate;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.fenixedu.academic.domain.CourseLoad;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.FrequencyType;
import org.fenixedu.academic.domain.Holiday;
import org.fenixedu.academic.domain.LessonInstance;
import org.fenixedu.academic.domain.Lesson_Base;
import org.fenixedu.academic.domain.OccupationPeriod;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.Summary;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.space.LessonInstanceSpaceOccupation;
import org.fenixedu.academic.domain.space.LessonSpaceOccupation;
import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.util.icalendar.ClassEventBean;
import org.fenixedu.academic.domain.util.icalendar.EventBean;
import org.fenixedu.academic.dto.GenericPair;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.ResourceAllocationRolePredicates;
import org.fenixedu.academic.util.DiaSemana;
import org.fenixedu.academic.util.HourMinuteSecond;
import org.fenixedu.academic.util.WeekDay;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.Weeks;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.DomainObject;

public class Lesson
extends Lesson_Base {
    public static int NUMBER_OF_MINUTES_IN_HOUR = 60;
    public static int NUMBER_OF_DAYS_IN_WEEK = 7;
    public static final Comparator<Lesson> LESSON_COMPARATOR_BY_WEEKDAY_AND_STARTTIME = new Comparator<Lesson>(){

        @Override
        public int compare(Lesson o1, Lesson o2) {
            int cd = o1.getDiaSemana().getDiaSemana().compareTo(o2.getDiaSemana().getDiaSemana());
            if (cd != 0) {
                return cd;
            }
            int cb = o1.getBeginHourMinuteSecond().compareTo(o2.getBeginHourMinuteSecond());
            if (cb != 0) {
                return cb;
            }
            return DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2);
        }
    };

    public Lesson(DiaSemana diaSemana, Calendar inicio, Calendar fim, Shift shift, FrequencyType frequency, ExecutionSemester executionSemester, OccupationPeriod period, Space room) {
        if (shift != null) {
            GenericPair<YearMonthDay, YearMonthDay> maxLessonsPeriod = shift.getExecutionCourse().getMaxLessonsPeriod();
            if (period == null || period.getStartYearMonthDay().isBefore((ReadablePartial)maxLessonsPeriod.getLeft())) {
                throw new DomainException("error.Lesson.invalid.begin.date", new String[0]);
            }
            if (period.getEndYearMonthDayWithNextPeriods().isAfter((ReadablePartial)maxLessonsPeriod.getRight())) {
                throw new DomainException("error.invalid.new.date", new String[0]);
            }
        }
        this.setRootDomainObject(Bennu.getInstance());
        this.setDiaSemana(diaSemana);
        this.setInicio(inicio);
        this.setFim(fim);
        this.setShift(shift);
        this.setFrequency(frequency);
        this.setPeriod(period);
        this.checkShiftLoad(shift);
        if (room != null) {
            new LessonSpaceOccupation(room, this);
        }
    }

    public Lesson(DiaSemana diaSemana, Calendar inicio, Calendar fim, Shift shift, FrequencyType frequency, ExecutionSemester executionSemester, YearMonthDay beginDate, YearMonthDay endDate, Space room) {
        OccupationPeriod period = null;
        if (shift != null) {
            ExecutionCourse executionCourse = shift.getExecutionCourse();
            GenericPair<YearMonthDay, YearMonthDay> maxLessonsPeriod = executionCourse.getMaxLessonsPeriod();
            if (beginDate == null || beginDate.isBefore((ReadablePartial)maxLessonsPeriod.getLeft())) {
                throw new DomainException("error.Lesson.invalid.begin.date", new String[0]);
            }
            if (endDate == null || endDate.isAfter((ReadablePartial)maxLessonsPeriod.getRight())) {
                throw new DomainException("error.invalid.new.date", new String[0]);
            }
            period = OccupationPeriod.createOccupationPeriodForLesson(executionCourse, beginDate, endDate);
        }
        this.setRootDomainObject(Bennu.getInstance());
        this.setDiaSemana(diaSemana);
        this.setInicio(inicio);
        this.setFim(fim);
        this.setShift(shift);
        this.setFrequency(frequency);
        this.setPeriod(period);
        this.checkShiftLoad(shift);
        if (room != null) {
            new LessonSpaceOccupation(room, this);
        }
    }

    public void edit(YearMonthDay newBeginDate, YearMonthDay newEndDate, DiaSemana diaSemana, Calendar inicio, Calendar fim, FrequencyType frequency, Boolean createLessonInstances, Space newRoom) {
        AccessControl.check(this, ResourceAllocationRolePredicates.checkPermissionsToManageLessons);
        if (newBeginDate != null && newEndDate != null && newBeginDate.isAfter((ReadablePartial)newEndDate)) {
            throw new DomainException("error.Lesson.new.begin.date.after.new.end.date", new String[0]);
        }
        GenericPair<YearMonthDay, YearMonthDay> maxLessonsPeriod = this.getShift().getExecutionCourse().getMaxLessonsPeriod();
        if (newBeginDate == null || newBeginDate.isBefore((ReadablePartial)maxLessonsPeriod.getLeft())) {
            throw new DomainException("error.Lesson.invalid.new.begin.date", new String[0]);
        }
        if (newEndDate == null || newEndDate.isAfter((ReadablePartial)maxLessonsPeriod.getRight())) {
            throw new DomainException("error.invalid.new.end.date", new String[0]);
        }
        this.refreshPeriodAndInstancesInEditOperation(newBeginDate, newEndDate, createLessonInstances, maxLessonsPeriod);
        if (this.wasFinished() && (this.getLessonSpaceOccupation() != null || !this.hasAnyLessonInstances())) {
            throw new DomainException("error.Lesson.empty.period", new String[0]);
        }
        this.setDiaSemana(diaSemana);
        this.setInicio(inicio);
        this.setFim(fim);
        this.setFrequency(frequency);
        this.checkShiftLoad(this.getShift());
        this.lessonSpaceOccupationManagement(newRoom);
    }

    public void edit(Space newRoom) {
        AccessControl.check(this, ResourceAllocationRolePredicates.checkPermissionsToManageLessons);
        this.lessonSpaceOccupationManagement(newRoom);
    }

    public void delete() {
        AccessControl.check(this, ResourceAllocationRolePredicates.checkPermissionsToManageLessons);
        Shift shift = this.getShift();
        boolean isLastLesson = this.isLastLesson(shift);
        if (isLastLesson && shift.hasAnyStudentsInAssociatedStudentGroups()) {
            throw new DomainException("error.deleteLesson.with.Shift.with.studentGroups", this.prettyPrint());
        }
        if (isLastLesson && !shift.getStudentsSet().isEmpty()) {
            throw new DomainException("error.deleteLesson.with.Shift.with.students", this.prettyPrint());
        }
        if (this.hasAnyAssociatedSummaries()) {
            throw new DomainException("error.deleteLesson.with.summaries", this.prettyPrint());
        }
        OccupationPeriod period = this.getPeriod();
        super.setPeriod(null);
        if (period != null) {
            period.delete();
        }
        if (this.getLessonSpaceOccupation() != null) {
            this.getLessonSpaceOccupation().delete();
        }
        while (this.hasAnyLessonInstances()) {
            ((LessonInstance)((Object)this.getLessonInstancesSet().iterator().next())).delete();
        }
        super.setShift(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    private boolean isLastLesson(Shift shift) {
        for (Lesson lesson : shift.getAssociatedLessonsSet()) {
            if (lesson == this) continue;
            return false;
        }
        return true;
    }

    @ConsistencyPredicate
    protected boolean checkRequiredParameters() {
        return this.getFrequency() != null && this.getDiaSemana() != null;
    }

    @ConsistencyPredicate
    protected boolean checkTimeInterval() {
        HourMinuteSecond start = this.getBeginHourMinuteSecond();
        HourMinuteSecond end = this.getEndHourMinuteSecond();
        return start != null && end != null && start.isBefore(end);
    }

    private void lessonSpaceOccupationManagement(Space newRoom) {
        LessonSpaceOccupation lessonSpaceOccupation = this.getLessonSpaceOccupation();
        if (newRoom != null) {
            if (!this.wasFinished()) {
                if (lessonSpaceOccupation == null) {
                    lessonSpaceOccupation = new LessonSpaceOccupation(newRoom, this);
                } else {
                    lessonSpaceOccupation.edit(newRoom);
                }
            }
        } else if (lessonSpaceOccupation != null) {
            lessonSpaceOccupation.delete();
        }
        for (LessonInstance lessonInstance : this.getLessonInstancesSet()) {
            if (!lessonInstance.getDay().isAfter((ReadablePartial)new LocalDate())) continue;
            if (newRoom == null) {
                lessonInstance.setLessonInstanceSpaceOccupation(null);
                continue;
            }
            LessonInstanceSpaceOccupation allocation = (LessonInstanceSpaceOccupation)SpaceUtils.getFirstOccurrenceOfResourceAllocationByClass(newRoom, this);
            if (allocation == null) {
                allocation = new LessonInstanceSpaceOccupation(newRoom);
            }
            allocation.edit(lessonInstance);
        }
    }

    public void setShift(Shift shift) {
        if (shift == null) {
            throw new DomainException("error.Lesson.empty.shift", new String[0]);
        }
        super.setShift(shift);
    }

    public void setFrequency(FrequencyType frequency) {
        if (frequency == null) {
            throw new DomainException("error.Lesson.empty.type", new String[0]);
        }
        super.setFrequency(frequency);
    }

    public void setPeriod(OccupationPeriod period) {
        if (period == null) {
            throw new DomainException("error.Lesson.empty.period", new String[0]);
        }
        super.setPeriod(period);
    }

    public boolean wasFinished() {
        return this.getPeriod() == null;
    }

    public ExecutionCourse getExecutionCourse() {
        return this.getShift().getExecutionCourse();
    }

    public ExecutionSemester getExecutionPeriod() {
        return this.getShift().getExecutionPeriod();
    }

    public Space getSala() {
        if (this.getLessonSpaceOccupation() != null) {
            return this.getLessonSpaceOccupation().getRoom();
        }
        if (this.hasAnyLessonInstances() && this.wasFinished()) {
            return this.getLastLessonInstance().getRoom();
        }
        return null;
    }

    public boolean hasSala() {
        return this.getSala() != null;
    }

    public void deleteLessonInstanceIn(YearMonthDay day) {
        if (day == null) {
            return;
        }
        LessonInstance lessonInstance = this.getLessonInstanceFor(day);
        if (lessonInstance == null) {
            throw new UnsupportedOperationException();
        }
        lessonInstance.delete();
    }

    public void refreshPeriodAndInstancesInSummaryCreation(YearMonthDay newBeginDate) {
        if (!this.wasFinished() && newBeginDate != null && newBeginDate.isAfter((ReadablePartial)this.getPeriod().getStartYearMonthDay())) {
            SortedSet<YearMonthDay> instanceDates = this.getAllLessonInstancesDatesToCreate(this.getLessonStartDay(), newBeginDate.minusDays(1), true);
            YearMonthDay newEndDate = this.getPeriod().getLastOccupationPeriodOfNestedPeriods().getEndYearMonthDay();
            if (!newBeginDate.isAfter((ReadablePartial)newEndDate)) {
                this.refreshPeriod(newBeginDate, this.getPeriod().getLastOccupationPeriodOfNestedPeriods().getEndYearMonthDay());
            } else {
                OccupationPeriod period = this.getPeriod();
                this.removeLessonSpaceOccupationAndPeriod();
                period.delete();
            }
            this.createAllLessonInstances(instanceDates);
        }
    }

    private void refreshPeriodAndInstancesInEditOperation(YearMonthDay newBeginDate, YearMonthDay newEndDate, Boolean createLessonInstances, GenericPair<YearMonthDay, YearMonthDay> maxLessonsPeriod) {
        this.removeExistentInstancesWithoutSummaryAfterOrEqual(newBeginDate);
        SortedSet<YearMonthDay> instanceDates = this.getAllLessonInstancesDatesToCreate(this.getLessonStartDay(), newBeginDate.minusDays(1), createLessonInstances);
        this.refreshPeriod(newBeginDate, newEndDate);
        this.createAllLessonInstances(instanceDates);
    }

    private void createAllLessonInstances(SortedSet<YearMonthDay> instanceDates) {
        for (YearMonthDay day : instanceDates) {
            new LessonInstance(this, day);
        }
    }

    private SortedSet<YearMonthDay> getAllLessonInstancesDatesToCreate(YearMonthDay startDate, YearMonthDay endDate, Boolean createLessonInstances) {
        if (startDate != null && endDate != null && !startDate.isAfter((ReadablePartial)endDate) && createLessonInstances.booleanValue()) {
            SortedSet<YearMonthDay> possibleLessonDates = this.getAllValidLessonDatesWithoutInstancesDates(startDate, endDate);
            List<LessonInstance> allLessonInstancesUntil = this.getAllLessonInstancesUntil(endDate.toLocalDate());
            for (LessonInstance lessonInstance : allLessonInstancesUntil) {
                possibleLessonDates.remove(lessonInstance.getDay());
            }
            return possibleLessonDates;
        }
        return new TreeSet<YearMonthDay>();
    }

    private void removeExistentInstancesWithoutSummaryAfterOrEqual(YearMonthDay newBeginDate) {
        Map<Boolean, List<LessonInstance>> instances = this.getLessonInstancesAfterOrEqual(newBeginDate);
        if (instances.get(Boolean.TRUE).isEmpty()) {
            List<LessonInstance> instancesWithoutSummary = instances.get(Boolean.FALSE);
            Iterator<LessonInstance> iter = instancesWithoutSummary.iterator();
            while (iter.hasNext()) {
                LessonInstance instance = iter.next();
                iter.remove();
                instance.delete();
            }
        } else {
            throw new DomainException("error.Lesson.invalid.new.begin.date", new String[0]);
        }
    }

    private Map<Boolean, List<LessonInstance>> getLessonInstancesAfterOrEqual(YearMonthDay day) {
        HashMap<Boolean, List<LessonInstance>> result = new HashMap<Boolean, List<LessonInstance>>();
        result.put(Boolean.TRUE, new ArrayList());
        result.put(Boolean.FALSE, new ArrayList());
        if (day != null) {
            Set lessonInstances = this.getLessonInstancesSet();
            for (LessonInstance lessonInstance : lessonInstances) {
                List list;
                if (lessonInstance.getSummary() != null && !lessonInstance.getDay().isBefore((ReadablePartial)day)) {
                    list = (List)result.get(Boolean.TRUE);
                    list.add(lessonInstance);
                    continue;
                }
                if (lessonInstance.getSummary() != null || lessonInstance.getDay().isBefore((ReadablePartial)day)) continue;
                list = (List)result.get(Boolean.FALSE);
                list.add(lessonInstance);
            }
        }
        return result;
    }

    private void refreshPeriod(YearMonthDay newBeginDate, YearMonthDay newEndDate) {
        if (newBeginDate != null && newEndDate != null && !newBeginDate.isAfter((ReadablePartial)newEndDate)) {
            OccupationPeriod currentPeriod;
            boolean newPeriod = false;
            OccupationPeriod oldFirstPeriod = currentPeriod = this.getPeriod();
            if (currentPeriod == null || currentPeriod.getNextPeriod() == null) {
                this.setPeriod(new OccupationPeriod(newBeginDate, newEndDate));
                newPeriod = true;
            } else {
                while (currentPeriod != null) {
                    if (currentPeriod.getStartYearMonthDay().isAfter((ReadablePartial)newEndDate)) {
                        newPeriod = false;
                        break;
                    }
                    if (!currentPeriod.getEndYearMonthDay().isBefore((ReadablePartial)newBeginDate)) {
                        if (!currentPeriod.getStartYearMonthDay().isAfter((ReadablePartial)newBeginDate)) {
                            this.setPeriod(this.getNewNestedPeriods(currentPeriod, newBeginDate, newEndDate));
                        } else if (currentPeriod.equals((Object)oldFirstPeriod)) {
                            this.setPeriod(this.getNewNestedPeriods(currentPeriod, newBeginDate, newEndDate));
                        } else {
                            this.setPeriod(this.getNewNestedPeriods(currentPeriod, currentPeriod.getStartYearMonthDay(), newEndDate));
                        }
                        newPeriod = true;
                        break;
                    }
                    currentPeriod = currentPeriod.getNextPeriod();
                }
            }
            if (!newPeriod) {
                this.removeLessonSpaceOccupationAndPeriod();
            }
            if (oldFirstPeriod != null) {
                oldFirstPeriod.delete();
            }
        }
    }

    private OccupationPeriod getNewNestedPeriods(OccupationPeriod currentPeriod, YearMonthDay newBeginDate, YearMonthDay newEndDate) {
        OccupationPeriod newPeriod;
        if (!currentPeriod.getEndYearMonthDay().isBefore((ReadablePartial)newEndDate)) {
            return new OccupationPeriod(newBeginDate, newEndDate);
        }
        OccupationPeriod newPeriodPointer = newPeriod = new OccupationPeriod(newBeginDate, currentPeriod.getEndYearMonthDay());
        while (currentPeriod.getNextPeriod() != null && !currentPeriod.getNextPeriod().getStartYearMonthDay().isAfter((ReadablePartial)newEndDate)) {
            OccupationPeriod newNextPeriod;
            if (!currentPeriod.getNextPeriod().getEndYearMonthDay().isBefore((ReadablePartial)newEndDate)) {
                newNextPeriod = new OccupationPeriod(currentPeriod.getNextPeriod().getStartYearMonthDay(), newEndDate);
                newPeriodPointer.setNextPeriod(newNextPeriod);
                break;
            }
            newNextPeriod = new OccupationPeriod(currentPeriod.getNextPeriod().getStartYearMonthDay(), currentPeriod.getNextPeriod().getEndYearMonthDay());
            newPeriodPointer.setNextPeriod(newNextPeriod);
            newPeriodPointer = newNextPeriod;
            currentPeriod = currentPeriod.getNextPeriod();
        }
        return newPeriod;
    }

    private void removeLessonSpaceOccupationAndPeriod() {
        if (this.getLessonSpaceOccupation() != null) {
            this.getLessonSpaceOccupation().delete();
        }
        super.setPeriod(null);
    }

    public LessonSpaceOccupation getRoomOccupation() {
        return this.getLessonSpaceOccupation();
    }

    private int getUnitMinutes() {
        return Minutes.minutesBetween((ReadablePartial)this.getBeginHourMinuteSecond(), (ReadablePartial)this.getEndHourMinuteSecond()).getMinutes();
    }

    public BigDecimal getTotalHours() {
        return this.getUnitHours().multiply(BigDecimal.valueOf(this.getFinalNumberOfLessonInstances()));
    }

    public Duration getTotalDuration() {
        return Minutes.minutesBetween((ReadablePartial)this.getBeginHourMinuteSecond(), (ReadablePartial)this.getEndHourMinuteSecond()).toStandardDuration();
    }

    public BigDecimal getUnitHours() {
        return BigDecimal.valueOf(this.getUnitMinutes()).divide(BigDecimal.valueOf(NUMBER_OF_MINUTES_IN_HOUR), 2, RoundingMode.HALF_UP);
    }

    public String getInicioString() {
        return String.valueOf(this.getInicio().get(11));
    }

    public String getFimString() {
        return String.valueOf(this.getFim().get(11));
    }

    public double hoursAfter(int hour) {
        HourMinuteSecond afterHour = new HourMinuteSecond(hour, 0, 0);
        if (!this.getBeginHourMinuteSecond().isBefore(afterHour)) {
            return this.getUnitHours().doubleValue();
        }
        if (this.getEndHourMinuteSecond().isAfter(afterHour)) {
            return BigDecimal.valueOf(Minutes.minutesBetween((ReadablePartial)afterHour, (ReadablePartial)this.getEndHourMinuteSecond()).getMinutes()).divide(BigDecimal.valueOf(NUMBER_OF_MINUTES_IN_HOUR), 2, RoundingMode.HALF_UP).doubleValue();
        }
        return 0.0;
    }

    public Summary getSummaryByDate(YearMonthDay date) {
        for (Summary summary : this.getAssociatedSummaries()) {
            if (!summary.getSummaryDateYearMonthDay().isEqual((ReadablePartial)date)) continue;
            return summary;
        }
        return null;
    }

    public List<Summary> getAssociatedSummaries() {
        ArrayList<Summary> result = new ArrayList<Summary>();
        Set lessonInstances = this.getLessonInstancesSet();
        for (LessonInstance lessonInstance : lessonInstances) {
            if (lessonInstance.getSummary() == null) continue;
            result.add(lessonInstance.getSummary());
        }
        return result;
    }

    public boolean hasAnyAssociatedSummaries() {
        return !this.getAssociatedSummaries().isEmpty();
    }

    public SortedSet<Summary> getSummariesSortedByDate() {
        return this.getSummaries((Comparator<Summary>)new ReverseComparator(Summary.COMPARATOR_BY_DATE_AND_HOUR));
    }

    public SortedSet<Summary> getSummariesSortedByNewestDate() {
        return this.getSummaries(Summary.COMPARATOR_BY_DATE_AND_HOUR);
    }

    public boolean isTimeValidToInsertSummary(HourMinuteSecond timeToInsert, YearMonthDay summaryDate) {
        YearMonthDay currentDate = new YearMonthDay();
        if (timeToInsert == null || summaryDate == null || summaryDate.isAfter((ReadablePartial)currentDate)) {
            return false;
        }
        if (currentDate.isEqual((ReadablePartial)summaryDate)) {
            HourMinuteSecond lessonEndTime = null;
            LessonInstance lessonInstance = this.getLessonInstanceFor(summaryDate);
            lessonEndTime = lessonInstance != null ? lessonInstance.getEndTime() : this.getEndHourMinuteSecond();
            return !lessonEndTime.isAfter(timeToInsert);
        }
        return true;
    }

    public boolean isDateValidToInsertSummary(YearMonthDay date) {
        YearMonthDay currentDate = new YearMonthDay();
        SortedSet<YearMonthDay> allLessonDatesEvenToday = this.getAllLessonDatesUntil(currentDate);
        return allLessonDatesEvenToday.isEmpty() || date == null ? false : allLessonDatesEvenToday.contains(date);
    }

    public boolean isDateValidToInsertExtraSummary(YearMonthDay date) {
        return !this.getLessonStartDay().isAfter((ReadablePartial)date) && !this.getLessonEndDay().isBefore((ReadablePartial)date);
    }

    private YearMonthDay getLessonStartDay() {
        if (!this.wasFinished()) {
            YearMonthDay periodBegin = this.getPeriod().getStartYearMonthDay();
            return this.getValidBeginDate(periodBegin);
        }
        return null;
    }

    private YearMonthDay getLessonEndDay() {
        if (!this.wasFinished()) {
            YearMonthDay periodEnd = this.getPeriod().getLastOccupationPeriodOfNestedPeriods().getEndYearMonthDay();
            return this.getValidEndDate(periodEnd);
        }
        return null;
    }

    private YearMonthDay getValidBeginDate(YearMonthDay startDate) {
        YearMonthDay lessonBegin = startDate.toDateTimeAtMidnight().withDayOfWeek(this.getDiaSemana().getDiaSemanaInDayOfWeekJodaFormat()).toYearMonthDay();
        if (lessonBegin.isBefore((ReadablePartial)startDate)) {
            lessonBegin = lessonBegin.plusDays(NUMBER_OF_DAYS_IN_WEEK);
        }
        return lessonBegin;
    }

    private YearMonthDay getValidEndDate(YearMonthDay endDate) {
        YearMonthDay lessonEnd = endDate.toDateTimeAtMidnight().withDayOfWeek(this.getDiaSemana().getDiaSemanaInDayOfWeekJodaFormat()).toYearMonthDay();
        if (lessonEnd.isAfter((ReadablePartial)endDate)) {
            lessonEnd = lessonEnd.minusDays(NUMBER_OF_DAYS_IN_WEEK);
        }
        return lessonEnd;
    }

    public Space getLessonCampus() {
        if (!this.wasFinished()) {
            return this.hasSala() ? SpaceUtils.getSpaceCampus(this.getSala()) : null;
        }
        LessonInstance lastLessonInstance = this.getLastLessonInstance();
        if (lastLessonInstance != null && lastLessonInstance.getRoom() != null) {
            return SpaceUtils.getSpaceCampus(lastLessonInstance.getRoom());
        }
        return null;
    }

    public YearMonthDay getNextPossibleSummaryDate() {
        YearMonthDay currentDate = new YearMonthDay();
        HourMinuteSecond now = new HourMinuteSecond();
        Summary lastSummary = this.getLastSummary();
        if (lastSummary != null) {
            SortedSet<YearMonthDay> datesEvenToday = this.getAllLessonDatesUntil(currentDate);
            SortedSet<YearMonthDay> possibleDates = datesEvenToday.tailSet(lastSummary.getSummaryDateYearMonthDay());
            possibleDates.remove(lastSummary.getSummaryDateYearMonthDay());
            if (!possibleDates.isEmpty()) {
                YearMonthDay nextPossibleDate = possibleDates.first();
                return this.isTimeValidToInsertSummary(now, nextPossibleDate) ? nextPossibleDate : null;
            }
        } else {
            YearMonthDay nextPossibleDate = this.hasAnyLessonInstances() ? this.getFirstLessonInstance().getDay() : this.getLessonStartDay();
            return this.isTimeValidToInsertSummary(now, nextPossibleDate) ? nextPossibleDate : null;
        }
        return null;
    }

    public SortedSet<YearMonthDay> getAllPossibleDatesToInsertSummary() {
        HourMinuteSecond now = new HourMinuteSecond();
        YearMonthDay currentDate = new YearMonthDay();
        SortedSet<YearMonthDay> datesToInsert = this.getAllLessonDatesUntil(currentDate);
        for (Summary summary : this.getAssociatedSummaries()) {
            YearMonthDay summaryDate = summary.getSummaryDateYearMonthDay();
            datesToInsert.remove(summaryDate);
        }
        Iterator iter = datesToInsert.iterator();
        while (iter.hasNext()) {
            YearMonthDay date = (YearMonthDay)iter.next();
            if (this.isTimeValidToInsertSummary(now, date)) continue;
            iter.remove();
        }
        return datesToInsert;
    }

    public SortedSet<YearMonthDay> getAllLessonDatesWithoutInstanceDates() {
        TreeSet<YearMonthDay> dates = new TreeSet<YearMonthDay>();
        if (!this.wasFinished()) {
            YearMonthDay startDateToSearch = this.getLessonStartDay();
            YearMonthDay endDateToSearch = this.getLessonEndDay();
            dates.addAll(this.getAllValidLessonDatesWithoutInstancesDates(startDateToSearch, endDateToSearch));
        }
        return dates;
    }

    public SortedSet<Interval> getAllLessonIntervalsWithoutInstanceDates() {
        TreeSet<Interval> dates = new TreeSet<Interval>(new Comparator<Interval>(){

            @Override
            public int compare(Interval o1, Interval o2) {
                return o1.getStart().compareTo((ReadableInstant)o2.getStart());
            }
        });
        if (!this.wasFinished()) {
            YearMonthDay startDateToSearch = this.getLessonStartDay();
            YearMonthDay endDateToSearch = this.getLessonEndDay();
            HourMinuteSecond b = this.getBeginHourMinuteSecond();
            HourMinuteSecond e = this.getEndHourMinuteSecond();
            for (YearMonthDay yearMonthDay : this.getAllValidLessonDatesWithoutInstancesDates(startDateToSearch, endDateToSearch)) {
                DateTime start = new DateTime(yearMonthDay.getYear(), yearMonthDay.getMonthOfYear(), yearMonthDay.getDayOfMonth(), b.getHour(), b.getMinuteOfHour(), b.getSecondOfMinute(), 0);
                DateTime end = new DateTime(yearMonthDay.getYear(), yearMonthDay.getMonthOfYear(), yearMonthDay.getDayOfMonth(), e.getHour(), e.getMinuteOfHour(), e.getSecondOfMinute(), 0);
                dates.add(new Interval((ReadableInstant)start, (ReadableInstant)end));
            }
        }
        return dates;
    }

    public boolean overlaps(Interval interval) {
        if (this.wasFinished()) {
            return false;
        }
        YearMonthDay startDateToSearch = this.getLessonStartDay();
        if (startDateToSearch == null) {
            return false;
        }
        YearMonthDay endDateToSearch = this.getLessonEndDay();
        if (endDateToSearch == null) {
            return false;
        }
        DateTime intervalStart = interval.getStart();
        if (intervalStart.isAfter((ReadableInstant)endDateToSearch.toDateTimeAtMidnight().plusDays(1))) {
            return false;
        }
        DateTime intervalEnd = interval.getEnd();
        if (intervalEnd.isBefore((ReadableInstant)startDateToSearch.toDateTimeAtMidnight())) {
            return false;
        }
        HourMinuteSecond b = this.getBeginHourMinuteSecond();
        HourMinuteSecond e = this.getEndHourMinuteSecond();
        for (YearMonthDay yearMonthDay : this.getAllValidLessonDatesWithoutInstancesDates(startDateToSearch, endDateToSearch)) {
            DateTime end;
            DateTime start = new DateTime(yearMonthDay.getYear(), yearMonthDay.getMonthOfYear(), yearMonthDay.getDayOfMonth(), b.getHour(), b.getMinuteOfHour(), b.getSecondOfMinute(), 0);
            if (!new Interval((ReadableInstant)start, (ReadableInstant)(end = new DateTime(yearMonthDay.getYear(), yearMonthDay.getMonthOfYear(), yearMonthDay.getDayOfMonth(), e.getHour(), e.getMinuteOfHour(), e.getSecondOfMinute(), 0))).overlaps((ReadableInterval)interval)) continue;
            return true;
        }
        return false;
    }

    public SortedSet<YearMonthDay> getAllLessonDates() {
        SortedSet<YearMonthDay> dates = this.getAllLessonInstanceDates();
        if (!this.wasFinished()) {
            YearMonthDay startDateToSearch = this.getLessonStartDay();
            YearMonthDay endDateToSearch = this.getLessonEndDay();
            dates.addAll(this.getAllValidLessonDatesWithoutInstancesDates(startDateToSearch, endDateToSearch));
        }
        return dates;
    }

    public int getFinalNumberOfLessonInstances() {
        int count = this.getLessonInstancesSet().size();
        if (!this.wasFinished()) {
            YearMonthDay startDateToSearch = this.getLessonStartDay();
            YearMonthDay endDateToSearch = this.getLessonEndDay();
            count += this.getAllValidLessonDatesWithoutInstancesDates(startDateToSearch, endDateToSearch).size();
        }
        return count;
    }

    public SortedSet<YearMonthDay> getAllLessonDatesUntil(YearMonthDay day) {
        TreeSet<YearMonthDay> result = new TreeSet<YearMonthDay>();
        if (day != null) {
            result.addAll(this.getAllLessonInstanceDatesUntil(day));
            if (!this.wasFinished()) {
                YearMonthDay startDateToSearch = this.getLessonStartDay();
                YearMonthDay lessonEndDay = this.getLessonEndDay();
                YearMonthDay endDateToSearch = lessonEndDay.isAfter((ReadablePartial)day) ? day : lessonEndDay;
                result.addAll(this.getAllValidLessonDatesWithoutInstancesDates(startDateToSearch, endDateToSearch));
            }
        }
        return result;
    }

    public SortedSet<YearMonthDay> getAllLessonInstanceDates() {
        TreeSet<YearMonthDay> dates = new TreeSet<YearMonthDay>();
        for (LessonInstance instance : this.getLessonInstancesSet()) {
            dates.add(instance.getDay());
        }
        return dates;
    }

    public List<LessonInstance> getAllLessonInstancesUntil(LocalDate day) {
        ArrayList<LessonInstance> result = new ArrayList<LessonInstance>();
        if (day != null) {
            for (LessonInstance instance : this.getLessonInstancesSet()) {
                if (instance.getDay().isAfter((ReadablePartial)day)) continue;
                result.add(instance);
            }
        }
        return result;
    }

    public SortedSet<YearMonthDay> getAllLessonInstanceDatesUntil(YearMonthDay day) {
        TreeSet<YearMonthDay> result = new TreeSet<YearMonthDay>();
        if (day != null) {
            for (LessonInstance instance : this.getLessonInstancesSet()) {
                YearMonthDay instanceDay = instance.getDay();
                if (instanceDay.isAfter((ReadablePartial)day)) continue;
                result.add(instanceDay);
            }
        }
        return result;
    }

    private SortedSet<YearMonthDay> getAllValidLessonDatesWithoutInstancesDates(YearMonthDay startDateToSearch, YearMonthDay endDateToSearch) {
        TreeSet<YearMonthDay> result;
        block2: {
            result = new TreeSet<YearMonthDay>();
            YearMonthDay yearMonthDay = startDateToSearch = startDateToSearch != null ? this.getValidBeginDate(startDateToSearch) : null;
            if (this.wasFinished() || startDateToSearch == null || endDateToSearch == null || startDateToSearch.isAfter((ReadablePartial)endDateToSearch)) break block2;
            Space lessonCampus = this.getLessonCampus();
            int dayIncrement = this.getFrequency() == FrequencyType.BIWEEKLY ? FrequencyType.WEEKLY.getNumberOfDays() : this.getFrequency().getNumberOfDays();
            boolean shouldAdd = true;
            do {
                if (!this.isDayValid(startDateToSearch, lessonCampus)) continue;
                if ((this.getFrequency() != FrequencyType.BIWEEKLY || shouldAdd) && !this.isHoliday(startDateToSearch, lessonCampus)) {
                    result.add(startDateToSearch);
                }
                boolean bl = shouldAdd = !shouldAdd;
            } while (!(startDateToSearch = startDateToSearch.plusDays(dayIncrement)).isAfter((ReadablePartial)endDateToSearch));
        }
        return result;
    }

    private boolean isHoliday(YearMonthDay day, Space lessonCampus) {
        return Holiday.isHoliday(day.toLocalDate(), lessonCampus);
    }

    private boolean isDayValid(YearMonthDay day, Space lessonCampus) {
        return this.getPeriod().nestedOccupationPeriodsContainsDay(day);
    }

    public YearMonthDay getNextPossibleLessonInstanceDate() {
        SortedSet<YearMonthDay> allLessonDates = this.getAllLessonDates();
        LessonInstance lastLessonInstance = this.getLastLessonInstance();
        if (lastLessonInstance != null) {
            YearMonthDay day = lastLessonInstance.getDay();
            SortedSet<YearMonthDay> nextLessonDates = allLessonDates.tailSet(day);
            nextLessonDates.remove(day);
            return nextLessonDates.isEmpty() ? null : nextLessonDates.first();
        }
        return allLessonDates.isEmpty() ? null : allLessonDates.first();
    }

    public LessonInstance getLastLessonInstance() {
        TreeSet<LessonInstance> result = new TreeSet<LessonInstance>(LessonInstance.COMPARATOR_BY_BEGIN_DATE_TIME);
        result.addAll(this.getLessonInstancesSet());
        return !result.isEmpty() ? (LessonInstance)((Object)result.last()) : null;
    }

    public LessonInstance getFirstLessonInstance() {
        TreeSet<LessonInstance> result = new TreeSet<LessonInstance>(LessonInstance.COMPARATOR_BY_BEGIN_DATE_TIME);
        result.addAll(this.getLessonInstancesSet());
        return !result.isEmpty() ? (LessonInstance)((Object)result.first()) : null;
    }

    private Summary getLastSummary() {
        SortedSet<Summary> summaries = this.getSummariesSortedByNewestDate();
        return summaries.isEmpty() ? null : summaries.first();
    }

    private SortedSet<Summary> getSummaries(Comparator<Summary> comparator) {
        TreeSet<Summary> lessonSummaries = new TreeSet<Summary>(comparator);
        lessonSummaries.addAll(this.getAssociatedSummaries());
        return lessonSummaries;
    }

    public LessonInstance getLessonInstanceFor(YearMonthDay date) {
        Set lessonInstances = this.getLessonInstancesSet();
        for (LessonInstance lessonInstance : lessonInstances) {
            if (!lessonInstance.getDay().isEqual((ReadablePartial)date)) continue;
            return lessonInstance;
        }
        return null;
    }

    public boolean contains(Interval interval) {
        return this.contains(interval, this.getAllLessonDates());
    }

    public boolean isAllIntervalIn(Interval interval) {
        return this.isAllIntervalIn(interval, this.getAllLessonDates());
    }

    public boolean containsWithoutCheckInstanceDates(Interval interval) {
        return this.contains(interval, this.getAllLessonDatesWithoutInstanceDates());
    }

    private boolean isAllIntervalIn(Interval interval, SortedSet<YearMonthDay> allLessonDates) {
        YearMonthDay intervalStartDate = interval.getStart().toYearMonthDay();
        YearMonthDay intervalEndDate = interval.getEnd().toYearMonthDay();
        HourMinuteSecond intervalBegin = new HourMinuteSecond(interval.getStart().getHourOfDay(), interval.getStart().getMinuteOfHour(), 0);
        HourMinuteSecond intervalEnd = new HourMinuteSecond(interval.getEnd().getHourOfDay(), interval.getEnd().getMinuteOfHour(), 0);
        for (YearMonthDay day : allLessonDates) {
            if (!intervalStartDate.isEqual((ReadablePartial)intervalEndDate) || !day.isEqual((ReadablePartial)intervalStartDate) || intervalBegin.isBefore(this.getBeginHourMinuteSecond()) || intervalEnd.isAfter(this.getEndHourMinuteSecond())) continue;
            return true;
        }
        return false;
    }

    private boolean contains(Interval interval, SortedSet<YearMonthDay> allLessonDates) {
        YearMonthDay intervalStartDate = interval.getStart().toYearMonthDay();
        YearMonthDay intervalEndDate = interval.getEnd().toYearMonthDay();
        HourMinuteSecond intervalBegin = new HourMinuteSecond(interval.getStart().getHourOfDay(), interval.getStart().getMinuteOfHour(), interval.getStart().getSecondOfMinute());
        HourMinuteSecond intervalEnd = new HourMinuteSecond(interval.getEnd().getHourOfDay(), interval.getEnd().getMinuteOfHour(), interval.getEnd().getSecondOfMinute());
        for (YearMonthDay day : allLessonDates) {
            if (!(intervalStartDate.isEqual((ReadablePartial)intervalEndDate) ? day.isEqual((ReadablePartial)intervalStartDate) && !intervalBegin.isAfter(this.getEndHourMinuteSecond()) && !intervalEnd.isBefore(this.getBeginHourMinuteSecond()) : day.isAfter((ReadablePartial)intervalStartDate) && day.isBefore((ReadablePartial)intervalEndDate) || day.isEqual((ReadablePartial)intervalStartDate) && !this.getEndHourMinuteSecond().isBefore(intervalBegin) || day.isEqual((ReadablePartial)intervalEndDate) && !this.getBeginHourMinuteSecond().isAfter(intervalEnd))) continue;
            return true;
        }
        return false;
    }

    public String prettyPrint() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDiaSemana().toString()).append(" (");
        result.append(this.getBeginHourMinuteSecond().toString("HH:mm")).append("-");
        result.append(this.getEndHourMinuteSecond().toString("HH:mm")).append(") ");
        result.append(this.hasSala() ? this.getSala().getName().toString() : "");
        return result.toString();
    }

    private void checkShiftLoad(Shift shift) {
        if (shift != null) {
            Set courseLoads = shift.getCourseLoadsSet();
            if (courseLoads.size() == 1) {
                CourseLoad courseLoad = (CourseLoad)((Object)courseLoads.iterator().next());
                if (courseLoad.getUnitQuantity() != null && this.getUnitHours().compareTo(courseLoad.getUnitQuantity()) != 0) {
                    throw new DomainException("error.Lesson.shift.load.unit.quantity.exceeded", this.getUnitHours().toString(), courseLoad.getUnitQuantity().toString());
                }
            } else if (courseLoads.size() > 1) {
                boolean unitValid = false;
                boolean totalValid = false;
                BigDecimal lessonHours = this.getUnitHours();
                BigDecimal totalHours = shift.getTotalHours();
                for (CourseLoad courseLoad : courseLoads) {
                    unitValid = false;
                    totalValid = false;
                    if (courseLoad.getUnitQuantity() == null || lessonHours.compareTo(courseLoad.getUnitQuantity()) == 0) {
                        unitValid = true;
                    }
                    if (totalHours.compareTo(courseLoad.getTotalQuantity()) == 1) continue;
                    totalValid = true;
                    if (!unitValid) continue;
                    break;
                }
                if (!unitValid) {
                    throw new DomainException("error.Lesson.shift.load.unit.quantity.exceeded.2", this.getUnitHours().toString());
                }
            }
        }
    }

    public Calendar getInicio() {
        if (this.getBegin() != null) {
            Calendar result = Calendar.getInstance();
            result.setTime(this.getBegin());
            return result;
        }
        return null;
    }

    public void setInicio(Calendar inicio) {
        if (inicio != null) {
            this.setBegin(inicio.getTime());
        } else {
            this.setBegin(null);
        }
    }

    public Calendar getFim() {
        if (this.getEnd() != null) {
            Calendar result = Calendar.getInstance();
            result.setTime(this.getEnd());
            return result;
        }
        return null;
    }

    public void setFim(Calendar fim) {
        if (fim != null) {
            this.setEnd(fim.getTime());
        } else {
            this.setEnd(null);
        }
    }

    public AcademicInterval getAcademicInterval() {
        return this.getExecutionPeriod().getAcademicInterval();
    }

    public List<EventBean> getAllLessonsEvents() {
        HashMap<DateTime, LessonInstance> hashmap = new HashMap<DateTime, LessonInstance>();
        ArrayList<EventBean> result = new ArrayList<EventBean>();
        LocalDate lessonEndDay = null;
        if (this.getLessonEndDay() != null) {
            this.getLessonEndDay().toLocalDate();
        }
        for (LessonInstance lessonInstance : this.getAllLessonInstancesUntil(lessonEndDay)) {
            hashmap.put(lessonInstance.getBeginDateTime(), lessonInstance);
        }
        for (YearMonthDay aDay : this.getAllLessonDates()) {
            ClassEventBean bean;
            DateTime beginDate = new DateTime(aDay.getYear(), aDay.getMonthOfYear(), aDay.getDayOfMonth(), this.getBeginHourMinuteSecond().getHour(), this.getBeginHourMinuteSecond().getMinuteOfHour(), this.getBeginHourMinuteSecond().getSecondOfMinute(), 0);
            LessonInstance lessonInstance = (LessonInstance)((Object)hashmap.get(beginDate));
            HashSet<Space> location = new HashSet<Space>();
            String url = this.getExecutionCourse().getSiteUrl();
            if (lessonInstance != null) {
                if (lessonInstance.getLessonInstanceSpaceOccupation() != null) {
                    location.add(lessonInstance.getLessonInstanceSpaceOccupation().getRoom());
                }
                String summary = null;
                if (lessonInstance.getSummary() != null) {
                    summary = lessonInstance.getSummary().getSummaryText().toString();
                    Pattern p = Pattern.compile("<[a-zA-Z0-9\\/]*[^>]*>");
                    Matcher matcher = p.matcher(summary);
                    summary = matcher.replaceAll("");
                    p = Pattern.compile("\\s(\\s)*");
                    matcher = p.matcher(summary);
                    summary = matcher.replaceAll(" ");
                }
                bean = new ClassEventBean(lessonInstance.getBeginDateTime(), lessonInstance.getEndDateTime(), false, location, url + "/sumarios", summary, this.getShift());
            } else {
                if (this.getLessonSpaceOccupation() != null) {
                    location.add(this.getLessonSpaceOccupation().getRoom());
                }
                DateTime endDate = new DateTime(aDay.getYear(), aDay.getMonthOfYear(), aDay.getDayOfMonth(), this.getEndHourMinuteSecond().getHour(), this.getEndHourMinuteSecond().getMinuteOfHour(), this.getEndHourMinuteSecond().getSecondOfMinute(), 0);
                bean = new ClassEventBean(beginDate, endDate, false, location, url, null, this.getShift());
            }
            result.add(bean);
        }
        return result;
    }

    @Deprecated
    public Date getBegin() {
        HourMinuteSecond hms = this.getBeginHourMinuteSecond();
        return hms == null ? null : new Date(0, 0, 1, hms.getHour(), hms.getMinuteOfHour(), hms.getSecondOfMinute());
    }

    @Deprecated
    public void setBegin(Date date) {
        if (date == null) {
            this.setBeginHourMinuteSecond(null);
        } else {
            this.setBeginHourMinuteSecond(HourMinuteSecond.fromDateFields(date));
        }
    }

    @Deprecated
    public Date getEnd() {
        HourMinuteSecond hms = this.getEndHourMinuteSecond();
        return hms == null ? null : new Date(0, 0, 1, hms.getHour(), hms.getMinuteOfHour(), hms.getSecondOfMinute());
    }

    @Deprecated
    public void setEnd(Date date) {
        if (date == null) {
            this.setEndHourMinuteSecond(null);
        } else {
            this.setEndHourMinuteSecond(HourMinuteSecond.fromDateFields(date));
        }
    }

    public WeekDay getWeekDay() {
        DiaSemana diaSemana = this.getDiaSemana();
        return diaSemana == null ? null : WeekDay.getWeekDay(diaSemana);
    }

    public Set<Interval> getAllLessonIntervals() {
        HashSet<Interval> intervals = new HashSet<Interval>();
        for (LessonInstance instance : this.getLessonInstancesSet()) {
            intervals.add(new Interval((ReadableInstant)instance.getBeginDateTime(), (ReadableInstant)instance.getEndDateTime()));
        }
        if (!this.wasFinished()) {
            YearMonthDay startDateToSearch = this.getLessonStartDay();
            YearMonthDay endDateToSearch = this.getLessonEndDay();
            for (YearMonthDay day : this.getAllValidLessonDatesWithoutInstancesDates(startDateToSearch, endDateToSearch)) {
                intervals.add(new Interval((ReadableInstant)day.toLocalDate().toDateTime(new LocalTime(this.getBeginHourMinuteSecond().getHour(), this.getBeginHourMinuteSecond().getMinuteOfHour(), this.getBeginHourMinuteSecond().getSecondOfMinute())), (ReadableInstant)day.toLocalDate().toDateTime(new LocalTime(this.getEndHourMinuteSecond().getHour(), this.getEndHourMinuteSecond().getMinuteOfHour(), this.getEndHourMinuteSecond().getSecondOfMinute()))));
            }
        }
        return intervals;
    }

    public String getOccurrenceWeeksAsString() {
        TreeSet<Integer> weeks = new TreeSet<Integer>();
        ExecutionCourse executionCourse = this.getExecutionCourse();
        YearMonthDay firstPossibleLessonDay = executionCourse.getMaxLessonsPeriod().getLeft();
        YearMonthDay lastPossibleLessonDay = executionCourse.getMaxLessonsPeriod().getRight();
        for (Interval interval : this.getAllLessonIntervals()) {
            Integer week = Weeks.weeksBetween((ReadablePartial)firstPossibleLessonDay, (ReadablePartial)interval.getStart().toLocalDate()).getWeeks() + 1;
            weeks.add(week);
        }
        StringBuilder builder = new StringBuilder();
        Integer[] weeksA = weeks.toArray(new Integer[0]);
        for (int i = 0; i < weeksA.length; ++i) {
            if (i == 0) {
                builder.append(weeksA[i]);
                continue;
            }
            if (i == weeksA.length - 1 || weeksA[i] + 1 != weeksA[i + 1]) {
                String seperator = weeksA[i - 1] + 1 == weeksA[i] ? " - " : ", ";
                builder.append(seperator);
                builder.append(weeksA[i]);
                continue;
            }
            if (weeksA[i - 1] + 1 == weeksA[i]) continue;
            builder.append(", ");
            builder.append(weeksA[i]);
        }
        return builder.toString();
    }

    private boolean hasAnyLessonInstances() {
        return !this.getLessonInstancesSet().isEmpty();
    }

    public boolean isBiWeeklyOffset() {
        return this.getFrequency() == FrequencyType.BIWEEKLY;
    }
}

