/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util.renderer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.fenixedu.academic.util.renderer.GanttDiagramEvent;
import org.fenixedu.commons.i18n.I18N;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.YearMonthDay;

public class GanttDiagram {
    private static final Comparator<Interval> INTERVAL_COMPARATOR_BY_BEGIN = new Comparator<Interval>(){

        @Override
        public int compare(Interval o1, Interval o2) {
            return o1.getStart().compareTo((ReadableInstant)o2.getStart());
        }
    };
    private static final Comparator<Interval> INTERVAL_COMPARATOR_BY_END = new Comparator<Interval>(){

        @Override
        public int compare(Interval o1, Interval o2) {
            return o1.getEnd().compareTo((ReadableInstant)o2.getEnd());
        }
    };
    private Locale locale;
    private List<? extends GanttDiagramEvent> events;
    private ViewType viewType;
    private DateTime firstInstant;
    private DateTime lastInstant;
    private Map<Integer, Integer> yearsView;
    private Map<YearMonthDay, Integer> monthsView;
    private List<DateTime> months;
    private List<DateTime> days;

    public static GanttDiagram getNewTotalGanttDiagram(List<? extends GanttDiagramEvent> events_, YearMonthDay begin, YearMonthDay end) {
        return new GanttDiagram(events_, ViewType.TOTAL, begin, end);
    }

    public static GanttDiagram getNewWeeklyGanttDiagram(List<? extends GanttDiagramEvent> events_, YearMonthDay begin) {
        return new GanttDiagram(events_, ViewType.WEEKLY, begin);
    }

    public static GanttDiagram getNewDailyGanttDiagram(List<? extends GanttDiagramEvent> events_, YearMonthDay begin) {
        return new GanttDiagram(events_, ViewType.DAILY, begin);
    }

    public static GanttDiagram getNewMonthlyGanttDiagram(List<? extends GanttDiagramEvent> events_, YearMonthDay begin) {
        return new GanttDiagram(events_, ViewType.MONTHLY, begin);
    }

    public static GanttDiagram getNewMonthlyTotalGanttDiagram(List<? extends GanttDiagramEvent> events_, YearMonthDay begin) {
        return new GanttDiagram(events_, ViewType.MONTHLY_TOTAL, begin);
    }

    public static GanttDiagram getNewYearDailyGanttDiagram(List<? extends GanttDiagramEvent> events_, YearMonthDay begin) {
        return new GanttDiagram(events_, ViewType.YEAR_DAILY, begin);
    }

    private GanttDiagram(List<? extends GanttDiagramEvent> events_, ViewType type) {
        this.setViewType(type);
        this.setEvents(events_);
        this.init(type, null, null);
    }

    private GanttDiagram(List<? extends GanttDiagramEvent> events_, ViewType type, YearMonthDay begin) {
        this.setViewType(type);
        this.setEvents(events_);
        this.init(type, begin, null);
    }

    private GanttDiagram(List<? extends GanttDiagramEvent> events_, ViewType type, YearMonthDay begin, YearMonthDay end) {
        this.setViewType(type);
        this.setEvents(events_);
        this.init(type, begin, end);
    }

    private void init(ViewType type, YearMonthDay begin, YearMonthDay end) {
        switch (type) {
            case TOTAL: {
                this.calculateFirstAndLastInstantInTotalMode(begin, end);
                this.generateYearsViewAndMonths();
                break;
            }
            case MONTHLY_TOTAL: {
                this.calculateFirstAndLastInstantInMonthlyMode(begin);
                this.generateYearsViewAndMonths();
                break;
            }
            case MONTHLY: {
                this.calculateFirstAndLastInstantInMonthlyMode(begin);
                this.generateYearsViewMonthsViewAndDays();
                break;
            }
            case WEEKLY: {
                this.calculateFirstAndLastInstantInWeeklyMode(begin);
                this.generateYearsViewMonthsViewAndDays();
                break;
            }
            case DAILY: {
                this.calculateFirstAndLastInstantInDailyMode(begin);
                this.generateYearsViewMonthsViewAndDays();
                break;
            }
            case YEAR_DAILY: {
                this.calculateFirstAndLastInstantInMonthlyMode(begin);
                this.generateYearsViewMonthsViewAndDays();
                break;
            }
        }
    }

    private void calculateFirstAndLastInstantInMonthlyMode(YearMonthDay begin) {
        if (begin == null) {
            throw new IllegalArgumentException();
        }
        DateTime beginDateTime = begin.toDateTimeAtMidnight();
        beginDateTime = beginDateTime.getDayOfMonth() != 1 ? beginDateTime.withDayOfMonth(1) : beginDateTime;
        this.setFirstInstant(beginDateTime);
        this.setLastInstant(beginDateTime.plusMonths(1).minusDays(1));
    }

    private void calculateFirstAndLastInstantInDailyMode(YearMonthDay begin) {
        if (begin == null) {
            throw new IllegalArgumentException();
        }
        this.setFirstInstant(begin.toDateTimeAtMidnight());
        this.setLastInstant(begin.toDateTimeAtMidnight());
    }

    private void calculateFirstAndLastInstantInWeeklyMode(YearMonthDay begin) {
        if (begin == null) {
            throw new IllegalArgumentException();
        }
        DateTime beginDateTime = begin.toDateTimeAtMidnight();
        beginDateTime = beginDateTime.getDayOfWeek() != 1 ? beginDateTime.withDayOfWeek(1) : beginDateTime;
        this.setFirstInstant(beginDateTime);
        this.setLastInstant(beginDateTime.plusDays(6));
    }

    private void calculateFirstAndLastInstantInTotalMode(YearMonthDay begin, YearMonthDay end) {
        if (begin != null && end == null || end != null && begin == null) {
            throw new IllegalArgumentException();
        }
        if (begin == null) {
            TreeSet<Interval> allIntervalsSortedByBeginDate = new TreeSet<Interval>(INTERVAL_COMPARATOR_BY_BEGIN);
            for (GanttDiagramEvent ganttDiagramEvent : this.getEvents()) {
                allIntervalsSortedByBeginDate.addAll(ganttDiagramEvent.getGanttDiagramEventSortedIntervals());
            }
            if (!allIntervalsSortedByBeginDate.isEmpty()) {
                this.setFirstInstant(((Interval)allIntervalsSortedByBeginDate.first()).getStart().toDateMidnight().toDateTime());
            }
            TreeSet<Interval> allIntervalsSortedByEndDate = new TreeSet<Interval>(INTERVAL_COMPARATOR_BY_END);
            for (GanttDiagramEvent ganttDiagramEvent : this.getEvents()) {
                allIntervalsSortedByEndDate.addAll(ganttDiagramEvent.getGanttDiagramEventSortedIntervals());
            }
            if (!allIntervalsSortedByEndDate.isEmpty()) {
                this.setLastInstant(((Interval)allIntervalsSortedByEndDate.last()).getEnd().toDateMidnight().toDateTime());
            }
        } else {
            this.setFirstInstant(begin.toDateTimeAtMidnight());
            this.setLastInstant(end.toDateTimeAtMidnight());
        }
        if (this.getFirstInstant() != null && this.getLastInstant() != null && (this.getFirstInstant().isAfter((ReadableInstant)this.getLastInstant()) || this.getLastInstant().isBefore((ReadableInstant)this.getFirstInstant()))) {
            throw new IllegalArgumentException();
        }
    }

    private void generateYearsViewMonthsViewAndDays() {
        DateTime firstMonthDateTime = this.getFirstInstant();
        DateTime lastMontDateTime = this.getLastInstant();
        if (firstMonthDateTime != null && lastMontDateTime != null) {
            while (firstMonthDateTime.getYear() < lastMontDateTime.getYear() || firstMonthDateTime.getYear() == lastMontDateTime.getYear() && firstMonthDateTime.getDayOfYear() <= lastMontDateTime.getDayOfYear()) {
                this.getDays().add(firstMonthDateTime);
                YearMonthDay day = firstMonthDateTime.toYearMonthDay().withDayOfMonth(1);
                if (this.getMonthsView().containsKey(day)) {
                    this.getMonthsView().put(day, this.getMonthsView().get(day) + 1);
                } else {
                    this.getMonthsView().put(day, 1);
                }
                if (this.getYearsView().containsKey(firstMonthDateTime.getYear())) {
                    this.getYearsView().put(firstMonthDateTime.getYear(), this.getYearsView().get(firstMonthDateTime.getYear()) + 1);
                } else {
                    this.getYearsView().put(firstMonthDateTime.getYear(), 1);
                }
                firstMonthDateTime = firstMonthDateTime.plusDays(1);
            }
        }
    }

    private void generateYearsViewAndMonths() {
        DateTime firstMonthDateTime = this.getFirstInstant();
        DateTime lastMontDateTime = this.getLastInstant();
        if (firstMonthDateTime != null && lastMontDateTime != null) {
            while (firstMonthDateTime.getYear() < lastMontDateTime.getYear() || firstMonthDateTime.getYear() == lastMontDateTime.getYear() && firstMonthDateTime.getMonthOfYear() <= lastMontDateTime.getMonthOfYear()) {
                this.getMonths().add(firstMonthDateTime);
                if (this.getYearsView().containsKey(firstMonthDateTime.getYear())) {
                    this.getYearsView().put(firstMonthDateTime.getYear(), this.getYearsView().get(firstMonthDateTime.getYear()) + 1);
                } else {
                    this.getYearsView().put(firstMonthDateTime.getYear(), 1);
                }
                firstMonthDateTime = firstMonthDateTime.plusMonths(1);
            }
        }
    }

    public List<? extends GanttDiagramEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<? extends GanttDiagramEvent> events) {
        this.events = events;
    }

    public DateTime getFirstInstant() {
        return this.firstInstant;
    }

    public void setFirstInstant(DateTime firstInstant) {
        this.firstInstant = firstInstant;
    }

    public DateTime getLastInstant() {
        return this.lastInstant;
    }

    public void setLastInstant(DateTime lastInstant) {
        this.lastInstant = lastInstant;
    }

    public List<DateTime> getMonths() {
        if (this.months == null) {
            this.months = new ArrayList<DateTime>();
        }
        return this.months;
    }

    public void setMonths(List<DateTime> months) {
        this.months = months;
    }

    public int getMonthsDaysSize() {
        int result = 0;
        for (DateTime month : this.getMonths()) {
            DateTime firstDayOfMonth = month.getDayOfMonth() != 1 ? month.withDayOfMonth(1) : month;
            DateTime lastDayOfMonth = firstDayOfMonth.plusMonths(1).minusDays(1);
            int monthNumberOfDays = Days.daysBetween((ReadableInstant)firstDayOfMonth, (ReadableInstant)lastDayOfMonth).getDays() + 1;
            result += monthNumberOfDays;
        }
        return result;
    }

    public Map<Integer, Integer> getYearsView() {
        if (this.yearsView == null) {
            this.yearsView = new TreeMap<Integer, Integer>();
        }
        return this.yearsView;
    }

    public void setYearsView(Map<Integer, Integer> years) {
        this.yearsView = years;
    }

    public Map<YearMonthDay, Integer> getMonthsView() {
        if (this.monthsView == null) {
            this.monthsView = new TreeMap<YearMonthDay, Integer>();
        }
        return this.monthsView;
    }

    public void setMonthsView(Map<YearMonthDay, Integer> monthsView) {
        this.monthsView = monthsView;
    }

    public ViewType getViewType() {
        return this.viewType;
    }

    public void setViewType(ViewType viewType) {
        this.viewType = viewType;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = I18N.getLocale();
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public List<DateTime> getDays() {
        if (this.days == null) {
            this.days = new ArrayList<DateTime>();
        }
        return this.days;
    }

    public void setDays(List<DateTime> days) {
        this.days = days;
    }

    public static enum ViewType {
        TOTAL,
        MONTHLY,
        MONTHLY_TOTAL,
        WEEKLY,
        DAILY,
        YEAR_DAILY;

    }
}

