/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.departmentMember;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.studentCurriculum.BranchCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.departmentMember.CourseStatisticsBean;
import org.fenixedu.academic.ui.struts.action.departmentMember.DepartmentMemberApp;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.joda.time.DateTime;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=DepartmentMemberApp.DepartmentMemberDepartmentApp.class, path="courses", titleKey="link.departmentCourses")
@Mapping(path="/departmentCourses", module="departmentMember")
@Forwards(value={@Forward(name="viewDegreeCourses", path="/departmentMember/courseStatistics/viewDegreeCourses.jsp"), @Forward(name="viewCompetenceCourses", path="/departmentMember/courseStatistics/viewCompetenceCourses.jsp"), @Forward(name="viewExecutionCourses", path="/departmentMember/courseStatistics/viewExecutionCourses.jsp")})
public class DepartmentCourseDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepareListCourses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        CourseStatisticsBean bean = (CourseStatisticsBean)this.getRenderedObject("courseStatisticsBean");
        RenderUtils.invalidateViewState();
        if (bean == null) {
            ExecutionSemester executionSemester = (ExecutionSemester)this.getDomainObject(request, "executionSemesterId");
            bean = new CourseStatisticsBean(this.getDepartment(request), executionSemester);
        }
        request.setAttribute("courseStatisticsBean", (Object)bean);
        return mapping.findForward("viewCompetenceCourses");
    }

    public ActionForward prepareDegreeCourses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        CourseStatisticsBean bean = (CourseStatisticsBean)this.getRenderedObject("courseStatisticsBean");
        RenderUtils.invalidateViewState();
        if (bean == null) {
            CompetenceCourse competenceCourse = (CompetenceCourse)((Object)this.getDomainObject(request, "competenceCourseId"));
            ExecutionSemester executionSemester = (ExecutionSemester)this.getDomainObject(request, "executionSemesterId");
            if (competenceCourse == null) {
                return this.prepareListCourses(mapping, form, request, response);
            }
            bean = new CourseStatisticsBean(this.getDepartment(request), competenceCourse, executionSemester);
        }
        request.setAttribute("courseStatisticsBean", (Object)bean);
        return mapping.findForward("viewDegreeCourses");
    }

    public ActionForward downloadExcel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        Degree degree = (Degree)this.getDomainObject(request, "degreeId");
        CompetenceCourse competenceCourse = (CompetenceCourse)((Object)this.getDomainObject(request, "competenceCourseId"));
        ExecutionSemester executionSemester = (ExecutionSemester)this.getDomainObject(request, "executionSemesterId");
        this.exportStudentsToExcel(response, this.getCurricularCourseToExport(competenceCourse, degree), executionSemester.getExecutionYear());
        return null;
    }

    public ActionForward prepareExecutionCourses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        CourseStatisticsBean bean = (CourseStatisticsBean)this.getRenderedObject("courseStatisticsBean");
        RenderUtils.invalidateViewState();
        if (bean == null) {
            Degree degree = (Degree)this.getDomainObject(request, "degreeId");
            CompetenceCourse competenceCourse = (CompetenceCourse)((Object)this.getDomainObject(request, "competenceCourseId"));
            ExecutionSemester executionSemester = (ExecutionSemester)this.getDomainObject(request, "executionSemesterId");
            if (competenceCourse == null || degree == null) {
                return this.prepareListCourses(mapping, form, request, response);
            }
            bean = new CourseStatisticsBean(this.getDepartment(request), competenceCourse, degree, executionSemester);
        }
        request.setAttribute("courseStatisticsBean", (Object)bean);
        return mapping.findForward("viewExecutionCourses");
    }

    private Department getDepartment(HttpServletRequest request) {
        return this.getLoggedPerson(request).getTeacher().getLastDepartment();
    }

    private void exportStudentsToExcel(HttpServletResponse response, CurricularCourse curricularCourse, ExecutionYear executionYear) throws FenixServiceException {
        try {
            String filename = String.format("%s_%s_%s.xls", new DateTime().toString("dd-MM-yyyy_HH:mm"), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.students", (String[])new String[0]), curricularCourse.getName().replaceAll(" ", "_"));
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            ServletOutputStream outputStream = response.getOutputStream();
            Spreadsheet spreadsheet = new Spreadsheet("-", this.getStudentsEnroledListHeaders());
            this.reportInfo(spreadsheet, curricularCourse, executionYear);
            spreadsheet.exportToXLSSheet((OutputStream)outputStream);
            outputStream.flush();
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new FenixServiceException();
        }
    }

    private List<Object> getStudentsEnroledListHeaders() {
        ArrayList<Object> headers = new ArrayList<Object>(8);
        headers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.student.number", (String[])new String[0]));
        headers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.student.degree", (String[])new String[0]));
        headers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.student.curricularCourse", (String[])new String[0]));
        headers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.executionYear", (String[])new String[0]));
        headers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.student.main.branch", (String[])new String[0]));
        headers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.student.minor.branch", (String[])new String[0]));
        headers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.student.number.of.enrolments", (String[])new String[0]));
        return headers;
    }

    private void reportInfo(Spreadsheet spreadsheet, CurricularCourse curricularCourse, ExecutionYear executionYear) {
        for (Enrolment enrolment : curricularCourse.getEnrolments()) {
            if (!enrolment.isValid(executionYear)) continue;
            Spreadsheet.Row row = spreadsheet.addRow();
            row.setCell(enrolment.getStudent().getNumber());
            row.setCell(enrolment.getDegreeCurricularPlanOfStudent().getDegree().getPresentationName());
            row.setCell(enrolment.getName().getContent());
            row.setCell(enrolment.getExecutionYear().getName());
            CycleCurriculumGroup cycle = enrolment.getParentCycleCurriculumGroup();
            BranchCurriculumGroup major = cycle == null ? null : cycle.getMajorBranchCurriculumGroup();
            row.setCell(major != null ? major.getName().getContent() : "");
            BranchCurriculumGroup minor = cycle == null ? null : cycle.getMinorBranchCurriculumGroup();
            row.setCell(minor != null ? minor.getName().getContent() : "");
            row.setCell(this.getNumberOfEnrolments(enrolment));
        }
    }

    private String getNumberOfEnrolments(Enrolment enrolment) {
        return String.valueOf(enrolment.getStudentCurricularPlan().getEnrolments(enrolment.getCurricularCourse()).size());
    }

    private CurricularCourse getCurricularCourseToExport(CompetenceCourse competenceCourse, Degree degree) {
        for (CurricularCourse curricularCourse : competenceCourse.getAssociatedCurricularCoursesSet()) {
            if (!curricularCourse.getDegree().equals(degree)) continue;
            return curricularCourse;
        }
        return null;
    }
}

