/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.commons.ects;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.ui.renderers.converters.AcademicIntervalConverter;
import org.fenixedu.academic.ui.struts.action.commons.ects.EctsTableLevel;
import org.fenixedu.academic.ui.struts.action.commons.ects.EctsTableType;
import org.fenixedu.commons.StringNormalizer;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.converters.EnumConverter;

public class EctsTableFilter
implements Serializable {
    private static final long serialVersionUID = 4127180744673004205L;
    AcademicInterval executionInterval;
    EctsTableType type;
    EctsTableLevel level;
    private transient InputStream inputStream;
    private String filename;
    private String content;

    public AcademicInterval getExecutionInterval() {
        return this.executionInterval;
    }

    public void setExecutionInterval(AcademicInterval executionInterval) {
        this.executionInterval = executionInterval;
    }

    public EctsTableType getType() {
        return this.type;
    }

    public void setType(EctsTableType type) {
        this.type = type;
    }

    public EctsTableLevel getLevel() {
        return this.level;
    }

    public void setLevel(EctsTableLevel level) {
        this.level = level;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String getContent() throws IOException {
        if (this.content == null) {
            if (this.getInputStream() == null) {
                throw new IOException();
            }
            this.content = CharStreams.toString((Readable)new InputStreamReader(this.getInputStream(), Charset.defaultCharset()));
        }
        return this.content;
    }

    public void clearFileContent() {
        this.inputStream = null;
        this.content = null;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = StringNormalizer.normalize((String)filename);
    }

    public static class EctsTableLevelProvider
    implements DataProvider {
        public Converter getConverter() {
            return new EnumConverter();
        }

        public Object provide(Object source, Object currentValue) {
            EctsTableFilter filter = (EctsTableFilter)source;
            return filter.type != null ? filter.type.getAllowedLevels() : Collections.emptyList();
        }
    }

    public static class ExecutionIntervalProvider
    implements DataProvider {
        public Converter getConverter() {
            return new AcademicIntervalConverter();
        }

        public Object provide(Object source, Object current) {
            ArrayList<AcademicInterval> result = new ArrayList<AcademicInterval>();
            for (ExecutionYear year = ExecutionYear.readFirstBolonhaExecutionYear(); year != null; year = year.getNextExecutionYear()) {
                result.add(year.getAcademicInterval());
            }
            return result;
        }
    }
}

