/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.gradeSubmission;

import java.util.ArrayList;
import java.util.Collections;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.MarkSheet;
import org.fenixedu.academic.report.FenixReport;
import org.fenixedu.academic.util.FenixDigestUtils;

public class MarkSheetDocument
extends FenixReport {
    private static final long serialVersionUID = -1015332436546905622L;
    protected MarkSheet markSheet;

    public MarkSheetDocument(MarkSheet markSheet) {
        this.markSheet = markSheet;
        this.fillReport();
    }

    @Override
    public String getKey() {
        if (this.markSheet.isRectification()) {
            return "markSheetRectification";
        }
        return "markSheet";
    }

    @Override
    public String getReportFileName() {
        return "MarkSheet-" + this.markSheet.getCheckSum() + (this.markSheet.isRectification() ? "-rectified" : "");
    }

    @Override
    protected void fillReport() {
        this.addParameter("markSheet", (Object)this.markSheet);
        this.addParameter("checkSum", FenixDigestUtils.getPrettyCheckSum(this.markSheet.getCheckSum()));
        if (this.markSheet.isRectification()) {
            EnrolmentEvaluation rectification = (EnrolmentEvaluation)((Object)this.markSheet.getEnrolmentEvaluationsSet().iterator().next());
            this.addParameter("rectification", (Object)rectification);
            this.addParameter("rectified", (Object)rectification.getRectified());
        } else {
            ArrayList evaluations = new ArrayList(this.markSheet.getEnrolmentEvaluationsSet());
            Collections.sort(evaluations, EnrolmentEvaluation.SORT_BY_STUDENT_NUMBER);
            this.addDataSourceElements(evaluations);
        }
    }
}

