/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.spring.controller.teacher;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.ui.spring.StrutsFunctionalityController;
import org.fenixedu.academic.ui.spring.controller.teacher.ExecutionCourseCommunicationController$callable$update;
import org.fenixedu.academic.ui.spring.controller.teacher.TeacherView;
import org.fenixedu.academic.ui.struts.action.teacher.ManageExecutionCourseDA;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.view.RedirectView;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Controller
@RequestMapping(value={"/teacher/{executionCourseId}/communication"})
public class ExecutionCourseCommunicationController
extends StrutsFunctionalityController {
    public static final Advice advice$update = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping(method={RequestMethod.GET})
    public TeacherView communication(Model model, @PathVariable String executionCourseId) {
        ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseId);
        AccessControl.check(AccessControl.getPerson(), person -> this.hasPermissions((Person)((Object)person), executionCourse));
        model.addAttribute("professorship", (Object)executionCourse.getProfessorship(AccessControl.getPerson()));
        model.addAttribute("executionCourse", (Object)executionCourse);
        return new TeacherView("communication", executionCourse);
    }

    @RequestMapping(value={"edit"}, method={RequestMethod.POST})
    public RedirectView edit(@PathVariable String executionCourseId, @RequestParam String email, @RequestParam String siteUrl) {
        ExecutionCourseCommunicationController.update((ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseId), email, siteUrl);
        return new RedirectView("/teacher/" + executionCourseId + "/communication", true);
    }

    private static void update(ExecutionCourse executionCourse, String string, String string2) {
        Object object = advice$update.perform((Callable)new ExecutionCourseCommunicationController$callable$update(executionCourse, string, string2));
    }

    static /* synthetic */ void advised$update(ExecutionCourse executionCourse, String email, String siteUrl) {
        executionCourse.setEmail(email);
        executionCourse.setSiteUrl(siteUrl);
    }

    @Override
    protected Class<?> getFunctionalityType() {
        return ManageExecutionCourseDA.class;
    }

    private boolean hasPermissions(Person person, ExecutionCourse executionCourse) {
        return person != null && executionCourse.getProfessorship(person) != null && executionCourse.getProfessorship(person).getPermissions().getPersonalization();
    }
}

