/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.commons.alumni;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.Alumni;
import org.fenixedu.academic.domain.AlumniIdentityCheckRequest;
import org.fenixedu.academic.domain.AlumniRequestType;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.ReplyTo;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.domain.util.email.SystemSender;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.UserGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.util.CoreConfiguration;

public class AlumniNotificationService {
    private static void sendEmail(Collection<Recipient> recipients, String subject, String body, String bccs) {
        SystemSender systemSender = Bennu.getInstance().getSystemSender();
        new Message((Sender)((Object)systemSender), (Collection<? extends ReplyTo>)systemSender.getConcreteReplyTos(), recipients, subject, body, bccs);
    }

    private static List<Recipient> getAlumniRecipients(Alumni alumni) {
        return Collections.singletonList(Recipient.newInstance(UserGroup.of((User[])new User[]{alumni.getStudent().getPerson().getUser()})));
    }

    protected static void sendPublicAccessMail(Alumni alumni, String alumniEmail) {
        String subject = BundleUtil.getString((String)"resources.AlumniResources", (String)"alumni.public.registration.mail.subject", (String[])new String[]{Unit.getInstitutionAcronym()});
        Person person = alumni.getStudent().getPerson();
        String body = BundleUtil.getString((String)"resources.AlumniResources", (String)"alumni.public.registration.url", (String[])new String[]{person.getFirstAndLastName(), AlumniNotificationService.getRegisterConclusionURL(alumni)});
        AlumniNotificationService.sendEmail(Collections.EMPTY_LIST, subject, body, alumniEmail);
    }

    public static String getRegisterConclusionURL(Alumni alumni) {
        String fenixURL = CoreConfiguration.getConfiguration().applicationUrl();
        if (!fenixURL.endsWith("/")) {
            fenixURL = fenixURL + "/";
        }
        return MessageFormat.format(BundleUtil.getString((String)"resources.AlumniResources", (String)"alumni.public.registration.conclusion.url", (String[])new String[0]), fenixURL, alumni.getExternalId().toString(), alumni.getUrlRequestToken());
    }

    protected static void sendIdentityCheckEmail(AlumniIdentityCheckRequest request, Boolean approval) {
        String body;
        String subject;
        block7: {
            block6: {
                subject = MessageFormat.format(BundleUtil.getString((String)"resources.ManagerResources", (String)"alumni.identity.request.mail.subject", (String[])new String[0]), Unit.getInstitutionAcronym());
                if (!approval.booleanValue()) break block6;
                body = MessageFormat.format(BundleUtil.getString((String)"resources.ManagerResources", (String)"alumni.identity.request.confirm.identity", (String[])new String[0]), request.getAlumni().getStudent().getPerson().getFirstAndLastName());
                switch (request.getRequestType()) {
                    case IDENTITY_CHECK: {
                        body = body + BundleUtil.getString((String)"resources.ManagerResources", (String)"alumni.identity.request.curriculum.access", (String[])new String[0]);
                        break block7;
                    }
                    case PASSWORD_REQUEST: {
                        body = body + MessageFormat.format(BundleUtil.getString((String)"resources.ManagerResources", (String)"alumni.identity.request.password.request", (String[])new String[0]), request.getAlumni().getLoginUsername(), request.getExternalId(), request.getRequestToken().toString());
                        break block7;
                    }
                    case STUDENT_NUMBER_RECOVERY: {
                        body = body + MessageFormat.format(BundleUtil.getString((String)"resources.ManagerResources", (String)"alumni.identity.request.student.number.info", (String[])new String[0]), request.getAlumni().getStudent().getNumber().toString(), Unit.getInstitutionAcronym());
                        break block7;
                    }
                    default: {
                        return;
                    }
                }
            }
            body = MessageFormat.format(BundleUtil.getString((String)"resources.ManagerResources", (String)"alumni.identity.request.refuse.identity", (String[])new String[0]), request.getAlumni().getStudent().getPerson().getFirstAndLastName());
        }
        body = body + " " + request.getComment();
        if (!approval.booleanValue() && request.getRequestType().equals((Object)AlumniRequestType.PASSWORD_REQUEST)) {
            body = body + "\n" + MessageFormat.format(BundleUtil.getString((String)"resources.ManagerResources", (String)"alumni.identity.request.password.request.refuse", (String[])new String[0]), AlumniNotificationService.getRegisterConclusionURL(request.getAlumni()));
        }
        AlumniNotificationService.sendEmail(Collections.EMPTY_LIST, subject, body, request.getContactEmail());
    }

    protected static void sendRegistrationSuccessMail(Alumni alumni) {
        String subject = MessageFormat.format(BundleUtil.getString((String)"resources.AlumniResources", (String)"alumni.public.success.mail.subject", (String[])new String[0]), Unit.getInstitutionAcronym());
        String body = MessageFormat.format(BundleUtil.getString((String)"resources.AlumniResources", (String)"alumni.public.username.login.url", (String[])new String[0]), alumni.getStudent().getPerson().getFirstAndLastName(), alumni.getLoginUsername());
        AlumniNotificationService.sendEmail(AlumniNotificationService.getAlumniRecipients(alumni), subject, body, null);
    }
}

