/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.administrativeOffice.gradeSubmission;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.FinalMark;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.MarkSheet;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetEnrolmentEvaluationBean;
import org.fenixedu.academic.dto.teacher.gradeSubmission.MarkSheetTeacherGradeSubmissionBean;
import org.fenixedu.academic.dto.teacher.gradeSubmission.MarkSheetTeacherMarkBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.service.services.administrativeOffice.gradeSubmission.CreateMarkSheetByTeacher$callable$run;
import org.fenixedu.academic.service.services.exceptions.InvalidArgumentsServiceException;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreateMarkSheetByTeacher {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static List<EnrolmentEvaluation> run(MarkSheetTeacherGradeSubmissionBean markSheetTeacherGradeSubmissionBean) throws InvalidArgumentsServiceException {
        return (List)advice$run.perform((Callable)new CreateMarkSheetByTeacher$callable$run(markSheetTeacherGradeSubmissionBean));
    }

    static /* synthetic */ List<EnrolmentEvaluation> advised$run(MarkSheetTeacherGradeSubmissionBean submissionBean) throws InvalidArgumentsServiceException {
        AccessControl.check(RolePredicates.TEACHER_PREDICATE);
        ExecutionCourse executionCourse = submissionBean.getExecutionCourse();
        Teacher teacher = submissionBean.getResponsibleTeacher();
        CreateMarkSheetByTeacher.checkIfTeacherLecturesExecutionCourse(teacher, executionCourse);
        HashMap<CurricularCourse, Map<EvaluationSeason, Collection<MarkSheetEnrolmentEvaluationBean>>> markSheetsInformation = new HashMap<CurricularCourse, Map<EvaluationSeason, Collection<MarkSheetEnrolmentEvaluationBean>>>();
        CreateMarkSheetByTeacher.createMarkSheetEnrolmentEvaluationBeans(submissionBean, executionCourse, markSheetsInformation);
        return CreateMarkSheetByTeacher.createMarkSheets(markSheetsInformation, executionCourse, teacher, submissionBean.getEvaluationDate());
    }

    private static void createMarkSheetEnrolmentEvaluationBeans(MarkSheetTeacherGradeSubmissionBean submissionBean, ExecutionCourse executionCourse, Map<CurricularCourse, Map<EvaluationSeason, Collection<MarkSheetEnrolmentEvaluationBean>>> markSheetsInformation) throws InvalidArgumentsServiceException {
        Date nowDate = new Date();
        for (MarkSheetTeacherMarkBean markBean : submissionBean.getSelectedMarksToSubmit()) {
            Enrolment enrolment = markBean.getAttends().getEnrolment();
            CurricularCourse curricularCourse = enrolment.getCurricularCourse();
            Grade grade = CreateMarkSheetByTeacher.getGrade(markBean.getAttends(), markBean, markBean.getEvaluationDate(), nowDate);
            CreateMarkSheetByTeacher.addMarkSheetEvaluationBeanToMap(markSheetsInformation, curricularCourse, executionCourse, new MarkSheetEnrolmentEvaluationBean(enrolment, markBean.getEvaluationDate(), grade));
        }
    }

    private static List<EnrolmentEvaluation> createMarkSheets(Map<CurricularCourse, Map<EvaluationSeason, Collection<MarkSheetEnrolmentEvaluationBean>>> markSheetsInformation, ExecutionCourse executionCourse, Teacher responsibleTeacher, Date evaluationDate) throws InvalidArgumentsServiceException {
        ArrayList<EnrolmentEvaluation> enrolmetnEvaluations = new ArrayList<EnrolmentEvaluation>();
        for (Map.Entry<CurricularCourse, Map<EvaluationSeason, Collection<MarkSheetEnrolmentEvaluationBean>>> curricularCourseEntry : markSheetsInformation.entrySet()) {
            CurricularCourse curricularCourse = curricularCourseEntry.getKey();
            if (!curricularCourse.isGradeSubmissionAvailableFor(executionCourse.getExecutionPeriod())) {
                throw new InvalidArgumentsServiceException("error.curricularCourse.is.not.available.toSubmit.grades");
            }
            for (Map.Entry<EvaluationSeason, Collection<MarkSheetEnrolmentEvaluationBean>> seasonEntry : curricularCourseEntry.getValue().entrySet()) {
                EvaluationSeason season = seasonEntry.getKey();
                Collection<MarkSheetEnrolmentEvaluationBean> markSheetEnrolmentEvaluationBeans = seasonEntry.getValue();
                if (markSheetEnrolmentEvaluationBeans == null) continue;
                MarkSheet markSheet = curricularCourse.createNormalMarkSheet(executionCourse.getExecutionPeriod(), responsibleTeacher, evaluationDate, season, Boolean.TRUE, markSheetEnrolmentEvaluationBeans, responsibleTeacher.getPerson());
                enrolmetnEvaluations.addAll(markSheet.getEnrolmentEvaluationsSet());
            }
        }
        return enrolmetnEvaluations;
    }

    private static void checkIfTeacherLecturesExecutionCourse(Teacher teacher, ExecutionCourse executionCourse) throws InvalidArgumentsServiceException {
        if (!teacher.hasProfessorshipForExecutionCourse(executionCourse)) {
            throw new InvalidArgumentsServiceException("error.teacher.doesnot.lectures.executionCourse");
        }
    }

    private static void addMarkSheetEvaluationBeanToMap(Map<CurricularCourse, Map<EvaluationSeason, Collection<MarkSheetEnrolmentEvaluationBean>>> markSheetsInformation, CurricularCourse curricularCourse, ExecutionCourse executionCourse, MarkSheetEnrolmentEvaluationBean markSheetEvaluationBean) throws InvalidArgumentsServiceException {
        Map<EvaluationSeason, Collection<MarkSheetEnrolmentEvaluationBean>> evaluationBeansForSeason = CreateMarkSheetByTeacher.getEvaluationBeansForSeason(markSheetsInformation, curricularCourse);
        EvaluationSeason season = CreateMarkSheetByTeacher.findSeason(executionCourse, markSheetEvaluationBean.getEnrolment());
        Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeans = CreateMarkSheetByTeacher.getEvaluationBeans(evaluationBeansForSeason, season);
        evaluationBeans.add(markSheetEvaluationBean);
    }

    private static Map<EvaluationSeason, Collection<MarkSheetEnrolmentEvaluationBean>> getEvaluationBeansForSeason(Map<CurricularCourse, Map<EvaluationSeason, Collection<MarkSheetEnrolmentEvaluationBean>>> markSheetsInformation, CurricularCourse curricularCourse) {
        Map<EvaluationSeason, Collection<MarkSheetEnrolmentEvaluationBean>> evaluationBeansForSeason = markSheetsInformation.get((Object)curricularCourse);
        if (evaluationBeansForSeason == null) {
            evaluationBeansForSeason = new HashMap<EvaluationSeason, Collection<MarkSheetEnrolmentEvaluationBean>>();
            markSheetsInformation.put(curricularCourse, evaluationBeansForSeason);
        }
        return evaluationBeansForSeason;
    }

    private static Collection<MarkSheetEnrolmentEvaluationBean> getEvaluationBeans(Map<EvaluationSeason, Collection<MarkSheetEnrolmentEvaluationBean>> evaluationBeansForSeason, EvaluationSeason season) {
        Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeans = evaluationBeansForSeason.get(season);
        if (evaluationBeans == null) {
            evaluationBeans = new ArrayList<MarkSheetEnrolmentEvaluationBean>();
            evaluationBeansForSeason.put(season, evaluationBeans);
        }
        return evaluationBeans;
    }

    private static EvaluationSeason findSeason(ExecutionCourse executionCourse, Enrolment enrolment) throws InvalidArgumentsServiceException {
        if (enrolment.isImprovementForExecutionCourse(executionCourse) && enrolment.hasImprovementFor(executionCourse.getExecutionPeriod())) {
            return EvaluationSeason.readImprovementSeason();
        }
        return enrolment.getEvaluationSeason();
    }

    private static Grade getGrade(Attends attends, MarkSheetTeacherMarkBean markBean, Date evaluationDate, Date nowDate) {
        String value;
        FinalMark finalMark = attends.getFinalMark();
        if (finalMark != null) {
            finalMark.setSubmitedMark(markBean.getGradeValue());
            finalMark.setSubmitDateYearMonthDay(YearMonthDay.fromDateFields((Date)evaluationDate));
            finalMark.setWhenSubmitedYearMonthDay(YearMonthDay.fromDateFields((Date)nowDate));
            value = markBean.getGradeValue();
        } else {
            value = "NA";
        }
        return Grade.createGrade(value, attends.getEnrolment().getGradeScale());
    }
}

