/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.filter;

import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Summary;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.service.filter.AuthorizationByRoleFilter;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;

public class SummaryManagementToTeacherAuthorizationFilter
extends AuthorizationByRoleFilter {
    public static final SummaryManagementToTeacherAuthorizationFilter instance = new SummaryManagementToTeacherAuthorizationFilter();

    @Override
    protected RoleType getRoleType() {
        return RoleType.TEACHER;
    }

    public void execute(Summary summary, Professorship professorshipLogged) throws NotAuthorizedException {
        try {
            User userViewLogged = Authenticate.getUser();
            boolean executionCourseResponsibleLogged = professorshipLogged.isResponsibleFor();
            if (userViewLogged == null || professorshipLogged == null) {
                throw new NotAuthorizedException("error.summary.not.authorized");
            }
            if (executionCourseResponsibleLogged && summary.getProfessorship() != null && !summary.getProfessorship().equals((Object)professorshipLogged)) {
                throw new NotAuthorizedException("error.summary.not.authorized");
            }
            if (!(executionCourseResponsibleLogged || summary.getProfessorship() != null && summary.getProfessorship().equals((Object)professorshipLogged))) {
                throw new NotAuthorizedException("error.summary.not.authorized");
            }
        }
        catch (RuntimeException ex) {
            throw new NotAuthorizedException("error.summary.not.authorized");
        }
    }
}

