/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.filter;

import java.util.ArrayList;
import java.util.Collection;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.service.filter.Filtro;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixframework.FenixFramework;

public class CoordinatorExecutionDegreeAuthorizationFilter
extends Filtro {
    public static final CoordinatorExecutionDegreeAuthorizationFilter instance = new CoordinatorExecutionDegreeAuthorizationFilter();

    public void execute(String executionDegreeId) throws NotAuthorizedException {
        User id = Authenticate.getUser();
        if (id != null && !this.containsRoleType(id) || id != null && !this.hasPrivilege(id, executionDegreeId) || id == null) {
            throw new NotAuthorizedException();
        }
    }

    @Override
    protected Collection<RoleType> getNeededRoleTypes() {
        ArrayList<RoleType> roles = new ArrayList<RoleType>();
        roles.add(RoleType.RESOURCE_ALLOCATION_MANAGER);
        roles.add(RoleType.COORDINATOR);
        return roles;
    }

    private boolean hasPrivilege(User id, String executionDegreeId) {
        if (RoleType.RESOURCE_ALLOCATION_MANAGER.isMember(id.getPerson().getUser())) {
            return true;
        }
        if (RoleType.COORDINATOR.isMember(id.getPerson().getUser())) {
            String executionDegreeID = executionDegreeId;
            if (executionDegreeID == null) {
                return false;
            }
            Person person = id.getPerson();
            ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)executionDegreeID);
            if (executionDegree == null) {
                return false;
            }
            Coordinator coordinator = executionDegree.getCoordinatorByTeacher(person);
            if (coordinator != null) {
                return true;
            }
        }
        return false;
    }
}

