/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.person;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.DistrictSubdivision;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.ProfessionType;
import org.fenixedu.academic.domain.ProfessionalSituationConditionType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyPersonalDetails;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.contacts.MobilePhone;
import org.fenixedu.academic.domain.contacts.Phone;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.contacts.PhysicalAddressData;
import org.fenixedu.academic.domain.contacts.WebAddress;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.person.MaritalStatus;
import org.fenixedu.academic.dto.person.PersonBean$callable$save;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PersonBean
implements Serializable {
    private Person person;
    private String name;
    private String nickname;
    private String givenNames;
    private String familyNames;
    private String username;
    private Gender gender;
    private String documentIdNumber;
    private IDDocumentType idDocumentType;
    private String documentIdEmissionLocation;
    private YearMonthDay documentIdEmissionDate;
    private YearMonthDay documentIdExpirationDate;
    private Country fiscalCountry;
    private String socialSecurityNumber;
    private ProfessionType professionType;
    private ProfessionalSituationConditionType professionalCondition;
    private String profession;
    private MaritalStatus maritalStatus = MaritalStatus.UNKNOWN;
    private String phone;
    private String workPhone;
    private String mobile;
    private String email;
    private String webAddress;
    private boolean isEmailAvailable;
    private boolean isHomepageAvailable;
    private YearMonthDay dateOfBirth;
    private Country nationality;
    private String parishOfBirth;
    private String districtSubdivisionOfBirth;
    private String districtOfBirth;
    private String fatherName;
    private String motherName;
    private Country countryOfBirth;
    private String address;
    private String areaCode;
    private String areaOfAreaCode;
    private String area;
    private String parishOfResidence;
    private String districtSubdivisionOfResidence;
    private String districtOfResidence;
    private DistrictSubdivision districtSubdivisionOfResidenceObject;
    private Country countryOfResidence;
    private Integer studentNumber;
    private String emailConfirmation;
    private String eidentifier;
    private String identificationDocumentSeriesNumber;
    public static final Advice advice$save = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    public PersonBean() {
    }

    public PersonBean(String name, String identificationNumber, IDDocumentType idDocumentType, YearMonthDay dateOfBirth) {
        this.setName(name);
        this.setDocumentIdNumber(identificationNumber);
        this.setIdDocumentType(idDocumentType);
        this.setDateOfBirth(dateOfBirth);
    }

    public PersonBean(String name, String identificationNumber, IDDocumentType idDocumentType, YearMonthDay dateOfBirth, Integer studentNumber) {
        this.setName(name);
        this.setDocumentIdNumber(identificationNumber);
        this.setIdDocumentType(idDocumentType);
        this.setDateOfBirth(dateOfBirth);
        this.setStudentNumber(studentNumber);
    }

    public PersonBean(IndividualCandidacyPersonalDetails details) {
        if (details.isInternal()) {
            this.initPerson(details.getPerson());
        } else {
            this.initPersonBeanFromPersonalDetails(details);
        }
        this.initPersonBeanFromPersonalDetails(details);
    }

    public PersonBean(Person person) {
        this.initPerson(person);
    }

    private void initPersonBeanFromPersonalDetails(IndividualCandidacyPersonalDetails personalDetails) {
        this.setGivenNames(personalDetails.getGivenNames());
        this.setFamilyNames(personalDetails.getFamilyNames());
        this.setGender(personalDetails.getGender());
        this.setMaritalStatus(personalDetails.getMaritalStatus());
        this.setNationality(personalDetails.getCountry());
        this.setDateOfBirth(personalDetails.getDateOfBirthYearMonthDay());
        this.setDocumentIdEmissionDate(personalDetails.getEmissionDateOfDocumentIdYearMonthDay());
        this.setDocumentIdEmissionLocation(personalDetails.getEmissionLocationOfDocumentId());
        this.setDocumentIdExpirationDate(personalDetails.getExpirationDateOfDocumentIdYearMonthDay());
        this.setDocumentIdNumber(personalDetails.getDocumentIdNumber());
        this.setIdDocumentType(personalDetails.getIdDocumentType());
        this.setFiscalCountry(personalDetails.getFiscalCountry());
        this.setSocialSecurityNumber(personalDetails.getSocialSecurityNumber());
        this.setAddress(personalDetails.getAddress());
        this.setArea(personalDetails.getArea());
        this.setAreaCode(personalDetails.getAreaCode());
        this.setAreaOfAreaCode(personalDetails.getAreaOfAreaCode());
        this.setCountryOfResidence(personalDetails.getCountryOfResidence());
        this.setPhone(personalDetails.getTelephoneContact());
        this.setEmail(personalDetails.getEmail());
        if (personalDetails.isInternal()) {
            Person person = personalDetails.getPerson();
            this.setUsername(person.getUsername());
            this.setPerson(person);
            this.setFatherName(person.getNameOfFather());
            this.setMotherName(person.getNameOfMother());
            this.setProfession(person.getProfession());
            this.setCountryOfBirth(person.getCountryOfBirth());
            this.setParishOfBirth(person.getParishOfBirth());
            this.setDistrictOfBirth(person.getDistrictOfBirth());
            this.setDistrictSubdivisionOfBirth(person.getDistrictSubdivisionOfBirth());
            if (person.hasDefaultPhysicalAddress()) {
                PhysicalAddress physicalAddress = person.getDefaultPhysicalAddress();
                this.setParishOfResidence(physicalAddress.getParishOfResidence());
                this.setDistrictSubdivisionOfResidence(physicalAddress.getDistrictSubdivisionOfResidence());
                this.setDistrictOfResidence(physicalAddress.getDistrictOfResidence());
            }
            this.setMobile(person.hasDefaultMobilePhone() ? person.getDefaultMobilePhone().getNumber() : null);
            this.setWebAddress(person.hasDefaultWebAddress() ? person.getDefaultWebAddress().getUrl() : null);
            this.setEmailAvailable(person.getAvailableEmail());
            this.setHomepageAvailable(person.getAvailableWebSite());
            this.setEidentifier(person.getEidentifier());
        }
    }

    private void initPerson(Person person) {
        this.setNickname(person.getNickname());
        this.setGivenNames(person.getGivenNames());
        this.setFamilyNames(person.getFamilyNames());
        this.setUsername(person.getUsername());
        this.setGender(person.getGender());
        this.setMaritalStatus(person.getMaritalStatus());
        this.setFatherName(person.getNameOfFather());
        this.setMotherName(person.getNameOfMother());
        this.setProfession(person.getProfession());
        this.setNationality(person.getCountry());
        this.setCountryOfBirth(person.getCountryOfBirth());
        this.setDateOfBirth(person.getDateOfBirthYearMonthDay());
        this.setParishOfBirth(person.getParishOfBirth());
        this.setDistrictOfBirth(person.getDistrictOfBirth());
        this.setDistrictSubdivisionOfBirth(person.getDistrictSubdivisionOfBirth());
        this.setDocumentIdEmissionDate(person.getEmissionDateOfDocumentIdYearMonthDay());
        this.setDocumentIdEmissionLocation(person.getEmissionLocationOfDocumentId());
        this.setDocumentIdExpirationDate(person.getExpirationDateOfDocumentIdYearMonthDay());
        this.setDocumentIdNumber(person.getDocumentIdNumber());
        this.setIdDocumentType(person.getIdDocumentType());
        this.setFiscalCountry(person.getFiscalCountry());
        this.setSocialSecurityNumber(person.getSocialSecurityNumber());
        if (person.hasDefaultPhysicalAddress()) {
            PhysicalAddress physicalAddress = person.getDefaultPhysicalAddress();
            this.setAddress(physicalAddress.getAddress());
            this.setArea(physicalAddress.getArea());
            this.setAreaCode(physicalAddress.getAreaCode());
            this.setAreaOfAreaCode(physicalAddress.getAreaOfAreaCode());
            this.setParishOfResidence(physicalAddress.getParishOfResidence());
            this.setDistrictSubdivisionOfResidence(physicalAddress.getDistrictSubdivisionOfResidence());
            this.setDistrictOfResidence(physicalAddress.getDistrictOfResidence());
            this.setCountryOfResidence(physicalAddress.getCountryOfResidence());
        }
        this.setPhone(person.hasDefaultPhone() ? person.getDefaultPhone().getNumber() : null);
        this.setMobile(person.hasDefaultMobilePhone() ? person.getDefaultMobilePhone().getNumber() : null);
        this.setWebAddress(person.hasDefaultWebAddress() ? person.getDefaultWebAddress().getUrl() : null);
        this.setEmail(person.getEmail());
        this.setEmailAvailable(person.getAvailableEmail());
        this.setHomepageAvailable(person.getAvailableWebSite());
        this.setPerson(person);
        this.setIdentificationDocumentSeriesNumber(person.getIdentificationDocumentSeriesNumberValue());
        if (Strings.isNullOrEmpty((String)this.getIdentificationDocumentSeriesNumber())) {
            this.setIdentificationDocumentSeriesNumber(person.getIdentificationDocumentExtraDigitValue());
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaOfAreaCode() {
        return this.areaOfAreaCode;
    }

    public void setAreaOfAreaCode(String areaOfAreaCode) {
        this.areaOfAreaCode = areaOfAreaCode;
    }

    public Country getCountryOfBirth() {
        return this.countryOfBirth;
    }

    public void setCountryOfBirth(Country countryOfBirth) {
        this.countryOfBirth = countryOfBirth;
    }

    public Country getCountryOfResidence() {
        return this.countryOfResidence;
    }

    public void setCountryOfResidence(Country countryOfResidence) {
        this.countryOfResidence = countryOfResidence;
    }

    public boolean hasCountryOfResidence() {
        return this.getCountryOfResidence() != null;
    }

    public YearMonthDay getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(YearMonthDay dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getDistrictOfBirth() {
        return this.districtOfBirth;
    }

    public void setDistrictOfBirth(String districtOfBirth) {
        this.districtOfBirth = districtOfBirth;
    }

    public String getDistrictOfResidence() {
        return this.getDistrictSubdivisionOfResidenceObject() != null ? this.getDistrictSubdivisionOfResidenceObject().getDistrict().getName() : this.districtOfResidence;
    }

    public void setDistrictOfResidence(String districtOfResidence) {
        this.districtOfResidence = districtOfResidence;
    }

    public DistrictSubdivision getDistrictSubdivisionOfResidenceObject() {
        return this.districtSubdivisionOfResidenceObject;
    }

    public void setDistrictSubdivisionOfResidenceObject(DistrictSubdivision districtSubdivision) {
        this.districtSubdivisionOfResidenceObject = districtSubdivision;
    }

    public String getDistrictSubdivisionOfBirth() {
        return this.districtSubdivisionOfBirth;
    }

    public void setDistrictSubdivisionOfBirth(String districtSubdivisionOfBirth) {
        this.districtSubdivisionOfBirth = districtSubdivisionOfBirth;
    }

    public String getDistrictSubdivisionOfResidence() {
        return this.getDistrictSubdivisionOfResidenceObject() != null ? this.getDistrictSubdivisionOfResidenceObject().getName() : this.districtSubdivisionOfResidence;
    }

    public void setDistrictSubdivisionOfResidence(String districtSubdivisionOfResidence) {
        this.districtSubdivisionOfResidence = districtSubdivisionOfResidence;
    }

    public YearMonthDay getDocumentIdEmissionDate() {
        return this.documentIdEmissionDate;
    }

    public void setDocumentIdEmissionDate(YearMonthDay documentIdEmissionDate) {
        this.documentIdEmissionDate = documentIdEmissionDate;
    }

    public String getDocumentIdEmissionLocation() {
        return this.documentIdEmissionLocation;
    }

    public void setDocumentIdEmissionLocation(String documentIdEmissionLocation) {
        this.documentIdEmissionLocation = documentIdEmissionLocation;
    }

    public YearMonthDay getDocumentIdExpirationDate() {
        return this.documentIdExpirationDate;
    }

    public void setDocumentIdExpirationDate(YearMonthDay documentIdExpirationDate) {
        this.documentIdExpirationDate = documentIdExpirationDate;
    }

    public String getDocumentIdNumber() {
        return this.documentIdNumber;
    }

    public void setDocumentIdNumber(String documentIdNumber) {
        this.documentIdNumber = documentIdNumber;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFatherName() {
        return this.fatherName;
    }

    public void setFatherName(String fatherName) {
        this.fatherName = fatherName;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public IDDocumentType getIdDocumentType() {
        return this.idDocumentType;
    }

    public void setIdDocumentType(IDDocumentType idDocumentType) {
        this.idDocumentType = idDocumentType;
    }

    public boolean isEmailAvailable() {
        return this.isEmailAvailable;
    }

    public void setEmailAvailable(boolean isEmailAvailable) {
        this.isEmailAvailable = isEmailAvailable;
    }

    public boolean isHomepageAvailable() {
        return this.isHomepageAvailable;
    }

    public void setHomepageAvailable(boolean isHomepageAvailable) {
        this.isHomepageAvailable = isHomepageAvailable;
    }

    public MaritalStatus getMaritalStatus() {
        return this.maritalStatus == null ? MaritalStatus.UNKNOWN : this.maritalStatus;
    }

    public void setMaritalStatus(MaritalStatus maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobileNumber) {
        this.mobile = mobileNumber;
    }

    public String getMotherName() {
        return this.motherName;
    }

    public void setMotherName(String motherName) {
        this.motherName = motherName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGivenNames() {
        return this.givenNames;
    }

    public void setGivenNames(String givenNames) {
        this.givenNames = givenNames;
    }

    public String getFamilyNames() {
        return this.familyNames;
    }

    public void setFamilyNames(String familyNames) {
        this.familyNames = familyNames;
    }

    public Country getNationality() {
        return this.nationality;
    }

    public void setNationality(Country nationality) {
        this.nationality = nationality;
    }

    public String getParishOfBirth() {
        return this.parishOfBirth;
    }

    public void setParishOfBirth(String parishOfBirth) {
        this.parishOfBirth = parishOfBirth;
    }

    public String getParishOfResidence() {
        return this.parishOfResidence;
    }

    public void setParishOfResidence(String parishOfResidence) {
        this.parishOfResidence = parishOfResidence;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phoneNumber) {
        this.phone = phoneNumber;
    }

    public String getWorkPhone() {
        return this.workPhone;
    }

    public void setWorkPhone(String workPhone) {
        this.workPhone = workPhone;
    }

    public ProfessionType getProfessionType() {
        return this.professionType;
    }

    public void setProfessionType(ProfessionType professionType) {
        this.professionType = professionType;
    }

    public ProfessionalSituationConditionType getProfessionalCondition() {
        return this.professionalCondition;
    }

    public void setProfessionalCondition(ProfessionalSituationConditionType professionalCondition) {
        this.professionalCondition = professionalCondition;
    }

    public String getProfession() {
        return this.profession;
    }

    public void setProfession(String profession) {
        this.profession = profession;
    }

    public Country getFiscalCountry() {
        return this.fiscalCountry;
    }

    public void setFiscalCountry(Country fiscalCountry) {
        this.fiscalCountry = fiscalCountry;
    }

    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public String getFiscalCode() {
        return this.socialSecurityNumber;
    }

    public void setFiscalCode(String value) {
        this.socialSecurityNumber = value;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getWebAddress() {
        return this.webAddress;
    }

    public void setWebAddress(String webAddress) {
        this.webAddress = webAddress;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public List<PhysicalAddress> getSortedPhysicalAdresses() {
        List result = this.getPerson().getPendingOrValidPhysicalAddresses();
        Collections.sort(result, PhysicalAddress.COMPARATOR_BY_ADDRESS);
        return result;
    }

    public PhysicalAddressData getPhysicalAddressData() {
        return new PhysicalAddressData(this.getAddress(), this.getAreaCode(), this.getAreaOfAreaCode(), this.getArea(), this.getParishOfResidence(), this.getDistrictSubdivisionOfResidence(), this.getDistrictOfResidence(), this.getCountryOfResidence());
    }

    public List<Phone> getSortedPhones() {
        List result = this.getPerson().getPendingOrValidPhones();
        Collections.sort(result, Phone.COMPARATOR_BY_NUMBER);
        return result;
    }

    public List<MobilePhone> getSortedMobilePhones() {
        List result = this.getPerson().getPendingOrValidMobilePhones();
        Collections.sort(result, MobilePhone.COMPARATOR_BY_NUMBER);
        return result;
    }

    public List<EmailAddress> getSortedEmailAddresses() {
        List result = this.getPerson().getPendingOrValidEmailAddresses();
        Collections.sort(result, EmailAddress.COMPARATOR_BY_EMAIL);
        return result;
    }

    public List<WebAddress> getSortedWebAddresses() {
        List result = this.getPerson().getWebAddresses();
        Collections.sort(result, WebAddress.COMPARATOR_BY_URL);
        return result;
    }

    public boolean hasPerson() {
        return this.getPerson() != null;
    }

    public boolean hasStudent() {
        return this.hasPerson() && this.getPerson().getStudent() != null;
    }

    public Integer getStudentNumber() {
        return this.studentNumber;
    }

    public void setStudentNumber(Integer studentNumber) {
        this.studentNumber = studentNumber;
    }

    public String getEmailConfirmation() {
        return this.emailConfirmation;
    }

    public void setEmailConfirmation(String value) {
        this.emailConfirmation = value;
    }

    public String getEidentifier() {
        return this.eidentifier;
    }

    public void setEidentifier(String eidentifier) {
        this.eidentifier = eidentifier;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Person save() {
        return this.save(this.getPerson());
    }

    public String getIdentificationDocumentSeriesNumber() {
        return this.identificationDocumentSeriesNumber;
    }

    public void setIdentificationDocumentSeriesNumber(String identificationDocumentSeriesNumber) {
        this.identificationDocumentSeriesNumber = identificationDocumentSeriesNumber;
    }

    public Person save(Person person) {
        return (Person)((Object)advice$save.perform((Callable)new PersonBean$callable$save(this, person)));
    }

    static /* synthetic */ Person advised$save(PersonBean this_, Person person) {
        person.getProfile().changeName(this_.getGivenNames(), this_.getFamilyNames(), null);
        person.setGender(this_.getGender());
        person.setProfession(this_.getProfession());
        person.setMaritalStatus(this_.getMaritalStatus());
        person.setIdentification(this_.getDocumentIdNumber(), this_.getIdDocumentType());
        person.setEmissionLocationOfDocumentId(this_.getDocumentIdEmissionLocation());
        person.setEmissionDateOfDocumentIdYearMonthDay(this_.getDocumentIdEmissionDate());
        person.setExpirationDateOfDocumentIdYearMonthDay(this_.getDocumentIdExpirationDate());
        person.editSocialSecurityNumber(this_.getFiscalCountry(), this_.getSocialSecurityNumber());
        person.setEidentifier(this_.getEidentifier());
        person.setDateOfBirthYearMonthDay(this_.getDateOfBirth());
        person.setCountry(this_.getNationality());
        person.setParishOfBirth(this_.getParishOfBirth());
        person.setDistrictSubdivisionOfBirth(this_.getDistrictSubdivisionOfBirth());
        person.setDistrictOfBirth(this_.getDistrictOfBirth());
        person.setCountryOfBirth(this_.getCountryOfBirth());
        person.setNameOfMother(this_.getMotherName());
        person.setNameOfFather(this_.getFatherName());
        person.setDefaultPhysicalAddressData(this_.getPhysicalAddressData(), true);
        person.setDefaultPhoneNumber(this_.getPhone());
        person.setDefaultMobilePhoneNumber(this_.getMobile());
        person.setDefaultWebAddressUrl(this_.getWebAddress());
        person.setDefaultEmailAddressValue(this_.getEmail(), true);
        return person;
    }
}

