/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.candidacy;

import java.io.Serializable;
import java.util.Collection;
import org.fenixedu.academic.domain.EntryPhase;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;

public class IngressionInformationBean
implements Serializable {
    private RegistrationProtocol registrationProtocol;
    private String agreementInformation;
    private IngressionType ingressionType;
    private EntryPhase entryPhase;
    private YearMonthDay studiesStartDate;
    private YearMonthDay homologationDate;
    private boolean requestAgreementInformation;
    private ExecutionYear executionYear;
    private Registration registration;
    private LocalDate reingressionDate;

    public IngressionInformationBean(Registration registration) {
        this.setEntryPhase(registration.getStudentCandidacy().getEntryPhase());
        this.setRegistration(registration);
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    public Registration getRegistration() {
        return this.registration;
    }

    public void setRegistration(Registration registration) {
        this.registration = registration;
    }

    public Collection<ExecutionYear> getExecutionYearsSinceRegistrationStart() {
        return ExecutionYear.readExecutionYears(this.getRegistration().getStartExecutionYear(), ExecutionYear.readCurrentExecutionYear());
    }

    public LocalDate getReingressionDate() {
        return this.reingressionDate;
    }

    public void setReingressionDate(LocalDate reingressionDate) {
        this.reingressionDate = reingressionDate;
    }

    public IngressionInformationBean() {
        this.registrationProtocol = RegistrationProtocol.getDefault();
        this.requestAgreementInformation = false;
    }

    public RegistrationProtocol getRegistrationProtocol() {
        return this.registrationProtocol;
    }

    public void setRegistrationProtocol(RegistrationProtocol registrationProtocol) {
        this.registrationProtocol = registrationProtocol;
        this.requestAgreementInformation = registrationProtocol != null && registrationProtocol.isMilitaryAgreement();
    }

    public boolean hasRegistrationProtocol() {
        return this.getRegistrationProtocol() != null;
    }

    public String getAgreementInformation() {
        return this.agreementInformation;
    }

    public void setAgreementInformation(String agreementInformation) {
        this.agreementInformation = agreementInformation;
    }

    public boolean isRequestAgreementInformation() {
        return this.requestAgreementInformation;
    }

    public IngressionType getIngressionType() {
        return this.ingressionType;
    }

    public void setIngressionType(IngressionType ingressionType) {
        this.ingressionType = ingressionType;
    }

    public EntryPhase getEntryPhase() {
        return this.entryPhase;
    }

    public void setEntryPhase(EntryPhase entryPhase) {
        this.entryPhase = entryPhase;
    }

    public void clearIngressionAndEntryPhase() {
        this.ingressionType = null;
        this.entryPhase = null;
        this.studiesStartDate = null;
        this.homologationDate = null;
    }

    public void clearAgreement() {
        this.registrationProtocol = RegistrationProtocol.getDefault();
        this.agreementInformation = null;
    }

    public YearMonthDay getHomologationDate() {
        return this.homologationDate;
    }

    public void setHomologationDate(YearMonthDay homologationDate) {
        this.homologationDate = homologationDate;
    }

    public YearMonthDay getStudiesStartDate() {
        return this.studiesStartDate;
    }

    public void setStudiesStartDate(YearMonthDay studiesStartDate) {
        this.studiesStartDate = studiesStartDate;
    }
}

