/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.treasury;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.treasury.IAcademicServiceRequestAndAcademicTaxTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryTarget;
import org.fenixedu.academic.domain.treasury.IImprovementTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IPaymentCodePool;
import org.fenixedu.academic.domain.treasury.ITreasuryEntity;
import org.fenixedu.academic.domain.treasury.ITreasuryProduct;
import org.fenixedu.academic.domain.treasury.ITuitionTreasuryEvent;
import org.joda.time.LocalDate;

public interface ITreasuryBridgeAPI {
    public static final String ACADEMIC_SERVICE_REQUEST_NEW_SITUATION_EVENT = "ACADEMIC_SERVICE_REQUEST_NEW_SITUATION_EVENT";
    public static final String ACADEMIC_SERVICE_REQUEST_REJECT_OR_CANCEL_EVENT = "ACADEMIC_SERVICE_REQUEST_REJECT_OR_CANCEL_EVENT";
    public static final String STANDALONE_ENROLMENT = "STANDALONE_ENROLMENT";
    public static final String EXTRACURRICULAR_ENROLMENT = "EXTRACURRICULAR_ENROLMENT";
    public static final String IMPROVEMENT_ENROLMENT = "IMPROVEMENT_ENROLMENT";
    public static final String NORMAL_ENROLMENT = "NORMAL_ENROLMENT";

    public Set<ITreasuryEntity> getTreasuryEntities();

    public ITreasuryEntity getTreasuryEntityByCode(String var1);

    public Set<ITreasuryProduct> getProducts(ITreasuryEntity var1);

    public ITreasuryProduct getProductByCode(String var1);

    public List<IPaymentCodePool> getPaymentCodePools(ITreasuryEntity var1);

    public IPaymentCodePool getPaymentCodePoolByCode(String var1);

    public void registerNewAcademicServiceRequestSituationHandler();

    public void registerAcademicServiceRequestCancelOrRejectHandler();

    public IAcademicServiceRequestAndAcademicTaxTreasuryEvent academicTreasuryEventForAcademicServiceRequest(AcademicServiceRequest var1);

    public void registerStandaloneEnrolmentHandler();

    public void registerExtracurricularEnrolmentHandler();

    public void registerImprovementEnrolmentHandler();

    public void standaloneUnenrolment(Enrolment var1);

    public void extracurricularUnenrolment(Enrolment var1);

    public void improvementUnrenrolment(EnrolmentEvaluation var1);

    public boolean isToPayTuition(Registration var1, ExecutionYear var2);

    public ITuitionTreasuryEvent getTuitionForRegistrationTreasuryEvent(Registration var1, ExecutionYear var2);

    public ITuitionTreasuryEvent getTuitionForStandaloneTreasuryEvent(Registration var1, ExecutionYear var2);

    public ITuitionTreasuryEvent getTuitionForExtracurricularTreasuryEvent(Registration var1, ExecutionYear var2);

    public ITuitionTreasuryEvent getTuitionForImprovementTreasuryEvent(Registration var1, ExecutionYear var2);

    public IImprovementTreasuryEvent getImprovementTaxTreasuryEvent(Registration var1, ExecutionYear var2);

    public List<IAcademicTreasuryEvent> getAcademicTaxesList(Registration var1, ExecutionYear var2);

    public IAcademicTreasuryEvent getAcademicTreasuryEventForTarget(IAcademicTreasuryTarget var1);

    public void anullDebtsForTarget(IAcademicTreasuryTarget var1, String var2);

    public IAcademicTreasuryEvent createDebt(ITreasuryEntity var1, ITreasuryProduct var2, IAcademicTreasuryTarget var3, LocalDate var4, boolean var5, IPaymentCodePool var6, int var7, int var8);

    public IAcademicTreasuryEvent createDebt(ITreasuryEntity var1, ITreasuryProduct var2, IAcademicTreasuryTarget var3, BigDecimal var4, LocalDate var5, LocalDate var6, boolean var7, IPaymentCodePool var8);

    public boolean isAcademicalActsBlocked(Person var1, LocalDate var2);

    public boolean isAcademicalActBlockingSuspended(Person var1, LocalDate var2);

    public List<IAcademicTreasuryEvent> getAllAcademicTreasuryEventsList(Person var1, ExecutionYear var2);

    public List<IAcademicTreasuryEvent> getAllAcademicTreasuryEventsList(Person var1);

    public boolean isPersonAccountTreasuryManagementAvailable(Person var1);

    public String getPersonAccountTreasuryManagementURL(Person var1);

    public String getRegistrationAccountTreasuryManagementURL(Registration var1);

    public void createAcademicDebts(Registration var1);

    public boolean isValidFiscalNumber(String var1, String var2);

    public boolean updateCustomer(Person var1, String var2, String var3);
}

