/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.Credits;
import org.fenixedu.academic.domain.studentCurriculum.EnrolmentWrapper_Base;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolmentWrapper;
import org.fenixedu.academic.domain.studentCurriculum.InternalEnrolmentWrapper;
import org.fenixedu.bennu.core.domain.Bennu;

public abstract class EnrolmentWrapper
extends EnrolmentWrapper_Base {
    protected EnrolmentWrapper() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    protected void init(Credits credits) {
        String[] args = new String[]{};
        if (credits == null) {
            throw new DomainException("error.EnrolmentWrapper.credits.cannot.be.null", args);
        }
        super.setCredits(credits);
    }

    public void setCredits(Credits credits) {
        throw new DomainException("error.EnrolmentWrapper.cannot.modify.credits", new String[0]);
    }

    public void delete() {
        super.setCredits(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public abstract IEnrolment getIEnrolment();

    public static EnrolmentWrapper create(Credits credits, IEnrolment enrolment) {
        if (enrolment.isExternalEnrolment()) {
            return new ExternalEnrolmentWrapper(credits, (ExternalEnrolment)enrolment);
        }
        if (enrolment.isEnrolment()) {
            return new InternalEnrolmentWrapper(credits, (Enrolment)enrolment);
        }
        throw new DomainException("error.EnrolmentWrapper.unknown.enrolment", new String[0]);
    }
}

