/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularCourseEquivalence;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine_Base;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.util.EnrolmentAction;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.academic.util.predicates.ResultCollection;
import org.fenixedu.bennu.core.security.Authenticate;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.DomainObject;

public abstract class CurriculumLine
extends CurriculumLine_Base {
    public static final Comparator<CurriculumLine> COMPARATOR_BY_APPROVEMENT_DATE_AND_ID = new Comparator<CurriculumLine>(){

        @Override
        public int compare(CurriculumLine o1, CurriculumLine o2) {
            int result = o1.getApprovementDate() != null && o2.getApprovementDate() != null ? o1.getApprovementDate().compareTo((ReadablePartial)o2.getApprovementDate()) : 0;
            return result == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2) : result;
        }
    };

    public CurriculumLine() {
        this.setCreatedBy(this.getCurrentUser());
        this.setUsedInSeparationCycle(false);
    }

    public final ExecutionYear getExecutionYear() {
        ExecutionSemester executionSemester = this.getExecutionPeriod();
        return executionSemester == null ? null : executionSemester.getExecutionYear();
    }

    public YearMonthDay getApprovementDate() {
        return this.isApproved() ? this.calculateConclusionDate() : null;
    }

    public final boolean isLeaf() {
        return true;
    }

    public final boolean isRoot() {
        return false;
    }

    public boolean isApproved(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return false;
    }

    public boolean isEnroledInExecutionPeriod(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return false;
    }

    public boolean isPropaedeutic() {
        return this.getCurriculumGroup().isPropaedeutic();
    }

    public boolean isExtraCurricular() {
        return this.getCurriculumGroup().isExtraCurriculum();
    }

    public boolean isOptional() {
        return false;
    }

    public boolean isStandalone() {
        return this.getCurriculumGroup().isStandalone();
    }

    protected final void validateDegreeModuleLink(CurriculumGroup curriculumGroup, CurricularCourse curricularCourse) {
        if (!curriculumGroup.getDegreeModule().validate(curricularCourse)) {
            throw new DomainException("error.studentCurriculum.curriculumLine.invalid.curriculum.group", new String[0]);
        }
    }

    public List<Enrolment> getEnrolments() {
        return Collections.emptyList();
    }

    public boolean hasAnyEnrolments() {
        return false;
    }

    public final void addApprovedCurriculumLines(Collection<CurriculumLine> result) {
        if (this.isApproved()) {
            result.add(this);
        }
    }

    public final boolean hasAnyApprovedCurriculumLines() {
        return this.isApproved();
    }

    public void collectDismissals(List<Dismissal> result) {
    }

    public StudentCurricularPlan getStudentCurricularPlan() {
        return this.getCurriculumGroup() != null ? this.getCurriculumGroup().getStudentCurricularPlan() : null;
    }

    public boolean hasEnrolmentWithEnroledState(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return false;
    }

    public ExecutionYear getIEnrolmentsLastExecutionYear() {
        return this.getExecutionYear();
    }

    public void getCurriculumModules(ResultCollection<CurriculumModule> collection) {
        collection.condicionalAdd((CurriculumModule)((Object)this));
    }

    public CurricularCourse getCurricularCourse() {
        return (CurricularCourse)((Object)this.getDegreeModule());
    }

    public final void setCurricularCourse(CurricularCourse curricularCourse) {
        this.setDegreeModule((DegreeModule)((Object)curricularCourse));
    }

    public void setDegreeModule(DegreeModule degreeModule) {
        if (degreeModule != null && !(degreeModule instanceof CurricularCourse)) {
            throw new DomainException("error.curriculumLine.DegreeModuleCanOnlyBeCurricularCourse", new String[0]);
        }
        super.setDegreeModule(degreeModule);
    }

    public final boolean hasCurricularCourse() {
        return this.getDegreeModule() != null;
    }

    public Enrolment findEnrolmentFor(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return null;
    }

    public Set<IDegreeModuleToEvaluate> getDegreeModulesToEvaluate(ExecutionSemester executionSemester) {
        return Collections.emptySet();
    }

    public Enrolment getApprovedEnrolment(CurricularCourse curricularCourse) {
        return null;
    }

    public Dismissal getDismissal(CurricularCourse curricularCourse) {
        return null;
    }

    public final void getAllDegreeModules(Collection<DegreeModule> degreeModules) {
        degreeModules.add(this.getDegreeModule());
    }

    public Set<CurriculumLine> getAllCurriculumLines() {
        return Collections.singleton(this);
    }

    public MultiLanguageString getName() {
        ExecutionSemester period = this.getExecutionPeriod();
        CurricularCourse course = this.getCurricularCourse();
        return new MultiLanguageString().with(MultiLanguageString.pt, course.getName(period)).with(MultiLanguageString.en, course.getNameEn(period));
    }

    public boolean hasExecutionPeriod() {
        return this.getExecutionPeriod() != null;
    }

    protected boolean hasCurricularCourse(CurricularCourse own, CurricularCourse other, ExecutionSemester executionSemester) {
        return own.isEquivalent(other) || this.hasCurricularCourseEquivalence(own, other, executionSemester);
    }

    private boolean hasCurricularCourseEquivalence(CurricularCourse sourceCurricularCourse, CurricularCourse equivalentCurricularCourse, ExecutionSemester executionSemester) {
        for (CurricularCourseEquivalence curricularCourseEquivalence : sourceCurricularCourse.getCurricularCourseEquivalencesFor(equivalentCurricularCourse)) {
            if (!this.oldCurricularCoursesAreApproved(curricularCourseEquivalence, executionSemester)) continue;
            return true;
        }
        return false;
    }

    private boolean oldCurricularCoursesAreApproved(CurricularCourseEquivalence curricularCourseEquivalence, ExecutionSemester executionSemester) {
        for (CurricularCourse curricularCourse : curricularCourseEquivalence.getOldCurricularCoursesSet()) {
            if (this.getStudentCurricularPlan().isApproved(curricularCourse, executionSemester)) continue;
            return false;
        }
        return true;
    }

    public boolean hasConcluded(DegreeModule degreeModule, ExecutionYear executionYear) {
        return this.getDegreeModule() == degreeModule && this.isConcluded(executionYear).value();
    }

    public CurriculumLine getApprovedCurriculumLine(CurricularCourse curricularCourse) {
        return this.isApproved(curricularCourse) ? this : null;
    }

    protected String getCurrentUser() {
        return Authenticate.getUser() != null ? Authenticate.getUser().getUsername() : null;
    }

    public abstract boolean isApproved();

    public abstract boolean isValid(ExecutionSemester var1);

    public abstract ExecutionSemester getExecutionPeriod();

    public boolean hasEnrolment(ExecutionSemester executionSemester) {
        return false;
    }

    public boolean hasEnrolment(ExecutionYear executionYear) {
        return false;
    }

    public boolean isEnroledInSpecialSeason(ExecutionSemester executionSemester) {
        return false;
    }

    public boolean isEnroledInSpecialSeason(ExecutionYear executionYear) {
        return false;
    }

    public boolean hasCreatedBy() {
        return this.getCreatedBy() != null && !this.getCreatedBy().isEmpty();
    }

    public int getNumberOfAllApprovedEnrolments(ExecutionSemester executionSemester) {
        return 0;
    }

    public Set<CurriculumGroup> getAllCurriculumGroups() {
        return Collections.emptySet();
    }

    public Set<CurriculumGroup> getAllCurriculumGroupsWithoutNoCourseGroupCurriculumGroups() {
        return Collections.emptySet();
    }

    protected abstract void createCurriculumLineLog(EnrolmentAction var1);

    public abstract BigDecimal getEctsCreditsForCurriculum();

    public abstract double getAccumulatedEctsCredits(ExecutionSemester var1);

    public abstract String getModuleTypeName();
}

