/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.scholarship.report;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Qualification;
import org.fenixedu.academic.domain.QualificationType;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEventWithPaymentPlan;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.student.scholarship.report.IUTLScholarshipReportResult;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.joda.time.DateTime;

public class UTLScholarshipReportBeanFromRegistration
implements Serializable,
IUTLScholarshipReportResult {
    public Registration registration;

    public UTLScholarshipReportBeanFromRegistration(Registration registration) {
        this.registration = registration;
    }

    public static UTLScholarshipReportBeanFromRegistration create(Registration registration) {
        return new UTLScholarshipReportBeanFromRegistration(registration);
    }

    @Override
    public String getInstitutionCode() {
        return "807";
    }

    @Override
    public String getInstitutionName() {
        return MessageFormat.format(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.utl.scholarship.report.institution.name", (String[])new String[0]), Unit.getInstitutionName().getContent());
    }

    @Override
    public String getApplicationNumber() {
        return "";
    }

    @Override
    public Integer getStudentNumber() {
        return this.registration.getNumber();
    }

    @Override
    public String getStudentName() {
        return this.registration.getPerson().getName();
    }

    @Override
    public String getIdDocumentType() {
        return this.registration.getPerson().getIdDocumentType().getLocalizedName();
    }

    @Override
    public String getIdDocumentNumber() {
        return this.registration.getPerson().getDocumentIdNumber();
    }

    @Override
    public String getDegreeCode() {
        String ministryCode = this.registration.getDegree().getMinistryCode();
        return ministryCode != null ? ministryCode : "";
    }

    @Override
    public String getDegreeName() {
        return this.registration.getDegree().getName();
    }

    @Override
    public String getDegreeTypeName() {
        if (this.registration.getDegree().getDegreeType().isBolonhaDegree()) {
            return "Licenciatura 1\u00ba Ciclo";
        }
        if (this.registration.getDegree().getDegreeType().isIntegratedMasterDegree()) {
            return "Mestrado Integrado";
        }
        return this.registration.getDegree().getDegreeType().getName().getContent();
    }

    @Override
    public Integer getNumberOfDegreeChanges() {
        int numberOfDegreeChanges = 0;
        ArrayList<Registration> registrations = new ArrayList<Registration>(this.readStudent().getRegistrationsSet());
        Collections.sort(registrations, Registration.COMPARATOR_BY_START_DATE);
        for (Registration iter : registrations) {
            TreeSet<RegistrationState> states = new TreeSet<RegistrationState>(RegistrationState.DATE_COMPARATOR);
            states.addAll(iter.getRegistrationStates(RegistrationStateType.INTERNAL_ABANDON));
            if (states.isEmpty()) continue;
            ++numberOfDegreeChanges;
        }
        return numberOfDegreeChanges;
    }

    @Override
    public String getHasMadeDegreeChangeInThisExecutionYear() {
        boolean hasMade = this.registration.getStartExecutionYear() == this.readCurrentExecutionYear() && this.registration.getIngressionType().isInternalDegreeChange();
        return hasMade ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.yes", (String[])new String[0]) : BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.no", (String[])new String[0]);
    }

    @Override
    public String getCurrentExecutionYearBeginDate() {
        if (this.registration.isInMobilityState()) {
            return this.readCurrentExecutionYear().getBeginDateYearMonthDay().toLocalDate().toString("dd-MM-yyyy");
        }
        StudentCurricularPlan lastStudentCurricularPlan = this.registration.getLastStudentCurricularPlan();
        TreeSet<CurriculumModule> orderedEnrolmentSet = new TreeSet<CurriculumModule>(Collections.reverseOrder(CurriculumModule.COMPARATOR_BY_CREATION_DATE));
        orderedEnrolmentSet.addAll(lastStudentCurricularPlan.getEnrolmentsByExecutionYear(this.readCurrentExecutionYear()));
        return orderedEnrolmentSet.isEmpty() ? "" : ((Enrolment)((Object)orderedEnrolmentSet.iterator().next())).getCreationDateDateTime().toLocalDate().toString("dd-MM-yyyy");
    }

    @Override
    public String getRegimen() {
        RegistrationRegimeType type = this.registration.getRegimeType(this.readCurrentExecutionYear());
        if (RegistrationRegimeType.FULL_TIME.equals((Object)type)) {
            return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.utl.scholarship.report.regimen.full", (String[])new String[0]);
        }
        if (RegistrationRegimeType.PARTIAL_TIME.equals((Object)type)) {
            return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.utl.scholarship.report.regimen.partial", (String[])new String[0]);
        }
        return "";
    }

    @Override
    public String getCode() {
        return "";
    }

    @Override
    public String getFirstExecutionYearInIST() {
        return this.registration.getStudent().getFirstRegistrationExecutionYear().getName();
    }

    @Override
    public Integer getNumberOfStudyExecutionYearsInCurrentRegistration() {
        return this.registration.getEnrolmentsExecutionYears().size();
    }

    @Override
    public Integer getNumberOfCurricularYearsOnCurrentDegreeCurricularPlan() {
        return this.registration.getLastStudentCurricularPlan().getDegreeCurricularPlan().getDurationInYears();
    }

    @Override
    public Integer getLastYearCurricularYear() {
        ExecutionYear oneYearAgo = this.readCurrentExecutionYear().getPreviousExecutionYear();
        Registration lastRegistration = this.readStudent().getLastActiveRegistration();
        if (lastRegistration.getDegreeType().isBolonhaDegree()) {
            return lastRegistration.getCurriculum(new DateTime(), oneYearAgo, CycleType.FIRST_CYCLE).getCurricularYear();
        }
        if (lastRegistration.getDegreeType().isIntegratedMasterDegree()) {
            if (lastRegistration.hasConcludedFirstCycle()) {
                return lastRegistration.getCurricularYear(oneYearAgo);
            }
            return lastRegistration.getCurriculum(new DateTime(), oneYearAgo, CycleType.FIRST_CYCLE).getCurricularYear();
        }
        if (lastRegistration.getDegreeType().isBolonhaMasterDegree()) {
            return lastRegistration.getCurricularYear(oneYearAgo);
        }
        return lastRegistration.getCurricularYear(oneYearAgo);
    }

    @Override
    public BigDecimal getLastYearEnrolledECTS() {
        ExecutionYear oneYearAgo = this.readCurrentExecutionYear().getPreviousExecutionYear();
        BigDecimal result = BigDecimal.ZERO;
        for (Registration registration : this.readStudent().getRegistrationsSet()) {
            if (!registration.isBolonha() || !registration.hasAnyCurriculumLines(oneYearAgo)) continue;
            result = result.add(this.getEnrolmentsEctsCredits(registration, oneYearAgo));
        }
        return result;
    }

    @Override
    public BigDecimal getLastYearApprovedECTS() {
        ExecutionYear oneYearAgo = this.readCurrentExecutionYear().getPreviousExecutionYear();
        BigDecimal result = BigDecimal.ZERO;
        for (Registration registration : this.readStudent().getRegistrationsSet()) {
            if (!registration.isBolonha() || !registration.hasAnyCurriculumLines(oneYearAgo)) continue;
            result = result.add(UTLScholarshipReportBeanFromRegistration.calculateApprovedECTS(registration.getLastStudentCurricularPlan().getApprovedCurriculumLines(oneYearAgo.getFirstExecutionPeriod()))).add(UTLScholarshipReportBeanFromRegistration.calculateApprovedECTS(registration.getLastStudentCurricularPlan().getApprovedCurriculumLines(oneYearAgo.getLastExecutionPeriod())));
        }
        return result;
    }

    @Override
    public String getWasApprovedOnMostECTS() {
        BigDecimal lastYearEnrolledECTS = this.getLastYearEnrolledECTS().setScale(10, RoundingMode.HALF_EVEN);
        BigDecimal lastYearApprovedECTS = this.getLastYearApprovedECTS().setScale(10, RoundingMode.HALF_EVEN);
        if (lastYearEnrolledECTS.compareTo(new BigDecimal(0)) == 0) {
            return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.no", (String[])new String[0]);
        }
        BigDecimal ratio = lastYearApprovedECTS.divide(lastYearEnrolledECTS, RoundingMode.HALF_EVEN);
        return ratio.compareTo(new BigDecimal(0.5)) == 1 ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.yes", (String[])new String[0]) : BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.no", (String[])new String[0]);
    }

    @Override
    public Integer getCurrentYearCurricularYear() {
        ExecutionYear currentYear = this.readCurrentExecutionYear();
        Registration lastRegistration = this.readStudent().getLastActiveRegistration();
        if (lastRegistration.getDegreeType().isBolonhaDegree()) {
            return lastRegistration.getCurriculum(new DateTime(), currentYear, CycleType.FIRST_CYCLE).getCurricularYear();
        }
        if (lastRegistration.getDegreeType().isIntegratedMasterDegree()) {
            if (lastRegistration.hasConcludedFirstCycle()) {
                return lastRegistration.getCurricularYear(currentYear);
            }
            return lastRegistration.getCurriculum(new DateTime(), currentYear, CycleType.FIRST_CYCLE).getCurricularYear();
        }
        if (lastRegistration.getDegreeType().isBolonhaMasterDegree()) {
            return lastRegistration.getCurricularYear(currentYear);
        }
        return lastRegistration.getCurricularYear(currentYear);
    }

    @Override
    public BigDecimal getCurrentYearEnrolledECTS() {
        StudentCurricularPlan lastStudentCurricularPlan = this.registration.getLastStudentCurricularPlan();
        return new BigDecimal(lastStudentCurricularPlan.getEnrolmentsEctsCredits(this.readCurrentExecutionYear()));
    }

    @Override
    public String getDegreeConcluded() {
        return "";
    }

    @Override
    public String getFinalResult() {
        return "";
    }

    @Override
    public Money getGratuityAmount() {
        if (!this.registration.hasToPayGratuityOrInsurance()) {
            return Money.ZERO;
        }
        StudentCurricularPlan lastStudentCurricularPlan = this.registration.getLastStudentCurricularPlan();
        GratuityEventWithPaymentPlan event = (GratuityEventWithPaymentPlan)((Object)lastStudentCurricularPlan.getGratuityEvent(this.readCurrentExecutionYear(), GratuityEventWithPaymentPlan.class));
        return event != null ? event.getOriginalAmountToPay() : Money.ZERO;
    }

    @Override
    public Integer getNumberOfMonthsInExecutionYear() {
        return 10;
    }

    @Override
    public String getFirstMonthToPay() {
        return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.utl.scholarship.report.first.month.to.pay", (String[])new String[0]);
    }

    @Override
    public String getIsCETQualificationOwner() {
        return STUDENTS_WITH_CET.contains(this.registration.getNumber()) ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.yes", (String[])new String[0]) : BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.no", (String[])new String[0]);
    }

    @Override
    public String getIsDegreeQualificationOwner() {
        for (Qualification qualification : this.readStudent().getPerson().getAssociatedQualificationsSet()) {
            if (!UTLScholarshipReportBeanFromRegistration.isDegreeQualificationType(qualification.getType())) continue;
            return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.yes", (String[])new String[0]);
        }
        return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.no", (String[])new String[0]);
    }

    @Override
    public String getIsMasterDegreeQualificationOwner() {
        for (Qualification qualification : this.registration.getPerson().getAssociatedQualificationsSet()) {
            if (!UTLScholarshipReportBeanFromRegistration.isMasterQualificationType(qualification.getType())) continue;
            return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.yes", (String[])new String[0]);
        }
        return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.no", (String[])new String[0]);
    }

    @Override
    public String getIsPhdQualificationOwner() {
        for (Qualification qualification : this.registration.getPerson().getAssociatedQualificationsSet()) {
            if (!UTLScholarshipReportBeanFromRegistration.isPhdQualificationType(qualification.getType())) continue;
            BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.yes", (String[])new String[0]);
        }
        return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.no", (String[])new String[0]);
    }

    @Override
    public String getIsOwnerOfQualification() {
        for (Qualification qualification : this.registration.getPerson().getAssociatedQualificationsSet()) {
            if (UTLScholarshipReportBeanFromRegistration.isDegreeQualificationType(qualification.getType())) {
                return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.yes", (String[])new String[0]);
            }
            if (UTLScholarshipReportBeanFromRegistration.isMasterQualificationType(qualification.getType())) {
                return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.yes", (String[])new String[0]);
            }
            if (!UTLScholarshipReportBeanFromRegistration.isPhdQualificationType(qualification.getType())) continue;
            BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.yes", (String[])new String[0]);
        }
        return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.no", (String[])new String[0]);
    }

    @Override
    public Integer getNumberOfEnrolmentsYearsSinceRegistrationStart() {
        return this.registration.getEnrolmentsExecutionYears().size();
    }

    @Override
    public String getObservations() {
        return "";
    }

    private ExecutionYear readCurrentExecutionYear() {
        return ExecutionYear.readCurrentExecutionYear();
    }

    private Student readStudent() {
        return this.registration.getStudent();
    }

    private static boolean isDegreeQualificationType(QualificationType type) {
        return DEGREE_QUALIFICATION_TYPES.contains((Object)type);
    }

    private static boolean isMasterQualificationType(QualificationType type) {
        return MASTER_QUALIFICATION_TYPES.contains((Object)type);
    }

    private static boolean isPhdQualificationType(QualificationType type) {
        return PHD_QUALIFICATION_TYPES.contains((Object)type);
    }

    private BigDecimal getEnrolmentsEctsCredits(Registration registration, ExecutionYear executionYear) {
        BigDecimal result = new BigDecimal(0.0);
        BigDecimal annualCredits = new BigDecimal(0.0);
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            for (CurriculumLine enrolment : registration.getLastStudentCurricularPlan().getAllCurriculumLines()) {
                Dismissal dismissal;
                if (enrolment.isDismissal() && !(dismissal = (Dismissal)((Object)enrolment)).getCredits().isAllEnrolmentsAreExternal() || !enrolment.isValid(executionSemester)) continue;
                if (enrolment.isEnrolment() && ((Enrolment)((Object)enrolment)).isAnual()) {
                    if (executionSemester.getSemester() != 1) continue;
                    annualCredits = annualCredits.add(new BigDecimal(enrolment.getEctsCredits()));
                    continue;
                }
                result = result.add(new BigDecimal(enrolment.getEctsCredits()));
            }
        }
        return result.add(annualCredits);
    }

    private static BigDecimal calculateApprovedECTS(Collection<CurriculumLine> list) {
        BigDecimal result = BigDecimal.ZERO;
        for (CurriculumLine curriculumLine : list) {
            Dismissal dismissal;
            if (curriculumLine.isDismissal() && !(dismissal = (Dismissal)((Object)curriculumLine)).getCredits().isAllEnrolmentsAreExternal()) continue;
            result = result.add(BigDecimal.valueOf(curriculumLine.getAprovedEctsCredits()));
        }
        return result;
    }

    public Spreadsheet buildSpreadsheet() {
        Spreadsheet spreadsheet = new Spreadsheet("resultado da bolsa de accao social");
        this.setHeaders(spreadsheet);
        Spreadsheet.Row row = spreadsheet.addRow();
        row.setCell(this.getInstitutionCode());
        row.setCell(this.getInstitutionName());
        row.setCell(this.getApplicationNumber());
        row.setCell(this.getStudentNumber());
        row.setCell(this.getStudentName());
        row.setCell(this.getIdDocumentType());
        row.setCell(this.getIdDocumentNumber());
        row.setCell(this.getDegreeCode());
        row.setCell(this.getDegreeName());
        row.setCell(this.getDegreeTypeName());
        row.setCell(this.getNumberOfDegreeChanges());
        row.setCell(this.getHasMadeDegreeChangeInThisExecutionYear());
        row.setCell(this.getCurrentExecutionYearBeginDate());
        row.setCell(this.getRegimen());
        row.setCell(this.getCode());
        row.setCell(this.getFirstExecutionYearInIST());
        row.setCell(this.getNumberOfStudyExecutionYearsInCurrentRegistration());
        row.setCell(this.getNumberOfCurricularYearsOnCurrentDegreeCurricularPlan());
        row.setCell(this.getLastYearCurricularYear());
        row.setCell(this.getLastYearEnrolledECTS());
        row.setCell(this.getLastYearApprovedECTS());
        row.setCell(this.getWasApprovedOnMostECTS());
        row.setCell(this.getCurrentYearCurricularYear());
        row.setCell(this.getCurrentYearEnrolledECTS());
        row.setCell(this.getDegreeConcluded());
        row.setCell(this.getFinalResult());
        row.setCell(this.getGratuityAmount().toString());
        row.setCell(this.getNumberOfMonthsInExecutionYear());
        row.setCell(this.getFirstMonthToPay());
        row.setCell(this.getIsCETQualificationOwner());
        row.setCell(this.getIsDegreeQualificationOwner());
        row.setCell(this.getIsMasterDegreeQualificationOwner());
        row.setCell(this.getIsPhdQualificationOwner());
        row.setCell(this.getIsOwnerOfQualification());
        row.setCell(this.getObservations());
        return spreadsheet;
    }

    protected void setHeaders(Spreadsheet spreadsheet) {
        spreadsheet.setHeader(0, BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.institutionCode", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.institutionName", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.applicationNumber", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.studentNumber", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.studentName", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.idDocumentType", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.idDocumentNumber", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.degreeCode", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.degreeName", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.degreeTypeName", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.numberOfDegreeChanges", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.hasMadeDegreeChangeInThisExecutionYear", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.currentExecutionYearBeginDate", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.regimen", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.code", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.firstExecutionYearInIST", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.numberOfStudyExecutionYearsInCurrentRegistration", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.numberOfCurricularYearsOnCurrentDegreeCurricularPlan", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.lastYearCurricularYear", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.lastYearEnrolledECTS", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.lastYearApprovedECTS", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.wasApprovedOnMostECTS", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.currentYearCurricularYear", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.currentYearEnrolledECTS", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.degreeConcluded", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.finalResult", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.gratuityAmount", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.numberOfMonthsInExecutionYear", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.firstMonthToPay", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.isCETQualificationOwner", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.isDegreeQualificationOwner", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.isMasterDegreeQualificationOwner", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.isPhdQualificationOwner", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.isOwnerOfQualification", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.student.scholarship.report.UTLScholarshipReportBeanFromRegistration.observations", (String[])new String[0]));
    }
}

