/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.CourseLoadRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;

public class CourseLoadRequest
extends CourseLoadRequest_Base {
    protected CourseLoadRequest() {
        this.setNumberOfPages(0);
    }

    public CourseLoadRequest(DocumentRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkParameters(bean);
        super.getEnrolmentsSet().addAll(bean.getEnrolments());
    }

    protected void checkParameters(DocumentRequestCreateBean bean) {
        if (bean.getEnrolments().isEmpty()) {
            throw new DomainException("error.CourseLoadRequest.invalid.number.of.enrolments", new String[0]);
        }
        for (Enrolment enrolment : bean.getEnrolments()) {
            if (!enrolment.isApproved()) {
                throw new DomainException("error.CourseLoadRequest.cannot.add.not.approved.enrolments", new String[0]);
            }
            if (this.getStudent().hasEnrolments(enrolment)) continue;
            throw new DomainException("error.ProgramCertificateRequest.enrolment.doesnot.belong.to.student", new String[0]);
        }
    }

    public Integer getNumberOfUnits() {
        return this.getEnrolmentsSet().size();
    }

    public DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.COURSE_LOAD;
    }

    public String getDocumentTemplateKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public EventType getEventType() {
        return EventType.COURSE_LOAD_REQUEST;
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        super.internalChangeState(academicServiceRequestBean);
        if (academicServiceRequestBean.isToCancelOrReject()) {
            while (!this.getEnrolmentsSet().isEmpty()) {
                this.removeEnrolments((Enrolment)this.getEnrolmentsSet().iterator().next());
            }
        }
    }

    protected void disconnect() {
        super.getEnrolmentsSet().clear();
        super.disconnect();
    }

    public boolean isFree() {
        return this.getRegistration().getRegistrationProtocol().isMilitaryAgreement() || super.isFree();
    }
}

