/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.activities;

import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.ThesisJuryElement;
import org.fenixedu.academic.domain.phd.thesis.activities.PhdThesisActivity;
import org.fenixedu.bennu.core.domain.User;

public class ScheduleThesisDiscussion
extends PhdThesisActivity {
    @Override
    protected void activityPreConditions(PhdThesisProcess process2, User userView) {
        if (!process2.getActiveState().equals(PhdThesisProcessStateType.WAITING_FOR_THESIS_DISCUSSION_DATE_SCHEDULING)) {
            throw new PreConditionNotValidException();
        }
        if (process2.isAllowedToManageProcess(userView)) {
            return;
        }
    }

    @Override
    protected PhdThesisProcess executeActivity(PhdThesisProcess process2, User userView, Object object) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)object;
        if (bean.isToNotify()) {
            this.notifyJuryElements(process2, bean);
            this.alertStudent(process2, bean);
        }
        this.checkDiscussionInformation(bean);
        process2.setDiscussionDate(bean.getScheduledDate());
        process2.setDiscussionPlace(bean.getScheduledPlace());
        process2.createState(PhdThesisProcessStateType.THESIS_DISCUSSION_DATE_SCHECULED, userView.getPerson(), bean.getRemarks());
        return process2;
    }

    private void checkDiscussionInformation(PhdThesisProcessBean bean) {
        if (bean.getScheduledDate() == null) {
            throw new DomainException("error.ScheduleThesisDiscussion.invalid.discussion.date", new String[0]);
        }
        if (bean.getScheduledPlace() == null || bean.getScheduledPlace().isEmpty()) {
            throw new DomainException("error.ScheduleThesisDiscussion.invalid.discussion.place", new String[0]);
        }
    }

    private void alertStudent(PhdThesisProcess process2, PhdThesisProcessBean bean) {
        AlertService.AlertMessage subject = AlertService.AlertMessage.create(bean.getMailSubject(), new Object[0]).isKey(false).withPrefix(false);
        AlertService.AlertMessage body = AlertService.AlertMessage.create(this.buildBody(process2.getIndividualProgramProcess(), null, bean), new Object[0]).isKey(false).withPrefix(false);
        AlertService.alertStudent(process2.getIndividualProgramProcess(), subject, body);
    }

    private void notifyJuryElements(PhdThesisProcess process2, PhdThesisProcessBean bean) {
        for (ThesisJuryElement juryElement : process2.getThesisJuryElementsSet()) {
            PhdParticipant participant = juryElement.getParticipant();
            this.sendAlertToJuryElement(process2.getIndividualProgramProcess(), participant, bean);
        }
    }

    private void sendAlertToJuryElement(PhdIndividualProgramProcess process2, PhdParticipant participant, PhdThesisProcessBean bean) {
        AlertService.AlertMessage subject = AlertService.AlertMessage.create(bean.getMailSubject(), new Object[0]).isKey(false).withPrefix(false);
        AlertService.AlertMessage body = AlertService.AlertMessage.create(this.buildBody(process2, participant, bean), new Object[0]).isKey(false).withPrefix(false);
        AlertService.alertParticipants(process2, subject, body, participant);
    }

    private String buildBody(PhdIndividualProgramProcess process2, PhdParticipant participant, PhdThesisProcessBean bean) {
        return bean.getMailBody() + "\n\n ---- " + this.getThesisDiscussionInformation(bean);
    }

    private String getThesisDiscussionInformation(PhdThesisProcessBean bean) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(AlertService.AlertMessage.get("label.phd.date", new Object[0])).append(": ");
        sb.append(bean.getScheduledDate().toString("dd/MM/yyyy")).append("\n");
        sb.append(AlertService.AlertMessage.get("label.phd.hour", new Object[0])).append(": ");
        sb.append(bean.getScheduledDate().toString("HH:mm")).append("\n");
        sb.append(AlertService.AlertMessage.get("label.phd.meeting.place", new Object[0])).append(": ");
        sb.append(bean.getScheduledPlace());
        return sb.toString();
    }
}

