/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.reports;

import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.phd.InternalPhdParticipant;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.SearchPhdIndividualProgramProcessBean;
import org.fenixedu.academic.domain.phd.reports.PhdReport;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;

public class PhdGuidersReport
extends PhdReport {
    private int rowCounter = 2;

    public PhdGuidersReport(HSSFWorkbook workbook) {
        super(workbook);
    }

    public HSSFSheet build(SearchPhdIndividualProgramProcessBean bean) {
        HSSFSheet sheet = this.workbook.createSheet("Orientadores");
        this.setHeaders(sheet);
        List<PhdIndividualProgramProcess> processes = PhdIndividualProgramProcess.search(bean.getExecutionYear(), bean.getPredicates());
        this.setHeaders(sheet);
        for (PhdIndividualProgramProcess process2 : processes) {
            if (!process2.isAllowedToManageProcess(Authenticate.getUser())) continue;
            this.fillProcess(process2, sheet);
        }
        return sheet;
    }

    private void fillProcess(PhdIndividualProgramProcess process2, HSSFSheet sheet) {
        HSSFRow row;
        String guiderRole = BundleUtil.getString((String)"resources.PhdResources", (String)"label.org.fenixedu.academic.domain.phd.reports.PhdGuidersReport.guider", (String[])new String[0]);
        String assistantGuiderRole = BundleUtil.getString((String)"resources.PhdResources", (String)"label.org.fenixedu.academic.domain.phd.reports.PhdGuidersReport.assistantGuider", (String[])new String[0]);
        for (PhdParticipant phdParticipant : process2.getGuidingsSet()) {
            row = sheet.createRow(this.rowCounter++);
            this.fillParticipant(guiderRole, process2, phdParticipant, row);
        }
        for (PhdParticipant phdParticipant : process2.getAssistantGuidingsSet()) {
            row = sheet.createRow(this.rowCounter++);
            this.fillParticipant(assistantGuiderRole, process2, phdParticipant, row);
        }
    }

    private void fillParticipant(String guiderRole, PhdIndividualProgramProcess process2, PhdParticipant phdParticipant, HSSFRow row) {
        String processNumber = process2.getProcessNumber();
        String studentNumber = process2.getStudent() != null ? process2.getStudent().getNumber().toString() : "";
        String studentName = process2.getPerson().getName();
        String participantName = phdParticipant.getName();
        String institution = phdParticipant.getWorkLocation();
        this.addCellValue(row, this.onNullEmptyString(processNumber), 0);
        this.addCellValue(row, this.onNullEmptyString(studentNumber), 1);
        this.addCellValue(row, this.onNullEmptyString(studentName), 2);
        this.addCellValue(row, this.onNullEmptyString(participantName), 3);
        this.addCellValue(row, this.onNullEmptyString(guiderRole), 4);
        this.addCellValue(row, this.onNullEmptyString(institution), 5);
        if (!phdParticipant.isTeacher()) {
            this.addCellValue(row, this.onNullEmptyString(null), 6);
            this.addCellValue(row, this.onNullEmptyString(null), 7);
            this.addCellValue(row, this.onNullEmptyString(null), 8);
        } else {
            InternalPhdParticipant internalPhdParticipant = (InternalPhdParticipant)((Object)phdParticipant);
            Teacher teacher = internalPhdParticipant.getTeacher();
            this.addCellValue(row, this.onNullEmptyString(teacher.getTeacherId()), 6);
            Department department = internalPhdParticipant.getDepartment();
            this.addCellValue(row, this.onNullEmptyString(department != null ? department.getCode() : ""), 7);
            this.addCellValue(row, this.onNullEmptyString(department != null ? department.getName() : ""), 8);
        }
    }

    @Override
    protected void setHeaders(HSSFSheet sheet) {
        this.addHeaderCell(sheet, this.getHeaderInBundle("processNumber"), 0);
        this.addHeaderCell(sheet, this.getHeaderInBundle("studentNumber"), 1);
        this.addHeaderCell(sheet, this.getHeaderInBundle("studentName"), 2);
        this.addHeaderCell(sheet, this.getHeaderInBundle("guiderName"), 3);
        this.addHeaderCell(sheet, this.getHeaderInBundle("guiderRole"), 4);
        this.addHeaderCell(sheet, this.getHeaderInBundle("guiderInstitution"), 5);
        this.addHeaderCell(sheet, this.getHeaderInBundle("guiderId"), 6);
        this.addHeaderCell(sheet, this.getHeaderInBundle("guiderDepartmentCode"), 7);
        this.addHeaderCell(sheet, this.getHeaderInBundle("guiderDepartmentName"), 8);
    }

    private String getHeaderInBundle(String field) {
        return BundleUtil.getString((String)"resources.PhdResources", (String)("label.org.fenixedu.academic.domain.phd.reports.PhdGuidersReport." + field), (String[])new String[0]);
    }
}

