/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.migration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationIndividualProcessData;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationProcessStateType;
import org.fenixedu.academic.util.predicates.AndPredicate;
import org.fenixedu.academic.util.predicates.InlinePredicate;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public class SearchPhdMigrationProcessBean
implements Serializable {
    private static final long serialVersionUID = -5653277152319382139L;
    private SearchCriterion searchCriterion = SearchCriterion.PHD_STUDENT_NUMBER;
    private String searchValue;
    private ExecutionYear executionYear;
    private PhdMigrationProcessStateType processState;
    private Integer phdStudentNumber;
    private List<PhdProgram> phdPrograms;
    private Boolean filterPhdPrograms = Boolean.TRUE;
    private List<PhdMigrationIndividualProcessData> processes;
    private Boolean filterPhdProcesses = Boolean.TRUE;
    private FilterMigratedProcesses filterNotMigratedProcesses = FilterMigratedProcesses.NO_FILTER;

    public String getSearchValue() {
        return this.searchValue;
    }

    public void setSearchValue(String searchValue) {
        this.searchValue = searchValue;
    }

    public void setSearchCriterion(SearchCriterion searchCriterion) {
        this.searchCriterion = searchCriterion;
    }

    public SearchCriterion getSearchCriterion() {
        return this.searchCriterion;
    }

    public Boolean getFilterPhdPrograms() {
        return this.filterPhdPrograms;
    }

    public void setFilterPhdPrograms(Boolean filterPhdPrograms) {
        this.filterPhdPrograms = filterPhdPrograms;
    }

    public Boolean getFilterPhdProcesses() {
        return this.filterPhdProcesses;
    }

    public void setFilterPhdProcesses(Boolean filterPhdProcesses) {
        this.filterPhdProcesses = filterPhdProcesses;
    }

    public List<PhdProgram> getPhdPrograms() {
        ArrayList<PhdProgram> result = new ArrayList<PhdProgram>();
        for (PhdProgram each : this.phdPrograms) {
            result.add(each);
        }
        return result;
    }

    public void setPhdPrograms(List<PhdProgram> phdPrograms) {
        this.setPhdPrograms((Collection<PhdProgram>)phdPrograms);
    }

    public void setPhdPrograms(Collection<PhdProgram> phdPrograms) {
        ArrayList<PhdProgram> result = new ArrayList<PhdProgram>();
        for (PhdProgram each : phdPrograms) {
            result.add(each);
        }
        this.phdPrograms = result;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    public PhdMigrationProcessStateType getProcessState() {
        return this.processState;
    }

    public void setProcessState(PhdMigrationProcessStateType processState) {
        this.processState = processState;
    }

    public List<PhdMigrationIndividualProcessData> getProcesses() {
        ArrayList<PhdMigrationIndividualProcessData> result = new ArrayList<PhdMigrationIndividualProcessData>();
        for (PhdMigrationIndividualProcessData each : this.processes) {
            result.add(each);
        }
        return result;
    }

    public void setProcesses(List<PhdMigrationIndividualProcessData> processes) {
        ArrayList<PhdMigrationIndividualProcessData> result = new ArrayList<PhdMigrationIndividualProcessData>();
        for (PhdMigrationIndividualProcessData each : processes) {
            result.add(each);
        }
        this.processes = result;
    }

    public AndPredicate<PhdMigrationIndividualProcessData> getPredicates() {
        if (this.getSearchValue() != null && !this.getSearchValue().isEmpty()) {
            String searchValue = this.getSearchValue().trim();
            this.setPhdStudentNumber(this.getSearchCriterion() == SearchCriterion.PHD_STUDENT_NUMBER ? Integer.valueOf(searchValue) : null);
        }
        AndPredicate<PhdMigrationIndividualProcessData> result = new AndPredicate<PhdMigrationIndividualProcessData>();
        result.add(this.getManagedPhdProgramsAndProcessesPredicate());
        if (this.getPhdStudentNumber() != null) {
            result.add(new InlinePredicate<PhdMigrationIndividualProcessData, Integer>(this.getPhdStudentNumber()){

                @Override
                public boolean test(PhdMigrationIndividualProcessData toEval) {
                    return toEval.getNumber() != null && toEval.getNumber().compareTo((Integer)this.getValue()) == 0;
                }
            });
            return result;
        }
        return this.getAndPredicate();
    }

    public AndPredicate<PhdMigrationIndividualProcessData> getAndPredicate() {
        AndPredicate<PhdMigrationIndividualProcessData> result = new AndPredicate<PhdMigrationIndividualProcessData>();
        result.add(this.getManagedPhdProgramsAndProcessesPredicate());
        if (this.getExecutionYear() != null) {
            result.add(new InlinePredicate<PhdMigrationIndividualProcessData, ExecutionYear>(this.getExecutionYear()){

                @Override
                public boolean test(PhdMigrationIndividualProcessData toEval) {
                    return toEval.getExecutionYear() == this.getValue();
                }
            });
        }
        if (this.getProcessState() != null) {
            result.add(new InlinePredicate<PhdMigrationIndividualProcessData, PhdMigrationProcessStateType>(this.getProcessState()){

                @Override
                public boolean test(PhdMigrationIndividualProcessData toEval) {
                    return toEval.getMigrationStatus() == this.getValue();
                }
            });
        }
        return result;
    }

    private AndPredicate<PhdMigrationIndividualProcessData> getManagedPhdProgramsAndProcessesPredicate() {
        AndPredicate<PhdMigrationIndividualProcessData> result = new AndPredicate<PhdMigrationIndividualProcessData>();
        if (this.getFilterPhdPrograms() != null && this.getFilterPhdPrograms().booleanValue()) {
            result.add(new InlinePredicate<PhdMigrationIndividualProcessData, List<PhdProgram>>(this.getPhdPrograms()){

                @Override
                public boolean test(PhdMigrationIndividualProcessData toEval) {
                    if (toEval.getProcessBean().hasPhdProgram()) {
                        return ((List)this.getValue()).contains((Object)toEval.getProcessBean().getPhdProgram());
                    }
                    return false;
                }
            });
        }
        if (this.getFilterNotMigratedProcesses() != null && !this.getFilterNotMigratedProcesses().equals((Object)FilterMigratedProcesses.NO_FILTER)) {
            result.add(new InlinePredicate<PhdMigrationIndividualProcessData, FilterMigratedProcesses>(this.getFilterNotMigratedProcesses()){

                @Override
                public boolean test(PhdMigrationIndividualProcessData toEval) {
                    if (((FilterMigratedProcesses)((Object)this.getValue())).equals((Object)FilterMigratedProcesses.FILTER_MIGRATED)) {
                        return toEval.isMigratedToIndividualProgramProcess();
                    }
                    return !toEval.isMigratedToIndividualProgramProcess();
                }
            });
        }
        if (this.getFilterPhdProcesses() != null && this.getFilterPhdProcesses().booleanValue()) {
            result.add(new InlinePredicate<PhdMigrationIndividualProcessData, List<PhdMigrationIndividualProcessData>>(this.getProcesses()){

                @Override
                public boolean test(PhdMigrationIndividualProcessData toEval) {
                    return ((List)this.getValue()).contains((Object)toEval);
                }
            });
        }
        return result;
    }

    public Integer getPhdStudentNumber() {
        return this.phdStudentNumber;
    }

    public void setPhdStudentNumber(Integer phdStudentNumber) {
        this.phdStudentNumber = phdStudentNumber;
    }

    public FilterMigratedProcesses getFilterNotMigratedProcesses() {
        return this.filterNotMigratedProcesses;
    }

    public void setFilterNotMigratedProcesses(FilterMigratedProcesses filterNotMigratedProcesses) {
        this.filterNotMigratedProcesses = filterNotMigratedProcesses;
    }

    public static enum FilterMigratedProcesses {
        FILTER_MIGRATED,
        FILTER_NOT_MIGRATED,
        NO_FILTER;


        public String getLocalizedName() {
            return this.getLocalizedName(I18N.getLocale());
        }

        public String getLocalizedName(Locale locale) {
            return BundleUtil.getString((String)"resources.PhdResources", (Locale)locale, (String)this.getQualifiedName(), (String[])new String[0]);
        }

        public String getQualifiedName() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "." + this.name();
        }
    }

    public static enum SearchCriterion {
        PHD_STUDENT_NUMBER;

    }
}

