/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.curriculum.AverageType;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.dto.candidacy.PrecedentDegreeInformationBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.LocalDate;

public class PrecedentDegreeInformationBeanFactory {
    public static final PrecedentDegreeInformationBean createBean(IndividualCandidacy individualCandidacy) {
        if (individualCandidacy.isOver23()) {
            return null;
        }
        if (individualCandidacy.isErasmus()) {
            return null;
        }
        if (individualCandidacy.isSecondCycle() || individualCandidacy.isDegreeCandidacyForGraduatedPerson()) {
            return PrecedentDegreeInformationBeanFactory.precedentDegreeInformationBeanForSecondCycleOrForGraduatedPerson(individualCandidacy);
        }
        if (individualCandidacy.isDegreeTransfer() || individualCandidacy.isDegreeChange()) {
            return PrecedentDegreeInformationBeanFactory.precedentDegreeInformationBeanForTransferOrChange(individualCandidacy);
        }
        return null;
    }

    private static final PrecedentDegreeInformationBean precedentDegreeInformationBeanForSecondCycleOrForGraduatedPerson(IndividualCandidacy individualCandidacy) {
        PrecedentDegreeInformationBean bean = new PrecedentDegreeInformationBean();
        PrecedentDegreeInformation pid = individualCandidacy.getRefactoredPrecedentDegreeInformation();
        bean.setPrecedentDegreeInformation(pid);
        bean.setDegreeDesignation(pid.getDegreeDesignation());
        bean.setInstitution(pid.getInstitution());
        bean.setInstitutionName(pid.getInstitutionName());
        bean.setCountry(pid.getCountry());
        bean.setConclusionDate(pid.getConclusionDate());
        bean.setConclusionGrade(pid.getConclusionGrade());
        return bean;
    }

    private static final PrecedentDegreeInformationBean precedentDegreeInformationBeanForTransferOrChange(IndividualCandidacy individualCandidacy) {
        PrecedentDegreeInformationBean bean = new PrecedentDegreeInformationBean();
        PrecedentDegreeInformation pid = individualCandidacy.getRefactoredPrecedentDegreeInformation();
        bean.setPrecedentDegreeInformation(pid);
        bean.setDegreeDesignation(pid.getPrecedentDegreeDesignation());
        bean.setInstitution(pid.getPrecedentInstitution());
        bean.setInstitutionName(pid.getPrecedentInstitution().getName());
        bean.setNumberOfEnroledCurricularCourses(pid.getNumberOfEnroledCurricularCourses());
        bean.setNumberOfApprovedCurricularCourses(pid.getNumberOfApprovedCurricularCourses());
        bean.setGradeSum(pid.getGradeSum());
        bean.setApprovedEcts(pid.getApprovedEcts());
        bean.setEnroledEcts(pid.getEnroledEcts());
        return bean;
    }

    public static final PrecedentDegreeInformationBean createBean(StudentCurricularPlan studentCurricularPlan, CycleType cycleType) {
        Grade finalGrade;
        PrecedentDegreeInformationBean bean = new PrecedentDegreeInformationBean();
        if (!studentCurricularPlan.isBolonhaDegree() || cycleType == null) {
            throw new IllegalArgumentException();
        }
        bean.setDegreeDesignation(studentCurricularPlan.getName());
        bean.setInstitutionUnitName(Bennu.getInstance().getInstitutionUnit().getUnitName());
        if (studentCurricularPlan.getConclusionDate(cycleType) != null) {
            bean.setConclusionDate(new LocalDate((Object)studentCurricularPlan.getConclusionDate(cycleType)));
        }
        if ((finalGrade = studentCurricularPlan.getCycle(cycleType).getFinalGrade()) != null) {
            bean.setConclusionGrade(finalGrade.getValue());
        }
        bean.setNumberOfEnroledCurricularCourses(PrecedentDegreeInformationBeanFactory.calculateNumberOfEnroledCurricularCourses(studentCurricularPlan));
        bean.setNumberOfApprovedCurricularCourses(PrecedentDegreeInformationBeanFactory.calculateNumberOfApprovedCurricularCourses(studentCurricularPlan));
        bean.setGradeSum(PrecedentDegreeInformationBeanFactory.calculateGradeSum(studentCurricularPlan));
        bean.setApprovedEcts(PrecedentDegreeInformationBeanFactory.calculateApprovedEcts(studentCurricularPlan));
        bean.setEnroledEcts(PrecedentDegreeInformationBeanFactory.calculateEnroledEcts(studentCurricularPlan));
        return bean;
    }

    public static final PrecedentDegreeInformationBean createBean(StudentCurricularPlan studentCurricularPlan) {
        PrecedentDegreeInformationBean bean = new PrecedentDegreeInformationBean();
        if (studentCurricularPlan.isBolonhaDegree() || !studentCurricularPlan.getRegistration().isRegistrationConclusionProcessed()) {
            throw new IllegalArgumentException("error.studentCurricularPlan.must.be.pre.bolonha.and.concluded");
        }
        bean.setDegreeDesignation(studentCurricularPlan.getName());
        bean.setConclusionDate(new LocalDate((Object)studentCurricularPlan.getRegistration().getConclusionDate()));
        bean.setConclusionGrade(studentCurricularPlan.getRegistration().getFinalGrade().getValue());
        bean.setInstitution(Bennu.getInstance().getInstitutionUnit());
        bean.setInstitutionName(Bennu.getInstance().getInstitutionUnit().getName());
        bean.setInstitutionUnitName(Bennu.getInstance().getInstitutionUnit().getUnitName());
        bean.setNumberOfEnroledCurricularCourses(PrecedentDegreeInformationBeanFactory.calculateNumberOfEnroledCurricularCourses(studentCurricularPlan));
        bean.setNumberOfApprovedCurricularCourses(PrecedentDegreeInformationBeanFactory.calculateNumberOfApprovedCurricularCourses(studentCurricularPlan));
        bean.setGradeSum(PrecedentDegreeInformationBeanFactory.calculateGradeSum(studentCurricularPlan));
        bean.setApprovedEcts(PrecedentDegreeInformationBeanFactory.calculateApprovedEcts(studentCurricularPlan));
        bean.setEnroledEcts(PrecedentDegreeInformationBeanFactory.calculateEnroledEcts(studentCurricularPlan));
        return bean;
    }

    private static final Integer calculateNumberOfEnroledCurricularCourses(StudentCurricularPlan studentCurricularPlan) {
        return studentCurricularPlan.getRoot().getNumberOfAllEnroledCurriculumLines();
    }

    private static final Integer calculateNumberOfApprovedCurricularCourses(StudentCurricularPlan studentCurricularPlan) {
        return studentCurricularPlan.getRoot().getNumberOfAllApprovedCurriculumLines();
    }

    private static final BigDecimal calculateGradeSum(StudentCurricularPlan studentCurricularPlan) {
        Curriculum curriculum = studentCurricularPlan.getRoot().getCurriculum();
        curriculum.setAverageType(AverageType.SIMPLE);
        return curriculum.getWeigthedGradeSum();
    }

    private static final BigDecimal calculateApprovedEcts(StudentCurricularPlan studentCurricularPlan) {
        return BigDecimal.valueOf(studentCurricularPlan.getRoot().getAprovedEctsCredits());
    }

    private static final BigDecimal calculateEnroledEcts(StudentCurricularPlan studentCurricularPlan) {
        return BigDecimal.valueOf(studentCurricularPlan.getRoot().getEctsCredits());
    }
}

