/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessState;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess_Base;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public abstract class CandidacyProcess
extends CandidacyProcess_Base {
    protected CandidacyProcess() {
    }

    public ExecutionInterval getCandidacyExecutionInterval() {
        return this.getCandidacyPeriod() != null ? this.getCandidacyPeriod().getExecutionInterval() : null;
    }

    public DateTime getCandidacyStart() {
        return this.getCandidacyPeriod() != null ? this.getCandidacyPeriod().getStart() : null;
    }

    public DateTime getCandidacyEnd() {
        return this.getCandidacyPeriod() != null ? this.getCandidacyPeriod().getEnd() : null;
    }

    public boolean hasStarted() {
        return !this.getCandidacyStart().isAfterNow();
    }

    public boolean hasOpenCandidacyPeriod() {
        return this.getCandidacyPeriod() != null && this.getCandidacyPeriod().isOpen();
    }

    public boolean hasOpenCandidacyPeriod(DateTime date) {
        return this.getCandidacyPeriod() != null && this.getCandidacyPeriod().isOpen(date);
    }

    public boolean hasState() {
        return this.getState() != null;
    }

    public boolean isInStandBy() {
        return this.getState() == CandidacyProcessState.STAND_BY;
    }

    public boolean isSentToJury() {
        return this.getState() == CandidacyProcessState.SENT_TO_JURY;
    }

    public boolean isSentToCoordinator() {
        return this.getState() == CandidacyProcessState.SENT_TO_COORDINATOR;
    }

    public boolean isSentToScientificCouncil() {
        return this.getState() == CandidacyProcessState.SENT_TO_SCIENTIFIC_COUNCIL;
    }

    public boolean isPublished() {
        return this.getState() == CandidacyProcessState.PUBLISHED;
    }

    public String getDisplayName() {
        return BundleUtil.getString((String)"resources.CaseHandlingResources", (String)((Object)((Object)this)).getClass().getSimpleName(), (String[])new String[0]);
    }

    public static <T extends CandidacyProcess> T getCandidacyProcessByDate(Class<T> clazz, DateTime date) {
        for (CandidacyProcess process2 : CandidacyProcess.getAllInstancesOf(clazz)) {
            if (process2.getCandidacyPeriod() == null || !process2.getCandidacyPeriod().isOpen(date)) continue;
            return (T)((Object)process2);
        }
        return null;
    }

    public static <T extends CandidacyProcess> T getCandidacyProcessByExecutionInterval(Class<T> clazz, ExecutionInterval executionInterval) {
        for (CandidacyProcess process2 : CandidacyProcess.getAllInstancesOf(clazz)) {
            if (process2.getCandidacyPeriod() == null || !executionInterval.equals((Object)process2.getCandidacyPeriod().getExecutionInterval())) continue;
            return (T)((Object)process2);
        }
        return null;
    }

    public IndividualCandidacyProcess getChildProcessByDocumentId(IDDocumentType type, String identification) {
        for (IndividualCandidacyProcess individualCandidacyProcess : this.getChildProcessesSet()) {
            if (individualCandidacyProcess.getCandidacy() == null || !identification.equals(individualCandidacyProcess.getCandidacy().getPersonalDetails().getDocumentIdNumber()) || !type.equals((Object)individualCandidacyProcess.getCandidacy().getPersonalDetails().getIdDocumentType())) continue;
            return individualCandidacyProcess;
        }
        return null;
    }

    public IndividualCandidacyProcess getOpenChildProcessByDocumentId(IDDocumentType documentType, String documentId) {
        for (IndividualCandidacyProcess child : this.getChildProcessesSet()) {
            if (!documentId.equals(child.getCandidacy().getPersonalDetails().getDocumentIdNumber()) || child.isCandidacyCancelled()) continue;
            return child;
        }
        return null;
    }

    public IndividualCandidacyProcess getOpenChildProcessByEidentifier(String eidentifier) {
        if (StringUtils.isEmpty((String)eidentifier)) {
            return null;
        }
        for (IndividualCandidacyProcess child : this.getChildProcessesSet()) {
            if (child.isCandidacyCancelled() || StringUtils.isEmpty((String)child.getPersonalDetails().getEidentifier()) || !eidentifier.equalsIgnoreCase(child.getPersonalDetails().getEidentifier())) continue;
            return child;
        }
        return null;
    }

    public List<IndividualCandidacyProcess> getChildsWithMissingRequiredDocuments() {
        ArrayList<IndividualCandidacyProcess> childs = new ArrayList<IndividualCandidacyProcess>();
        CollectionUtils.select((Collection)this.getChildProcessesSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                IndividualCandidacyProcess process2 = (IndividualCandidacyProcess)((Object)arg0);
                return !process2.isCandidacyCancelled() && process2.isProcessMissingRequiredDocumentFiles();
            }
        }, childs);
        return childs;
    }

    public List<IndividualCandidacyProcess> getChildsWithMissingShifts() {
        ArrayList<IndividualCandidacyProcess> childs = new ArrayList<IndividualCandidacyProcess>();
        CollectionUtils.select((Collection)this.getChildProcessesSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                boolean hasNotMissingShifts = true;
                IndividualCandidacyProcess process2 = (IndividualCandidacyProcess)((Object)arg0);
                for (Attends attends : process2.getCandidacy().getPersonalDetails().getPerson().getCurrentAttends()) {
                    if (attends.hasAllShiftEnrolments()) continue;
                    hasNotMissingShifts = false;
                }
                return !process2.isCandidacyCancelled() && !hasNotMissingShifts;
            }
        }, childs);
        return childs;
    }

    public boolean isMobility() {
        return false;
    }

    public String getPresentationName() {
        String presentationName = "";
        if (this.getName() != null && !this.getName().isEmpty()) {
            presentationName = presentationName + this.getName() + " - ";
        }
        presentationName = presentationName + this.getCandidacyPeriod().getPresentationName();
        return presentationName;
    }

    private static <T extends CandidacyProcess> Set<T> getAllInstancesOf(Class<? extends T> type) {
        return Sets.newHashSet((Iterable)Iterables.filter((Iterable)Bennu.getInstance().getProcessesSet(), type));
    }
}

