/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.report.events;

import java.math.BigDecimal;
import java.util.Map;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.Installment;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEventWithPaymentPlan;
import org.fenixedu.academic.domain.accounting.report.events.InstallmentWrapper;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public class GratuityEventInstallmentWrapper
implements InstallmentWrapper {
    private GratuityEventWithPaymentPlan event;
    private Installment installment;

    public GratuityEventInstallmentWrapper(GratuityEventWithPaymentPlan event, Installment installment) {
        this.event = event;
        this.installment = installment;
    }

    @Override
    public String getExpirationDateLabel() {
        String label = BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.accounting.report.events.EventReportQueueJob.installment.expiration.date", (String[])new String[0]);
        return String.format(label, this.installment.getOrder());
    }

    @Override
    public String getAmountToPayLabel() {
        String label = BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.accounting.report.events.EventReportQueueJob.installment.expiration.amountToPay", (String[])new String[0]);
        return String.format(label, this.installment.getOrder());
    }

    @Override
    public String getRemainingAmountLabel() {
        String label = BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.org.fenixedu.academic.domain.accounting.report.events.EventReportQueueJob.installment.expiration.remainingAmount", (String[])new String[0]);
        return String.format(label, this.installment.getOrder());
    }

    @Override
    public String getExpirationDate() {
        return this.installment.getEndDate().toString("dd/MM/yyyy");
    }

    @Override
    public String getAmountToPay() {
        return this.installment.calculateAmount((Event)((Object)this.event), this.installment.getStartDate().toLocalDate().toDateTimeAtStartOfDay(), BigDecimal.ZERO, this.event.getGratuityPaymentPlan().isToApplyPenalty((Event)((Object)this.event), this.installment)).toPlainString();
    }

    @Override
    public String getRemainingAmount() {
        Map<Installment, Money> calculateInstallmentRemainingAmounts = this.event.getGratuityPaymentPlan().calculateInstallmentRemainingAmounts((Event)((Object)this.event), new DateTime(), this.event.getPostingRule().getDiscountPercentage((Event)((Object)this.event)));
        for (Map.Entry<Installment, Money> entry : calculateInstallmentRemainingAmounts.entrySet()) {
            if (entry.getKey() != this.installment) continue;
            return entry.getValue().toPlainString();
        }
        return Money.ZERO.toPlainString();
    }
}

