/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.candidacy;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.candidacy.DegreeCandidacyForGraduatedPersonEvent;
import org.fenixedu.academic.domain.accounting.postingRules.candidacy.DegreeCandidacyForGraduatedPersonPR_Base;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPerson;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;

public class DegreeCandidacyForGraduatedPersonPR
extends DegreeCandidacyForGraduatedPersonPR_Base {
    private DegreeCandidacyForGraduatedPersonPR() {
    }

    public DegreeCandidacyForGraduatedPersonPR(DateTime start, DateTime end, ServiceAgreementTemplate serviceAgreementTemplate, Money amountForInstitutionStudent, Money amountForExternalStudent) {
        this();
        super.init(EntryType.DEGREE_CANDIDACY_FOR_GRADUATED_PERSON_FEE, EventType.DEGREE_CANDIDACY_FOR_GRADUATED_PERSON, start, end, serviceAgreementTemplate);
        this.checkParameters(amountForInstitutionStudent, amountForExternalStudent);
        super.setAmountForInstitutionStudent(amountForInstitutionStudent);
        super.setAmountForExternalStudent(amountForExternalStudent);
    }

    private void checkParameters(Money amountForInstitutionStudent, Money amountForExternalStudent) {
        if (amountForInstitutionStudent == null) {
            throw new DomainException("error.DegreeCandidacyForGraduatedPersonPR.invalid.amountForInstitutionStudent", new String[0]);
        }
        if (amountForExternalStudent == null) {
            throw new DomainException("error.DegreeCandidacyForGraduatedPersonPR.invalid.amountForExternalStudent", new String[0]);
        }
    }

    public void setAmountForInstitutionStudent(Money amountForInstitutionStudent) {
        throw new DomainException("error.DegreeCandidacyForGraduatedPersonPR.cannot.modify.amountForInstitutionStudent", new String[0]);
    }

    public void setAmountForExternalStudent(Money amountForExternalStudent) {
        throw new DomainException("error.DegreeCandidacyForGraduatedPersonPR.cannot.modify.amountForExternalStudent", new String[0]);
    }

    public List<EntryDTO> calculateEntries(Event event, DateTime when) {
        Money amountToPay = this.calculateTotalAmountToPay(event, when);
        return Collections.singletonList(new EntryDTO(this.getEntryType(), event, amountToPay, Money.ZERO, amountToPay, event.getDescriptionForEntryType(this.getEntryType()), amountToPay));
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        DegreeCandidacyForGraduatedPerson individualCandidacy = ((DegreeCandidacyForGraduatedPersonEvent)((Object)event)).getIndividualCandidacy();
        PrecedentDegreeInformation information = individualCandidacy.getRefactoredPrecedentDegreeInformation();
        if (individualCandidacy.getUtlStudent() != null) {
            return individualCandidacy.getUtlStudent() != false ? this.getAmountForInstitutionStudent() : this.getAmountForExternalStudent();
        }
        if (information.isCandidacyInternal() || this.hasAnyValidRegistration((DegreeCandidacyForGraduatedPersonEvent)((Object)event)) || this.belongsToInstitutionGroup(information.getInstitution())) {
            return this.getAmountForInstitutionStudent();
        }
        return this.getAmountForExternalStudent();
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        return amountToPay;
    }

    public PaymentCodeType calculatePaymentCodeTypeFromEvent(Event event, DateTime when, boolean applyDiscount) {
        DegreeCandidacyForGraduatedPerson individualCandidacy = ((DegreeCandidacyForGraduatedPersonEvent)((Object)event)).getIndividualCandidacy();
        PrecedentDegreeInformation information = individualCandidacy.getRefactoredPrecedentDegreeInformation();
        if (individualCandidacy.getUtlStudent() != null) {
            return individualCandidacy.getUtlStudent() != false ? PaymentCodeType.INTERNAL_DEGREE_CANDIDACY_FOR_GRADUATED_PERSON_INDIVIDUAL_PROCESS : PaymentCodeType.EXTERNAL_DEGREE_CANDIDACY_FOR_GRADUATED_PERSON_INDIVIDUAL_PROCESS;
        }
        if (information.isCandidacyInternal() || this.hasAnyValidRegistration((DegreeCandidacyForGraduatedPersonEvent)((Object)event)) || this.belongsToInstitutionGroup(information.getInstitution())) {
            return PaymentCodeType.INTERNAL_DEGREE_CANDIDACY_FOR_GRADUATED_PERSON_INDIVIDUAL_PROCESS;
        }
        return PaymentCodeType.EXTERNAL_DEGREE_CANDIDACY_FOR_GRADUATED_PERSON_INDIVIDUAL_PROCESS;
    }

    private boolean hasAnyValidRegistration(DegreeCandidacyForGraduatedPersonEvent event) {
        if (!event.hasCandidacyStudent()) {
            return false;
        }
        List<Registration> registrations = event.getCandidacyStudent().getRegistrationsFor(event.getCandidacyDegree());
        for (Registration registration : event.getCandidacyStudent().getRegistrationsSet()) {
            if (registrations.contains((Object)registration) || registration.isCanceled()) continue;
            return true;
        }
        return false;
    }

    private boolean belongsToInstitutionGroup(Unit unit) {
        for (Unit parent : this.getRootDomainObject().getInstitutionUnit().getParentUnits()) {
            if (!parent.hasSubUnit(unit)) continue;
            return true;
        }
        return false;
    }

    protected Set<AccountingTransaction> internalProcess(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        if (entryDTOs.size() != 1) {
            throw new DomainException("error.DegreeCandidacyForGraduatedPersonPR.invalid.number.of.entryDTOs", new String[0]);
        }
        EntryDTO entryDTO = entryDTOs.iterator().next();
        this.checkIfCanAddAmount(entryDTO.getAmountToPay(), event, transactionDetail.getWhenRegistered());
        return Collections.singleton(this.makeAccountingTransaction(user, event, fromAccount, toAccount, entryDTO.getEntryType(), entryDTO.getAmountToPay(), transactionDetail));
    }

    private void checkIfCanAddAmount(Money amountToPay, Event event, DateTime when) {
        if (amountToPay.compareTo(this.calculateTotalAmountToPay(event, when)) < 0) {
            throw new DomainExceptionWithLabelFormatter("error.DegreeCandidacyForGraduatedPersonPR.amount.being.payed.must.match.amount.to.pay", event.getDescriptionForEntryType(this.getEntryType()));
        }
    }

    public DegreeCandidacyForGraduatedPersonPR edit(Money amountForInstitutionStudent, Money amountForExternalStudent) {
        this.deactivate();
        return new DegreeCandidacyForGraduatedPersonPR(new DateTime(), null, this.getServiceAgreementTemplate(), amountForInstitutionStudent, amountForExternalStudent);
    }
}

