/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules;

import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsuranceEvent;
import org.fenixedu.academic.domain.accounting.events.insurance.InsuranceEvent;
import org.fenixedu.academic.domain.accounting.postingRules.FixedAmountPR;
import org.fenixedu.academic.domain.accounting.postingRules.InsurancePR_Base;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class InsurancePR
extends InsurancePR_Base {
    protected InsurancePR() {
    }

    public InsurancePR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money fixedAmount) {
        this();
        this.init(EntryType.INSURANCE_FEE, EventType.INSURANCE, startDate, endDate, serviceAgreementTemplate, fixedAmount);
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        return this.getFixedAmount();
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        AdministrativeOfficeFeeAndInsuranceEvent administrativeOfficeFeeAndInsuranceEvent;
        InsuranceEvent insuranceEvent;
        if (event instanceof InsuranceEvent ? (insuranceEvent = (InsuranceEvent)((Object)event)).hasInsuranceExemption() : event instanceof AdministrativeOfficeFeeAndInsuranceEvent && (administrativeOfficeFeeAndInsuranceEvent = (AdministrativeOfficeFeeAndInsuranceEvent)((Object)event)).hasInsuranceExemption()) {
            return Money.ZERO;
        }
        return amountToPay;
    }

    public FixedAmountPR edit(Money fixedAmount) {
        this.deactivate();
        return new InsurancePR(new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), fixedAmount);
    }
}

