/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.EnrolmentOutOfPeriodEvent;
import org.fenixedu.academic.domain.accounting.postingRules.EnrolmentOutOfPeriodPR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;

public class EnrolmentOutOfPeriodPR
extends EnrolmentOutOfPeriodPR_Base {
    protected EnrolmentOutOfPeriodPR() {
    }

    public EnrolmentOutOfPeriodPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money baseAmount, Money amountPerDay, Money maxAmount) {
        this();
        this.init(EntryType.ENROLMENT_OUT_OF_PERIOD_PENALTY, EventType.ENROLMENT_OUT_OF_PERIOD, startDate, endDate, serviceAgreementTemplate, baseAmount, amountPerDay, maxAmount);
    }

    private void init(EntryType entryType, EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money baseAmount, Money amountPerDay, Money maxAmount) {
        this.checkParameters(baseAmount, amountPerDay, maxAmount);
        super.init(entryType, eventType, startDate, endDate, serviceAgreementTemplate);
        super.setBaseAmount(baseAmount);
        super.setAmountPerDay(amountPerDay);
        super.setMaxAmount(maxAmount);
    }

    private void checkParameters(Money baseAmount, Money amountPerDay, Money maxAmount) {
        if (baseAmount == null || baseAmount.isZero()) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.postingRules.EnrolmentOutOfPeriodPR.baseAmount.cannot.be.null.and.must.be.greater.than.zero", new String[0]);
        }
        if (amountPerDay == null || amountPerDay.isZero()) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.postingRules.EnrolmentOutOfPeriodPR.amountPerDay.cannot.be.null.and.must.be.greater.than.zero", new String[0]);
        }
        if (maxAmount == null || maxAmount.isZero()) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.postingRules.EnrolmentOutOfPeriodPR.maxAmount.cannot.be.null.and.must.be.greater.than.zero", new String[0]);
        }
    }

    public List<EntryDTO> calculateEntries(Event event, DateTime when) {
        return Collections.singletonList(new EntryDTO(this.getEntryType(), event, this.calculateTotalAmountToPay(event, when), event.getPayedAmount(), event.calculateAmountToPay(when), event.getDescriptionForEntryType(this.getEntryType()), event.calculateAmountToPay(when)));
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        Money result = this.getBaseAmount().add(this.getAmountPerDay().multiply(new BigDecimal(this.calculatNumberOfDays(event))));
        return result.greaterThan(this.getMaxAmount()) ? this.getMaxAmount() : result;
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        return amountToPay;
    }

    private Integer calculatNumberOfDays(Event event) {
        EnrolmentOutOfPeriodEvent enrolmentOutOfPeriodEvent = (EnrolmentOutOfPeriodEvent)((Object)event);
        Integer result = enrolmentOutOfPeriodEvent.getNumberOfDelayDays() - 1;
        return result < 0 ? 0 : result;
    }

    protected Set<AccountingTransaction> internalProcess(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        if (entryDTOs.size() != 1) {
            throw new DomainException("error.accounting.postingRules.EnrolmentOutOfPeriodPR.invalid.number.of.entryDTOs", new String[0]);
        }
        EntryDTO entryDTO = entryDTOs.iterator().next();
        this.checkIfCanAddAmount(entryDTO.getAmountToPay(), event, transactionDetail.getWhenRegistered());
        return Collections.singleton(this.makeAccountingTransaction(user, event, fromAccount, toAccount, entryDTO.getEntryType(), entryDTO.getAmountToPay(), transactionDetail));
    }

    private void checkIfCanAddAmount(Money amountToPay, Event event, DateTime whenRegistered) {
        if (amountToPay.compareTo(this.calculateTotalAmountToPay(event, whenRegistered)) < 0) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.postingRules.EnrolmentOutOfPeriodPR.amount.being.payed.must.match.amount.to.pay", event.getDescriptionForEntryType(this.getEntryType()));
        }
    }

    public EnrolmentOutOfPeriodPR edit(Money baseAmount, Money amountPerDay, Money maxAmount) {
        this.deactivate();
        return new EnrolmentOutOfPeriodPR(new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), baseAmount, amountPerDay, maxAmount);
    }
}

