/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.accounting.SibsPaymentFileProcessReport$callable$create;
import org.fenixedu.academic.domain.accounting.SibsPaymentFileProcessReport_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.accounting.sibsPaymentFileProcessReport.SibsPaymentFileProcessReportDTO;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsPaymentFileProcessReport
extends SibsPaymentFileProcessReport_Base {
    public static final Comparator<SibsPaymentFileProcessReport> COMPARATOR_BY_SIBS_PROCESS_DATE;
    public static final Advice advice$create;

    public SibsPaymentFileProcessReport(SibsPaymentFileProcessReportDTO sibsPaymentFileProcessReportDTO) {
        this.init(sibsPaymentFileProcessReportDTO);
    }

    private void init(SibsPaymentFileProcessReportDTO sibsPaymentFileProcessReportDTO) {
        this.checkParameters(sibsPaymentFileProcessReportDTO);
        this.checkRulesToCreate(sibsPaymentFileProcessReportDTO);
        super.setRootDomainObject(Bennu.getInstance());
        super.setWhenProcessed(new DateTime());
        super.setFilename(sibsPaymentFileProcessReportDTO.getFilename());
        super.setWhenProcessedBySibs(sibsPaymentFileProcessReportDTO.getWhenProcessedBySibs());
        super.setFileVersion(sibsPaymentFileProcessReportDTO.getFileVersion());
        super.setDegreeGratuityTotalAmount(sibsPaymentFileProcessReportDTO.getDegreeGratuityTotalAmount());
        super.setBolonhaDegreeGratuityTotalAmount(sibsPaymentFileProcessReportDTO.getBolonhaDegreeGratuityTotalAmount());
        super.setIntegratedMasterDegreeGratuityTotalAmount(sibsPaymentFileProcessReportDTO.getIntegratedMasterDegreeGratuityTotalAmount());
        super.setIntegratedBolonhaMasterDegreeGratuityTotalAmount(sibsPaymentFileProcessReportDTO.getIntegratedBolonhaMasterDegreeGratuityTotalAmount());
        super.setAdministrativeOfficeTaxTotalAmount(sibsPaymentFileProcessReportDTO.getAdministrativeOfficeTaxTotalAmount());
        super.setGraduationInsuranceTotalAmount(sibsPaymentFileProcessReportDTO.getGraduationInsuranceTotalAmount());
        super.setSpecializationGratuityTotalAmount(sibsPaymentFileProcessReportDTO.getSpecializationGratuityTotalAmount());
        super.setBolonhaMasterDegreeGratuityTotalAmount(sibsPaymentFileProcessReportDTO.getBolonhaMasterDegreeGratuityTotalAmount());
        super.setMasterDegreeGratuityTotalAmount(sibsPaymentFileProcessReportDTO.getMasterDegreeGratuityTotalAmount());
        super.setDfaGratuityTotalAmount(sibsPaymentFileProcessReportDTO.getDfaGratuityTotalAmount());
        super.setAfterGraduationInsuranceTotalAmount(sibsPaymentFileProcessReportDTO.getAfterGraduationInsuranceTotalAmount());
        super.setPhdGratuityTotalAmount(sibsPaymentFileProcessReportDTO.getPhdGratuityTotalAmout());
        super.setTransactionsTotalAmount(sibsPaymentFileProcessReportDTO.getTransactionsTotalAmount());
        super.setTotalCost(sibsPaymentFileProcessReportDTO.getTotalCost());
        super.setResidencePayment(sibsPaymentFileProcessReportDTO.getResidenceAmount());
        super.setDegreeCandidacyForGraduatedPersonAmount(sibsPaymentFileProcessReportDTO.getDegreeCandidacyForGraduatedPersonAmount());
        super.setDegreeChangeIndividualCandidacyAmount(sibsPaymentFileProcessReportDTO.getDegreeChangeIndividualCandidacyAmount());
        super.setDegreeTransferIndividualCandidacyAmount(sibsPaymentFileProcessReportDTO.getDegreeTransferIndividualCandidacyAmount());
        super.setSecondCycleIndividualCandidacyAmount(sibsPaymentFileProcessReportDTO.getSecondCycleIndividualCandidacyAmount());
        super.setStandaloneEnrolmentGratuityEventAmount(sibsPaymentFileProcessReportDTO.getStandaloneEnrolmentGratuityEventAmount());
        super.setOver23IndividualCandidacyEventAmount(sibsPaymentFileProcessReportDTO.getOver23IndividualCandidacyEventAmount());
        super.setInstitutionAffiliationEventAmount(sibsPaymentFileProcessReportDTO.getInstitutionAffiliationEventAmount());
        super.setPhdProgramCandidacyEventAmount(sibsPaymentFileProcessReportDTO.getPhdProgramCandidacyEventAmount());
        super.setRectorateAmount(sibsPaymentFileProcessReportDTO.getRectorateAmount());
    }

    private void checkRulesToCreate(SibsPaymentFileProcessReportDTO sibsPaymentFileProcessReportDTO) {
        if (SibsPaymentFileProcessReport.readBy(sibsPaymentFileProcessReportDTO.getWhenProcessedBySibs(), sibsPaymentFileProcessReportDTO.getFileVersion()) != null) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.SibsPaymentFileProcessReport.file.already.processed", new String[0]);
        }
    }

    private void checkParameters(SibsPaymentFileProcessReportDTO sibsPaymentFileProcessReportDTO) {
        if (sibsPaymentFileProcessReportDTO.getFilename() == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.SibsPaymentFileProcessReport.filename.cannot.be.null", new String[0]);
        }
        if (sibsPaymentFileProcessReportDTO.getWhenProcessedBySibs() == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.SibsPaymentFileProcessReport.whenProcessedBySibs.cannot.be.null", new String[0]);
        }
        if (sibsPaymentFileProcessReportDTO.getFileVersion() == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.SibsPaymentFileProcessReport.fileVersion.cannot.be.null", new String[0]);
        }
    }

    public static SibsPaymentFileProcessReport readBy(YearMonthDay date, Integer fileVersion) {
        for (SibsPaymentFileProcessReport sibsPaymentFileProcessReport : Bennu.getInstance().getSibsPaymentFileProcessReportsSet()) {
            if (!sibsPaymentFileProcessReport.getWhenProcessedBySibs().isEqual((ReadablePartial)date) || !sibsPaymentFileProcessReport.getFileVersion().equals(fileVersion)) continue;
            return sibsPaymentFileProcessReport;
        }
        return null;
    }

    public static boolean hasAny(YearMonthDay date, Integer fileVersion) {
        return SibsPaymentFileProcessReport.readBy(date, fileVersion) != null;
    }

    public static List<SibsPaymentFileProcessReport> readAllBetween(YearMonthDay startDate, YearMonthDay endDate) {
        return SibsPaymentFileProcessReport.readAllBetween(startDate.toLocalDate(), endDate.toLocalDate());
    }

    public static List<SibsPaymentFileProcessReport> readAllBetween(LocalDate startDate, LocalDate endDate) {
        ArrayList<SibsPaymentFileProcessReport> result = new ArrayList<SibsPaymentFileProcessReport>();
        for (SibsPaymentFileProcessReport report : Bennu.getInstance().getSibsPaymentFileProcessReportsSet()) {
            if (report.getWhenProcessedBySibs().compareTo((ReadablePartial)startDate) < 0 || report.getWhenProcessedBySibs().compareTo((ReadablePartial)endDate) > 0) continue;
            result.add(report);
        }
        return result;
    }

    public static SibsPaymentFileProcessReport create(SibsPaymentFileProcessReportDTO sibsPaymentFileProcessReportDTO) {
        return (SibsPaymentFileProcessReport)((Object)advice$create.perform((Callable)new SibsPaymentFileProcessReport$callable$create(sibsPaymentFileProcessReportDTO)));
    }

    static /* synthetic */ SibsPaymentFileProcessReport advised$create(SibsPaymentFileProcessReportDTO reportDTO) {
        return new SibsPaymentFileProcessReport(reportDTO);
    }

    public void delete() {
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    static {
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_SIBS_PROCESS_DATE = new Comparator<SibsPaymentFileProcessReport>(){

            @Override
            public int compare(SibsPaymentFileProcessReport o1, SibsPaymentFileProcessReport o2) {
                return o1.getWhenProcessedBySibs().compareTo((ReadablePartial)o2.getWhenProcessedBySibs());
            }
        };
    }
}

