/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.GroupStrategy;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

@GroupOperator(value="allAlumni")
public class AllAlumniGroup
extends GroupStrategy {
    private static final long serialVersionUID = -2926898164196025354L;

    public String getPresentationName() {
        return BundleUtil.getString((String)"resources.GroupNameResources", (String)"label.name.AllAlumniGroup", (String[])new String[0]);
    }

    private boolean isAlumni(Student student) {
        return student.getRegistrationsSet().stream().anyMatch(registration -> ProgramConclusion.conclusionsFor(registration).filter(ProgramConclusion::isAlumniProvider).anyMatch(conclusion -> conclusion.groupFor((Registration)((Object)registration)).isPresent() && conclusion.groupFor((Registration)((Object)registration)).get().isConclusionProcessed()));
    }

    public Set<User> getMembers() {
        return Bennu.getInstance().getStudentsSet().stream().filter(student -> student.getAlumni() != null || student.hasAnyRegistrationInState(RegistrationStateType.CONCLUDED) || student.hasAnyRegistrationInState(RegistrationStateType.STUDYPLANCONCLUDED) || this.isAlumni((Student)((Object)student))).map(student -> student.getPerson().getUser()).collect(Collectors.toSet());
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user) {
        return user != null && user.getPerson() != null && user.getPerson().getStudent() != null && (user.getPerson().getStudent().hasAnyRegistrationInState(RegistrationStateType.CONCLUDED) || user.getPerson().getStudent().hasAnyRegistrationInState(RegistrationStateType.STUDYPLANCONCLUDED) || this.isAlumni(user.getPerson().getStudent()));
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }
}

