/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeCurricularPlanEquivalencePlan;
import org.fenixedu.academic.domain.EquivalencePlanEntry;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.StudentCurricularPlanEquivalencePlan_Base;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurricularPlan.equivalencyPlan.EquivalencyPlanEntryCurriculumModuleWrapper;
import org.fenixedu.academic.domain.studentCurricularPlan.equivalencyPlan.EquivalencyPlanEntryWrapper;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;

public class StudentCurricularPlanEquivalencePlan
extends StudentCurricularPlanEquivalencePlan_Base {
    public StudentCurricularPlanEquivalencePlan(StudentCurricularPlan studentCurricularPlan) {
        this.init(studentCurricularPlan);
    }

    private void init(StudentCurricularPlan oldStudentCurricularPlan) {
        this.checkParameters(oldStudentCurricularPlan);
        super.setOldStudentCurricularPlan(oldStudentCurricularPlan);
    }

    private void checkParameters(StudentCurricularPlan oldStudentCurricularPlan) {
        if (oldStudentCurricularPlan == null) {
            throw new DomainException("error.StudentCurricularPlanEquivalencePlan.oldStudentCurricularPlan.cannot.be.null", new String[0]);
        }
    }

    public Set<EquivalencePlanEntry> getEquivalencePlanEntries(DegreeCurricularPlan degreeCurricularPlan) {
        HashSet<EquivalencePlanEntry> equivalencePlanEntries = new HashSet<EquivalencePlanEntry>();
        equivalencePlanEntries.addAll(degreeCurricularPlan.getEquivalencePlan().getEntriesSet());
        equivalencePlanEntries.removeAll(this.getEntriesToRemoveSet());
        for (EquivalencePlanEntry equivalencePlanEntry : this.getEntriesSet()) {
            if (!equivalencePlanEntry.isFor(degreeCurricularPlan)) continue;
            equivalencePlanEntries.add(equivalencePlanEntry);
        }
        return equivalencePlanEntries;
    }

    public Set<EquivalencyPlanEntryWrapper> getEquivalencePlanEntryWrappers(DegreeCurricularPlan degreeCurricularPlan, CurriculumModule curriculumModule) {
        TreeSet<EquivalencyPlanEntryWrapper> equivalencePlanEntries = new TreeSet<EquivalencyPlanEntryWrapper>(EquivalencyPlanEntryWrapper.COMPARATOR);
        for (EquivalencePlanEntry equivalencePlanEntry : degreeCurricularPlan.getEquivalencePlan().getEntriesSet()) {
            if (!this.hasAllEnrolmentsFor(equivalencePlanEntry, this.getOldStudentCurricularPlan()) || curriculumModule != null && !this.matchOrigin(equivalencePlanEntry, curriculumModule.getDegreeModule())) continue;
            if (this.getEntriesToRemoveSet().contains((Object)equivalencePlanEntry)) {
                equivalencePlanEntries.add(new EquivalencyPlanEntryWrapper(equivalencePlanEntry, true));
                continue;
            }
            equivalencePlanEntries.add(new EquivalencyPlanEntryWrapper(equivalencePlanEntry, false));
        }
        for (EquivalencePlanEntry equivalencePlanEntry : this.getEntriesSet()) {
            if (!equivalencePlanEntry.isFor(degreeCurricularPlan) || curriculumModule != null && !equivalencePlanEntry.isFor(curriculumModule.getDegreeModule())) continue;
            equivalencePlanEntries.add(new EquivalencyPlanEntryWrapper(equivalencePlanEntry, false));
        }
        return equivalencePlanEntries;
    }

    private boolean hasAllEnrolmentsFor(EquivalencePlanEntry equivalencePlanEntry, StudentCurricularPlan studentCurricularPlan) {
        return equivalencePlanEntry.canApply(studentCurricularPlan);
    }

    private boolean matchOrigin(EquivalencePlanEntry equivalencePlanEntry, DegreeModule degreeModule) {
        for (DegreeModule otherDegreeModule : equivalencePlanEntry.getOldDegreeModulesSet()) {
            if (otherDegreeModule != degreeModule) continue;
            return true;
        }
        return false;
    }

    public EquivalencyPlanEntryCurriculumModuleWrapper getRootEquivalencyPlanEntryCurriculumModuleWrapper(DegreeCurricularPlan degreeCurricularPlan) {
        return this.getEquivalencyPlanEntryCurriculumModuleWrapper(degreeCurricularPlan, (CurriculumModule)((Object)this.getOldStudentCurricularPlan().getRoot()));
    }

    private EquivalencyPlanEntryCurriculumModuleWrapper getEquivalencyPlanEntryCurriculumModuleWrapper(DegreeCurricularPlan degreeCurricularPlan, CurriculumModule curriculumModule) {
        EquivalencyPlanEntryCurriculumModuleWrapper equivalencyPlanEntryCurriculumModuleWrapper = new EquivalencyPlanEntryCurriculumModuleWrapper(curriculumModule);
        DegreeModule degreeModule = curriculumModule.getDegreeModule();
        this.addEquivalencyPlanEntryCurriculumModuleWrappers(equivalencyPlanEntryCurriculumModuleWrapper, degreeCurricularPlan.getEquivalencePlan(), degreeModule);
        for (EquivalencePlanEntry equivalencePlanEntry : this.getEntriesSet()) {
            if (!equivalencePlanEntry.isFor(degreeModule)) continue;
            equivalencyPlanEntryCurriculumModuleWrapper.addEquivalencePlanEntriesToApply(equivalencePlanEntry);
        }
        if (!curriculumModule.isLeaf()) {
            CurriculumGroup curriculumGroup = (CurriculumGroup)((Object)curriculumModule);
            for (CurriculumModule childCurriculumModule : curriculumGroup.getCurriculumModulesSet()) {
                if (!childCurriculumModule.isLeaf() && ((CurriculumGroup)((Object)childCurriculumModule)).isNoCourseGroupCurriculumGroup()) continue;
                EquivalencyPlanEntryCurriculumModuleWrapper childEquivalencyPlanEntryCurriculumModuleWrapper = this.getEquivalencyPlanEntryCurriculumModuleWrapper(degreeCurricularPlan, childCurriculumModule);
                equivalencyPlanEntryCurriculumModuleWrapper.addChildren(childEquivalencyPlanEntryCurriculumModuleWrapper);
            }
        }
        return equivalencyPlanEntryCurriculumModuleWrapper;
    }

    private void addEquivalencyPlanEntryCurriculumModuleWrappers(EquivalencyPlanEntryCurriculumModuleWrapper equivalencyPlanEntryCurriculumModuleWrapper, DegreeCurricularPlanEquivalencePlan equivalencePlan, DegreeModule degreeModule) {
        Set equivalencePlanEntries;
        if (degreeModule.isLeaf()) {
            CurricularCourse curricularCourse = (CurricularCourse)((Object)degreeModule);
            equivalencePlanEntries = this.getOldStudentCurricularPlan().hasEnrolmentOrAprovalInCurriculumModule((DegreeModule)((Object)curricularCourse)) ? curricularCourse.getOldEquivalencePlanEntriesSet() : Collections.EMPTY_SET;
        } else {
            CourseGroup courseGroup = (CourseGroup)((Object)degreeModule);
            equivalencePlanEntries = courseGroup.getOldEquivalencePlanEntriesSet();
        }
        for (EquivalencePlanEntry equivalencePlanEntry : equivalencePlanEntries) {
            if (equivalencePlanEntry.getEquivalencePlan() != equivalencePlan) continue;
            if (this.getEntriesToRemoveSet().contains((Object)equivalencePlanEntry)) {
                equivalencyPlanEntryCurriculumModuleWrapper.addRemovedEquivalencePlanEntries(equivalencePlanEntry);
                continue;
            }
            if (!equivalencePlanEntry.canApply(this.getOldStudentCurricularPlan())) continue;
            equivalencyPlanEntryCurriculumModuleWrapper.addEquivalencePlanEntriesToApply(equivalencePlanEntry);
        }
    }
}

