/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.externalServices.epfl;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Photograph;
import org.fenixedu.academic.domain.PublicCandidacyHashCode;
import org.fenixedu.academic.domain.Qualification;
import org.fenixedu.academic.domain.QualificationType;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramCollaborationType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessState;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.PhdProgramFocusArea;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.ThesisSubjectOrder;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyReferee;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramPublicCandidacyHashCode;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.Partial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportPhdIndividualProgramProcessesInHtml {
    private static final Logger logger = LoggerFactory.getLogger(ExportPhdIndividualProgramProcessesInHtml.class);
    private static final String APPLICATION_NAME = "Application to FCT Doctoral Programmes";
    private static final String APPLICATION_PREFIX_LINK = "";

    static byte[] exportPresentationPage() throws IOException {
        ArrayList<PhdProgramPublicCandidacyHashCode> unfocusAreaCandidates = new ArrayList<PhdProgramPublicCandidacyHashCode>();
        Page page = new Page();
        page.h2(APPLICATION_NAME);
        for (Map.Entry<PhdProgramFocusArea, Set<PhdProgramPublicCandidacyHashCode>> entry : ExportPhdIndividualProgramProcessesInHtml.getApplicants(unfocusAreaCandidates).entrySet()) {
            page.h(3, ExportPhdIndividualProgramProcessesInHtml.getFocusAreaTitle(entry), "mtop2");
            page.ulStart();
            for (PhdProgramPublicCandidacyHashCode code : entry.getValue()) {
                String url = "/phd/epfl/applications/show?process=" + code.getValue();
                page.liStart().link(url, code.getPerson().getName()).liEnd();
            }
            page.ulEnd();
        }
        page.close();
        return page.toByteArray();
    }

    private static String getFocusAreaTitle(Map.Entry<PhdProgramFocusArea, Set<PhdProgramPublicCandidacyHashCode>> entry) {
        return entry.getKey().getName().getContent() + " (" + entry.getValue().size() + " applications)";
    }

    private static Map<PhdProgramFocusArea, Set<PhdProgramPublicCandidacyHashCode>> getApplicants(List<PhdProgramPublicCandidacyHashCode> unfocusAreaCandidates) {
        TreeMap<PhdProgramFocusArea, Set<PhdProgramPublicCandidacyHashCode>> candidates = new TreeMap<PhdProgramFocusArea, Set<PhdProgramPublicCandidacyHashCode>>(PhdProgramFocusArea.COMPARATOR_BY_NAME);
        for (PublicCandidacyHashCode hashCode : Bennu.getInstance().getCandidacyHashCodesSet()) {
            PhdProgramPublicCandidacyHashCode phdHashCode;
            if (!hashCode.isFromPhdProgram() || !hashCode.hasCandidacyProcess() || (phdHashCode = (PhdProgramPublicCandidacyHashCode)((Object)hashCode)).getIndividualProgramProcess().getExecutionYear() != ExecutionYear.readCurrentExecutionYear() || !PhdIndividualProgramCollaborationType.EPFL.equals((Object)phdHashCode.getIndividualProgramProcess().getCollaborationType()) || !PhdIndividualProgramProcessState.CANDIDACY.equals(phdHashCode.getIndividualProgramProcess().getActiveState())) continue;
            ExportPhdIndividualProgramProcessesInHtml.addCandidate(unfocusAreaCandidates, candidates, phdHashCode);
        }
        return candidates;
    }

    private static void addCandidate(List<PhdProgramPublicCandidacyHashCode> unfocusAreaCandidates, Map<PhdProgramFocusArea, Set<PhdProgramPublicCandidacyHashCode>> candidates, PhdProgramPublicCandidacyHashCode hashCode) {
        PhdProgramFocusArea focusArea = hashCode.getIndividualProgramProcess().getPhdProgramFocusArea();
        if (focusArea == null) {
            unfocusAreaCandidates.add(hashCode);
            return;
        }
        if (!candidates.containsKey((Object)focusArea)) {
            candidates.put(focusArea, new TreeSet<PhdProgramPublicCandidacyHashCode>(new Comparator<PhdProgramPublicCandidacyHashCode>(){

                @Override
                public int compare(PhdProgramPublicCandidacyHashCode o1, PhdProgramPublicCandidacyHashCode o2) {
                    return o1.getPerson().getName().compareTo(o2.getPerson().getName());
                }
            }));
        }
        candidates.get((Object)focusArea).add(hashCode);
    }

    static byte[] drawCandidatePage(PhdProgramPublicCandidacyHashCode hashCode) throws IOException {
        String email = hashCode.getEmail().substring(0, hashCode.getEmail().indexOf("@"));
        Page page = new Page();
        page.h2(APPLICATION_NAME);
        ExportPhdIndividualProgramProcessesInHtml.drawPersonalInformation(page, hashCode, email);
        ExportPhdIndividualProgramProcessesInHtml.drawPhdIndividualProgramInformation(page, hashCode);
        ExportPhdIndividualProgramProcessesInHtml.drawGuidings(page, hashCode);
        ExportPhdIndividualProgramProcessesInHtml.drawQualifications(page, hashCode);
        ExportPhdIndividualProgramProcessesInHtml.drawCandidacyReferees(page, hashCode, email);
        ExportPhdIndividualProgramProcessesInHtml.drawDocuments(page, hashCode, email);
        ExportPhdIndividualProgramProcessesInHtml.drawThesisRanking(page, hashCode, email);
        page.close();
        return page.toByteArray();
    }

    private static void drawPersonalInformation(Page page, PhdProgramPublicCandidacyHashCode hashCode, String folderName) throws IOException {
        Person person = hashCode.getPerson();
        page.h(3, "Personal Information", "mtop2");
        page.tableStart("tstyle2 thwhite thnowrap thlight thleft thtop ulnomargin ");
        page.rowStart("tdbold").headerStartWithStyle("width: 125px;").write("Name:").headerEnd().column(person.getName()).rowEnd();
        page.rowStart().header("Gender:").column(person.getGender().toLocalizedString(Locale.ENGLISH)).rowEnd();
        page.rowStart().header("Identity card type:").column(person.getIdDocumentType().getLocalizedName()).rowEnd();
        page.rowStart().header("Identity card #:").column(person.getDocumentIdNumber()).rowEnd();
        page.rowStart().header("Issued by:").column(person.getEmissionLocationOfDocumentId()).rowEnd();
        page.rowStart().header("Fiscal number:").column(ExportPhdIndividualProgramProcessesInHtml.string(person.getSocialSecurityNumber())).rowEnd();
        page.rowStart().header("Date of birth:").column(person.getDateOfBirthYearMonthDay().toString("dd/MM/yyyy")).rowEnd();
        page.rowStart().header("Birthplace:").column(person.getDistrictSubdivisionOfBirth()).rowEnd();
        page.rowStart().header("Nationality:").column(person.getCountry().getCountryNationality().getContent()).rowEnd();
        page.rowStart().header("Address:").column(person.getAddress()).rowEnd();
        page.rowStart().header("City:").column(person.getArea()).rowEnd();
        page.rowStart().header("Zip code:").column(person.getAreaCode()).rowEnd();
        page.rowStart().header("Country:").column(person.getCountryOfResidence() != null ? person.getCountryOfResidence().getName() : "-").rowEnd();
        page.rowStart().header("Phone:").column(person.getDefaultPhoneNumber()).rowEnd();
        page.rowStart().header("Mobile:").column(person.getDefaultMobilePhoneNumber()).rowEnd();
        page.rowStart().header("Email:").column(person.getDefaultEmailAddressValue()).rowEnd();
        page.tableEnd();
        page.h(3, "Photo");
        String photoUrl = "/phd/epfl/applications/photo";
        Photograph photo = person.getPersonalPhotoEvenIfPending();
        if (photo != null) {
            photoUrl = photoUrl + "?photoOid=" + photo.getExternalId();
        }
        page.photo(photoUrl);
    }

    private static void drawPhdIndividualProgramInformation(Page page, PhdProgramPublicCandidacyHashCode hashCode) throws IOException {
        PhdIndividualProgramProcess process2 = hashCode.getIndividualProgramProcess();
        page.h(3, "Application information");
        page.tableStart("tstyle2 thwhite thnowrap thlight thleft thtop ulnomargin ");
        page.rowStart().headerStartWithStyle("width: 125px;").write("Candidacy Date:").headerEnd().column(process2.getCandidacyDate().toString("dd/MM/yyyy")).rowEnd();
        page.rowStart().header("Area:").column(process2.getPhdProgramFocusArea().getName().getContent()).rowEnd();
        page.rowStart().header(Unit.getInstitutionAcronym() + " Phd Program:").column(process2.getPhdProgram().getName().getContent(MultiLanguageString.en)).rowEnd();
        if (process2.getExternalPhdProgram() != null) {
            page.rowStart().header("EPFL Phd Program:").column(process2.getExternalPhdProgram().getName().getContent(MultiLanguageString.en));
        }
        page.rowStart().header("Title:").column(ExportPhdIndividualProgramProcessesInHtml.string(process2.getThesisTitle())).rowEnd();
        page.rowStart().header("Collaboration:").column(process2.getCollaborationTypeName()).rowEnd();
        page.rowStart().header("Year:").column(process2.getExecutionYear().getYear()).rowEnd();
        page.tableEnd();
    }

    private static void drawDocuments(Page page, PhdProgramPublicCandidacyHashCode hashCode, String folderName) throws IOException {
        page.h(3, "Documents", "mtop2");
        PhdIndividualProgramProcess process2 = hashCode.getIndividualProgramProcess();
        if (!process2.getCandidacyProcessDocuments().isEmpty()) {
            String documentName = folderName + "-documents.zip";
            String url = "/phd/epfl/applications/candidateDocuments?candidateOid=" + hashCode.getExternalId();
            page.pStart("mbottom0").link(url, documentName).pEnd();
            page.tableStart("tstyle2 thwhite thnowrap thlight thleft thtop ulnomargin ");
            page.rowStart().header("Document type").header("Upload time").header("Filename").rowEnd();
            for (PhdProgramProcessDocument document : process2.getCandidacyProcessDocuments()) {
                page.rowStart().column(document.getDocumentType().getLocalizedName());
                page.column(document.getCreationDate().toString("dd/MM/yyyy HH:mm"));
                page.column(document.getFilename()).rowEnd();
            }
            page.tableEnd();
        }
    }

    private static void drawThesisRanking(Page page, PhdProgramPublicCandidacyHashCode hashCode, String email) throws IOException {
        page.h(3, "Thesis Rank", "mtop2");
        PhdIndividualProgramProcess process2 = hashCode.getIndividualProgramProcess();
        page.tableStart("tstyle2");
        page.rowStart();
        page.header("Rank");
        page.header("Name");
        page.header("Teacher");
        page.header("Description");
        page.rowEnd();
        Collection<ThesisSubjectOrder> thesisSubjectOrders = process2.getThesisSubjectOrdersSorted();
        for (ThesisSubjectOrder thesisSubjectOrder : thesisSubjectOrders) {
            page.rowStart();
            page.column(thesisSubjectOrder.getSubjectOrder().toString());
            page.column(thesisSubjectOrder.getThesisSubject().getName().getContent());
            page.column(thesisSubjectOrder.getThesisSubject().getTeacher() != null ? thesisSubjectOrder.getThesisSubject().getTeacher().getPerson().getName() : APPLICATION_PREFIX_LINK);
            page.rowEnd();
        }
        page.tableEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] createZip(PhdProgramPublicCandidacyHashCode hashCode) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = null;
        try {
            zip = new ZipOutputStream(outputStream);
            int count = 1;
            for (PhdProgramProcessDocument document : hashCode.getIndividualProgramProcess().getCandidacyProcessDocuments()) {
                ZipEntry zipEntry = new ZipEntry(count + "-" + document.getFilename());
                zip.putNextEntry(zipEntry);
                ExportPhdIndividualProgramProcessesInHtml.copy(document.getStream(), zip);
                zip.closeEntry();
                ++count;
            }
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (zip != null) {
                try {
                    zip.flush();
                    zip.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return outputStream.toByteArray();
    }

    private static void drawCandidacyReferees(Page page, PhdProgramPublicCandidacyHashCode hashCode, String folderName) throws IOException {
        PhdIndividualProgramProcess process2 = hashCode.getIndividualProgramProcess();
        page.h(3, "Reference letters (referees)", "mtop2");
        if (!process2.getPhdCandidacyReferees().isEmpty()) {
            int count = 1;
            for (PhdCandidacyReferee referee : process2.getPhdCandidacyReferees()) {
                page.pStart("mbottom0").strong(String.valueOf(count) + ". ").pEnd();
                ExportPhdIndividualProgramProcessesInHtml.drawReferee(page, referee, count, folderName);
                ++count;
            }
        } else {
            page.pStart().write("Not defined").pEnd();
        }
    }

    private static void drawReferee(Page page, PhdCandidacyReferee referee, int count, String folderName) throws IOException {
        page.tableStart("tstyle2 thwhite thnowrap thlight thleft thtop ulnomargin ");
        page.rowStart().headerStartWithStyle("width: 125px;").write("Name:").headerEnd().column(referee.getName()).rowEnd();
        page.rowStart().header("Email:").column(referee.getEmail()).rowEnd();
        page.rowStart().header("Institution:").column(referee.getInstitution()).rowEnd();
        if (referee.isLetterAvailable()) {
            page.rowStart().header("Referee form submitted:");
            String url = "/phd/epfl/applications/referee?refereeOid=" + referee.getExternalId() + "&amp;count=" + count;
            page.columnStart().link(url, "Yes").columnEnd().rowEnd();
        } else {
            page.rowStart().header("Referee form submitted:").column("No").rowEnd();
        }
        page.tableEnd();
    }

    static byte[] drawLetter(PhdCandidacyReferee referee, int count) throws IOException {
        Page page = new Page();
        page.h2(APPLICATION_NAME);
        page.h(3, "Applicant", "mtop2");
        ExportPhdIndividualProgramProcessesInHtml.candidateInformation(referee, page);
        ExportPhdIndividualProgramProcessesInHtml.letterInformation(referee, page);
        page.close();
        return page.toByteArray();
    }

    private static void letterInformation(PhdCandidacyReferee referee, Page page) throws IOException {
        PhdCandidacyRefereeLetter letter = referee.getLetter();
        page.h(3, "Reference Letter", "mtop2");
        page.tableStart("tstyle2 thwhite thnowrap thlight thleft thtop ulnomargin");
        page.rowStart().headerStartWithStyle("width: 200px;").write("How long have you known the applicant?").headerEnd().column(ExportPhdIndividualProgramProcessesInHtml.string(letter.getHowLongKnownApplicant()) + " months").rowEnd();
        page.rowStart().header("In what capacity?").column(ExportPhdIndividualProgramProcessesInHtml.string(letter.getCapacity())).rowEnd();
        page.rowStart().header("Comparison group:").column(ExportPhdIndividualProgramProcessesInHtml.string(letter.getComparisonGroup())).rowEnd();
        page.rowStart().header("Rank in class (if applicable):").column(ExportPhdIndividualProgramProcessesInHtml.string(letter.getRankInClass())).rowEnd();
        page.rowStart().header("Academic performance:").column(ExportPhdIndividualProgramProcessesInHtml.string(letter.getAcademicPerformance().getLocalizedName())).rowEnd();
        page.rowStart().header("Social and Communication Skills:").column(ExportPhdIndividualProgramProcessesInHtml.string(letter.getSocialAndCommunicationSkills().getLocalizedName())).rowEnd();
        page.rowStart().header("Potential to excel in a PhD:").column(ExportPhdIndividualProgramProcessesInHtml.string(letter.getPotencialToExcelPhd().getLocalizedName())).rowEnd();
        page.rowStart().header("Recomendation letter:");
        if (letter.getFile() != null) {
            page.column(letter.getFile().getDisplayName() + " (file is inside documents zip file)");
        } else {
            page.column("-");
        }
        page.rowEnd();
        page.rowStart().header("Comments:").column(ExportPhdIndividualProgramProcessesInHtml.string(letter.getComments())).rowEnd();
        page.rowStart().header("Name:").column(ExportPhdIndividualProgramProcessesInHtml.string(letter.getRefereeName())).rowEnd();
        page.rowStart().header("Position/Title:").column(ExportPhdIndividualProgramProcessesInHtml.string(letter.getRefereePosition())).rowEnd();
        page.rowStart().header("Institution:").column(ExportPhdIndividualProgramProcessesInHtml.string(letter.getRefereeInstitution())).rowEnd();
        page.rowStart().header("Address:").column(ExportPhdIndividualProgramProcessesInHtml.string(letter.getRefereeInstitution())).rowEnd();
        page.rowStart().header("City:").column(ExportPhdIndividualProgramProcessesInHtml.string(letter.getRefereeCity())).rowEnd();
        page.rowStart().header("Zip code:").column(ExportPhdIndividualProgramProcessesInHtml.string(letter.getRefereeZipCode())).rowEnd();
        page.rowStart().header("Country:").column(letter.getRefereeCountry() != null ? letter.getRefereeCountry().getLocalizedName().getContent() : "-").rowEnd();
        page.rowStart().header("Email:").column(ExportPhdIndividualProgramProcessesInHtml.string(letter.getRefereeEmail())).rowEnd();
        page.tableEnd();
    }

    private static void candidateInformation(PhdCandidacyReferee referee, Page page) throws IOException {
        page.tableStart("tstyle2 thwhite thnowrap thlight thleft thtop ulnomargin ");
        page.rowStart("tdbold").headerStartWithStyle("width: 200px;").write("Name: ").headerEnd().column(referee.getPhdProgramCandidacyProcess().getPerson().getName()).rowEnd();
        page.tableEnd();
    }

    private static void drawQualifications(Page page, PhdProgramPublicCandidacyHashCode hashCode) throws IOException {
        PhdIndividualProgramProcess process2 = hashCode.getIndividualProgramProcess();
        page.h(3, "Academic Degrees", "mtop2");
        if (!process2.getQualifications().isEmpty()) {
            int count = 1;
            for (Qualification qualification : process2.getQualifications()) {
                page.pStart("mbottom0").strong(String.valueOf(count) + ". ").pEnd();
                ExportPhdIndividualProgramProcessesInHtml.drawQualification(page, qualification);
                ++count;
            }
        } else {
            page.pStart().write("Not defined").pEnd();
        }
    }

    private static void drawQualification(Page page, Qualification qualification) throws IOException {
        page.tableStart("tstyle2 thwhite thnowrap thlight thleft thtop ulnomargin ");
        if (qualification != null) {
            QualificationType type = qualification.getType();
            page.rowStart().header("Type:").column(type == null ? "-" : type.getLocalizedName()).rowEnd();
            String degree = qualification.getDegree();
            page.rowStart().header("Scientific Field:").column(degree == null ? "-" : degree).rowEnd();
            String school = qualification.getSchool();
            page.rowStart().header("Institution:").column(school == null ? "-" : school).rowEnd();
            String mark = qualification.getMark();
            page.rowStart().header("Grade:").column(mark == null ? "-" : mark).rowEnd();
            Partial attendedBegin = qualification.getAttendedBegin();
            page.rowStart().header("Attended from:").column(attendedBegin == null ? "-" : attendedBegin.toString("MM/yyyy")).rowEnd();
            Partial attendedEnd = qualification.getAttendedEnd();
            page.rowStart().header("Attended to:").column(attendedEnd == null ? "-" : attendedEnd.toString("MM/yyyy")).rowEnd();
        }
        page.tableEnd();
    }

    private static void drawGuidings(Page page, PhdProgramPublicCandidacyHashCode hashCode) throws IOException {
        PhdIndividualProgramProcess process2 = hashCode.getIndividualProgramProcess();
        page.h(3, "Phd supervisors (if applicable)", "mtop2");
        if (!process2.getGuidingsSet().isEmpty()) {
            int count = 1;
            for (PhdParticipant guiding : process2.getGuidingsSet()) {
                page.pStart("mbottom0").strong(String.valueOf(count) + ". ").pEnd();
                ExportPhdIndividualProgramProcessesInHtml.drawGuiding(page, guiding);
                ++count;
            }
        } else {
            page.pStart().write("Not defined").pEnd();
        }
    }

    private static void drawGuiding(Page page, PhdParticipant guiding) throws IOException {
        page.tableStart("tstyle2 thwhite thnowrap thlight thleft thtop ulnomargin ");
        page.rowStart().headerStartWithStyle("width: 125px;").write("Name:").headerEnd().column(guiding.getName()).rowEnd();
        page.rowStart().header("Affiliation:").column(guiding.getWorkLocation()).rowEnd();
        page.rowStart().header("Email:").column(guiding.getEmail()).rowEnd();
        page.tableEnd();
    }

    private static String string(String value) {
        return value != null ? value : APPLICATION_PREFIX_LINK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int BUFFER_SIZE = 0x100000;
        try {
            int numberOfBytesRead;
            byte[] buffer = new byte[BUFFER_SIZE];
            while ((numberOfBytesRead = inputStream.read(buffer, 0, BUFFER_SIZE)) != -1) {
                outputStream.write(buffer, 0, numberOfBytesRead);
            }
        }
        finally {
            inputStream.close();
        }
    }

    private static class Page {
        private ByteArrayOutputStream writer = new ByteArrayOutputStream();

        Page() throws IOException {
            this.write("<xhtml>");
            this.write("<head>");
            this.css("/CSS/iststyle.css");
            this.css("/CSS/webservice.css");
            this.write("</head>");
            this.write("<body>");
        }

        public byte[] toByteArray() throws IOException {
            this.write("</body>");
            this.write("</xhtml>");
            return this.writer.toByteArray();
        }

        public Page css(String url) throws IOException {
            return this.write(String.format("<link rel=\"stylesheet\" type=\"text/css\" media=\"screen\"  href=\"%s\" />", url));
        }

        public Page h2(String body) throws IOException {
            return this.h(2, body);
        }

        public Page h(int level, String body) throws IOException {
            return this.startTag("h" + level).write(body).endTag("h" + level);
        }

        public Page h(int level, String body, String classes) throws IOException {
            return this.write(String.format("<h%s class=\"%s\">", level, classes)).write(body).endTag("h" + level);
        }

        public Page link(String path, String name) throws IOException {
            return this.write(String.format("<a href='%s'>%s</a>", path, name));
        }

        public Page strong(String body) throws IOException {
            return this.startTag("strong").write(body).endTag("strong");
        }

        public Page tableStart(String classes) throws IOException {
            return this.write(String.format("<table class=\"%s\">", classes));
        }

        public Page rowStart() throws IOException {
            return this.startTag("tr");
        }

        public Page rowStart(String classes) throws IOException {
            return this.write(String.format("<tr class=\"%s\"", classes));
        }

        public Page rowEnd() throws IOException {
            return this.endTag("tr");
        }

        public Page headerStartWithStyle(String style) throws IOException {
            return this.write(String.format("<th style=\"%s\">", style));
        }

        public Page headerEnd() throws IOException {
            return this.endTag("th");
        }

        public Page header(String body) throws IOException {
            return this.write(String.format("<th>%s</th>", body));
        }

        public Page columnStart() throws IOException {
            return this.startTag("td");
        }

        public Page columnEnd() throws IOException {
            return this.endTag("td");
        }

        public Page column(String body) throws IOException {
            return this.write(String.format("<td>%s</td>", body));
        }

        public Page tableEnd() throws IOException {
            return this.endTag("table");
        }

        public Page ulStart() throws IOException {
            return this.startTag("ul");
        }

        public Page ulEnd() throws IOException {
            return this.endTag("ul");
        }

        public Page liStart() throws IOException {
            return this.startTag("li");
        }

        public Page liEnd() throws IOException {
            return this.endTag("li");
        }

        public Page pStart(String classes) throws IOException {
            return this.write(String.format("<p class=\"%s\">", classes));
        }

        public Page pStart() throws IOException {
            return this.startTag("p");
        }

        public Page pEnd() throws IOException {
            return this.endTag("p");
        }

        public Page photo(String photoPath) throws IOException {
            return this.write(String.format("<img src=\"%s\" />", photoPath));
        }

        private Page startTag(String tagName) throws IOException {
            return this.write("<" + tagName + ">");
        }

        private Page endTag(String tagName) throws IOException {
            return this.write("</" + tagName + ">");
        }

        public Page write(String value) throws IOException {
            this.writer.write(value.getBytes(StandardCharsets.UTF_8));
            this.writer.write("\n".getBytes(StandardCharsets.UTF_8));
            return this;
        }

        public void close() throws IOException {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
            }
        }
    }
}

