/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.teacher.evaluation;

import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;
import org.fenixedu.academic.domain.AdHocEvaluation;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.teacher.CreateAdHocEvaluation;
import org.fenixedu.academic.service.services.teacher.DeleteEvaluation;
import org.fenixedu.academic.service.services.teacher.EditAdHocEvaluation;
import org.fenixedu.academic.ui.faces.bean.teacher.evaluation.EvaluationManagementBackingBean;
import pt.ist.fenixframework.FenixFramework;

public class AdHocEvaluationManagementBackingBean
extends EvaluationManagementBackingBean {
    protected String name;
    protected AdHocEvaluation adHocEvaluation;
    protected String adHocEvaluationID;

    public String createAdHocEvaluation() {
        try {
            CreateAdHocEvaluation.runCreateAdHocEvaluation(this.getExecutionCourseID(), this.getName(), this.getDescription(), this.getGradeScale());
        }
        catch (NotAuthorizedException e) {
            return "";
        }
        catch (FenixServiceException e) {
            this.setErrorMessage(e.getMessage());
            return "";
        }
        catch (DomainException e) {
            this.setErrorMessage(e.getKey());
            return "";
        }
        return "adHocEvaluationsIndex";
    }

    public String editAdHocEvaluation() {
        try {
            EditAdHocEvaluation.run(this.getExecutionCourseID(), this.getAdHocEvaluationID(), this.getName(), this.getDescription(), this.getGradeScale());
        }
        catch (FenixServiceException e) {
            this.setErrorMessage(e.getMessage());
            return "";
        }
        catch (DomainException e) {
            this.setErrorMessage(e.getKey());
            return "";
        }
        return "adHocEvaluationsIndex";
    }

    private AdHocEvaluation getAdHocEvaluation() {
        if (this.adHocEvaluation == null && this.getAdHocEvaluationID() != null) {
            this.adHocEvaluation = (AdHocEvaluation)FenixFramework.getDomainObject((String)this.getAdHocEvaluationID());
        }
        return this.adHocEvaluation;
    }

    public String deleteAdHocEvaluation() {
        try {
            DeleteEvaluation.runDeleteEvaluation(this.getExecutionCourseID(), this.getAdHocEvaluationID());
        }
        catch (NotAuthorizedException notAuthorizedException) {
        }
        catch (FenixServiceException e) {
            this.setErrorMessage(e.getMessage());
        }
        catch (DomainException e) {
            this.setErrorMessage(e.getKey());
        }
        return "adHocEvaluationsIndex";
    }

    public List<AdHocEvaluation> getAssociatedAdHocEvaluations() throws FenixServiceException {
        List<AdHocEvaluation> associatedAdHocEvaluations = this.getExecutionCourse().getAssociatedAdHocEvaluations();
        Collections.sort(associatedAdHocEvaluations, new BeanComparator("creationDateTime"));
        return associatedAdHocEvaluations;
    }

    public String getName() {
        if (this.name == null && this.getAdHocEvaluation() != null) {
            this.name = this.getAdHocEvaluation().getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        if (this.description == null && this.getAdHocEvaluation() != null) {
            this.description = this.getAdHocEvaluation().getDescription();
        }
        return this.description;
    }

    public String getAdHocEvaluationID() {
        if (this.adHocEvaluationID == null && this.getRequestParameter("adHocEvaluationID") != null && !this.getRequestParameter("adHocEvaluationID").equals("")) {
            this.adHocEvaluationID = this.getRequestParameter("adHocEvaluationID");
        }
        return this.adHocEvaluationID;
    }

    public void setAdHocEvaluationID(String adHocEvaluationID) {
        this.adHocEvaluationID = adHocEvaluationID;
    }

    @Override
    public GradeScale getGradeScale() {
        if (this.gradeScale == null && this.getAdHocEvaluation() != null) {
            this.gradeScale = this.getAdHocEvaluation().getGradeScale();
        }
        return this.gradeScale;
    }
}

