/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.student.enrolment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.html.HtmlInputHidden;
import org.apache.commons.beanutils.BeanComparator;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.student.EnrolStudentInWrittenEvaluation;
import org.fenixedu.academic.service.services.student.UnEnrollStudentInWrittenEvaluation;
import org.fenixedu.academic.ui.faces.bean.student.enrolment.DisplayEvaluationsForStudentToEnrol;
import org.fenixedu.spaces.domain.Space;

public class ManageEvaluationsForStudent
extends DisplayEvaluationsForStudentToEnrol {
    private List<Evaluation> evaluationsWithEnrolmentPeriodOpened;
    private List<Evaluation> evaluationsWithEnrolmentPeriodClosed;
    private HtmlInputHidden evaluationTypeHidden;
    private Map<String, Boolean> enroledEvaluationsForStudent;
    private Map<String, String> studentRooms;

    public List<Evaluation> getEvaluationsWithEnrolmentPeriodClosed() {
        if (this.evaluationsWithEnrolmentPeriodClosed == null) {
            this.processEvaluations();
        }
        return this.evaluationsWithEnrolmentPeriodClosed;
    }

    public void setEvaluationsWithEnrolmentPeriodClosed(List<Evaluation> evaluationsWithEnrolmentPeriodClosed) {
        this.evaluationsWithEnrolmentPeriodClosed = evaluationsWithEnrolmentPeriodClosed;
    }

    public List<Evaluation> getEvaluationsWithEnrolmentPeriodOpened() {
        if (this.evaluationsWithEnrolmentPeriodOpened == null) {
            this.processEvaluations();
        }
        return this.evaluationsWithEnrolmentPeriodOpened;
    }

    public void setEvaluationsWithEnrolmentPeriodOpened(List<Evaluation> evaluationsWithEnrolmentPeriodOpened) {
        this.evaluationsWithEnrolmentPeriodOpened = evaluationsWithEnrolmentPeriodOpened;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvaluations() {
        this.evaluationsWithEnrolmentPeriodClosed = new ArrayList<Evaluation>();
        this.evaluationsWithEnrolmentPeriodOpened = new ArrayList<Evaluation>();
        String evaluationType = this.getEvaluationTypeString();
        for (Registration registration : this.getStudent().getStudent().getRegistrationsSet()) {
            if (!registration.hasStateType(this.getExecutionPeriod(), RegistrationStateType.REGISTERED)) continue;
            for (WrittenEvaluation writtenEvaluation : registration.getWrittenEvaluations(this.getExecutionPeriod())) {
                Exam exam;
                if (writtenEvaluation instanceof Exam && !(exam = (Exam)((Object)writtenEvaluation)).isExamsMapPublished() || !((Object)((Object)writtenEvaluation)).getClass().getName().equals(evaluationType)) continue;
                try {
                    if (writtenEvaluation.isInEnrolmentPeriod()) {
                        this.evaluationsWithEnrolmentPeriodOpened.add((Evaluation)((Object)writtenEvaluation));
                        continue;
                    }
                    this.evaluationsWithEnrolmentPeriodClosed.add((Evaluation)((Object)writtenEvaluation));
                    Space room = registration.getRoomFor(writtenEvaluation);
                    String roomName = room != null ? room.getName() : "-";
                    this.getStudentRooms().put(writtenEvaluation.getExternalId(), roomName);
                }
                catch (DomainException e) {
                    this.getEvaluationsWithoutEnrolmentPeriod().add((Evaluation)((Object)writtenEvaluation));
                    Space room = registration.getRoomFor(writtenEvaluation);
                    String value = room != null ? room.getName() : "-";
                    this.getStudentRooms().put(writtenEvaluation.getExternalId(), value);
                }
                finally {
                    this.getEnroledEvaluationsForStudent().put(writtenEvaluation.getExternalId(), registration.isEnroledIn((Evaluation)((Object)writtenEvaluation)));
                    this.getExecutionCourses().put(writtenEvaluation.getExternalId(), writtenEvaluation.getAttendingExecutionCoursesFor(registration));
                }
            }
        }
        Collections.sort(this.evaluationsWithEnrolmentPeriodClosed, new BeanComparator("dayDate"));
        Collections.sort(this.evaluationsWithEnrolmentPeriodOpened, new BeanComparator("dayDate"));
        Collections.sort(this.getEvaluationsWithoutEnrolmentPeriod(), new BeanComparator("dayDate"));
    }

    public String enrolStudent() {
        try {
            EnrolStudentInWrittenEvaluation.runEnrolStudentInWrittenEvaluation(this.getUserView().getUsername(), this.getEvaluationID());
            this.clearAttributes();
        }
        catch (DomainException e) {
            this.setErrorMessage(e.getMessage());
        }
        catch (NotAuthorizedException e) {
            this.setErrorMessage("errors.impossible.operation");
        }
        catch (FenixServiceException e) {
            this.setErrorMessage("errors.impossible.operation");
        }
        return "";
    }

    public String unenrolStudent() {
        try {
            UnEnrollStudentInWrittenEvaluation.runUnEnrollStudentInWrittenEvaluation(this.getUserView().getUsername(), this.getEvaluationID());
            this.clearAttributes();
        }
        catch (DomainException e) {
            this.setErrorMessage(e.getMessage());
        }
        catch (NotAuthorizedException e) {
            this.setErrorMessage("errors.impossible.operation");
        }
        catch (FenixServiceException e) {
            this.setErrorMessage("errors.impossible.operation");
        }
        return "";
    }

    public String getEvaluationID() {
        return this.getRequestParameter("evaluationID");
    }

    @Override
    protected void clearAttributes() {
        this.setEvaluationsWithEnrolmentPeriodClosed(null);
        this.setEvaluationsWithEnrolmentPeriodOpened(null);
        this.setEvaluationsWithoutEnrolmentPeriod(null);
        this.setExecutionCourses(null);
    }

    @Override
    public Integer getEvaluationType() {
        if (this.evaluationType == null) {
            if (this.getRequestParameter("evaluationType") != null) {
                this.evaluationType = Integer.valueOf(this.getRequestParameter("evaluationType"));
            } else if (this.getEvaluationTypeHidden().getValue() != null) {
                this.evaluationType = Integer.valueOf(this.getEvaluationTypeHidden().getValue().toString());
            }
        }
        return this.evaluationType;
    }

    public HtmlInputHidden getEvaluationTypeHidden() {
        if (this.evaluationTypeHidden == null) {
            this.evaluationTypeHidden = new HtmlInputHidden();
            this.evaluationTypeHidden.setValue((Object)this.getEvaluationType());
        }
        return this.evaluationTypeHidden;
    }

    public void setEvaluationTypeHidden(HtmlInputHidden evaluationTypeHidden) {
        if (evaluationTypeHidden != null) {
            this.setEvaluationType(Integer.valueOf(evaluationTypeHidden.getValue().toString()));
        }
        this.evaluationTypeHidden = evaluationTypeHidden;
    }

    public Map<String, Boolean> getEnroledEvaluationsForStudent() {
        if (this.enroledEvaluationsForStudent == null) {
            this.enroledEvaluationsForStudent = new HashMap<String, Boolean>();
        }
        return this.enroledEvaluationsForStudent;
    }

    public void setEnroledEvaluationsForStudent(Map<String, Boolean> enroledEvaluationsForStudent) {
        this.enroledEvaluationsForStudent = enroledEvaluationsForStudent;
    }

    public Map<String, String> getStudentRooms() {
        if (this.studentRooms == null) {
            this.studentRooms = new HashMap<String, String>();
        }
        return this.studentRooms;
    }

    public void setStudentRooms(Map<String, String> studentRooms) {
        this.studentRooms = studentRooms;
    }
}

