/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.student.enrollment.bolonha;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.enrolment.EnroledCurriculumModuleWrapper;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;

public class NoCourseGroupEnroledCurriculumModuleWrapper
extends EnroledCurriculumModuleWrapper {
    private static final long serialVersionUID = 1L;

    public NoCourseGroupEnroledCurriculumModuleWrapper(CurriculumModule curriculumModule, ExecutionSemester executionSemester) {
        super(curriculumModule, executionSemester);
    }

    @Override
    public boolean canCollectRules() {
        return false;
    }

    @Override
    public Context getContext() {
        return null;
    }

    @Override
    public double getAccumulatedEctsCredits(ExecutionSemester executionSemester) {
        if (this.getCurriculumModule().isEnrolment()) {
            Enrolment enrolment = (Enrolment)((Object)this.getCurriculumModule());
            if (!enrolment.isBolonhaDegree()) {
                return enrolment.getAccumulatedEctsCredits(executionSemester);
            }
            return enrolment.getStudentCurricularPlan().getAccumulatedEctsCredits(this.getExecutionPeriod(), enrolment.getCurricularCourse());
        }
        return 0.0;
    }

    @Override
    public Set<ICurricularRule> getCurricularRulesFromCurriculumGroup(ExecutionSemester executionSemester) {
        return Collections.emptySet();
    }

    @Override
    public List<CurricularRule> getCurricularRulesFromDegreeModule(ExecutionSemester executionSemester) {
        return Collections.emptyList();
    }

    @Override
    public boolean isDissertation() {
        return this.getCurriculumModule().getDegreeModule().isDissertation();
    }
}

