/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.student.enrollment.bolonha;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.bennu.core.security.Authenticate;

public class CycleEnrolmentBean
implements Serializable {
    private static final long serialVersionUID = -7926077929745839701L;
    private StudentCurricularPlan studentCurricularPlan;
    private ExecutionSemester executionSemester;
    private CycleCourseGroup cycleCourseGroupToEnrol;
    private CycleType sourceCycleAffinity;
    private CycleType cycleTypeToEnrol;

    public CycleEnrolmentBean(StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester, CycleType sourceCycleAffinity, CycleType cycleTypeToEnrol) {
        this.setStudentCurricularPlan(studentCurricularPlan);
        this.setExecutionPeriod(executionSemester);
        this.setSourceCycleAffinity(sourceCycleAffinity);
        this.setCycleTypeToEnrol(cycleTypeToEnrol);
    }

    public CycleEnrolmentBean(StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester, CycleCourseGroup cycleCourseGroup) {
        this(studentCurricularPlan, executionSemester, CycleType.FIRST_CYCLE, cycleCourseGroup.getCycleType());
        this.setCycleCourseGroupToEnrol(cycleCourseGroup);
    }

    public StudentCurricularPlan getStudentCurricularPlan() {
        return this.studentCurricularPlan;
    }

    public void setStudentCurricularPlan(StudentCurricularPlan studentCurricularPlan) {
        this.studentCurricularPlan = studentCurricularPlan;
    }

    public ExecutionSemester getExecutionPeriod() {
        return this.executionSemester;
    }

    public void setExecutionPeriod(ExecutionSemester executionSemester) {
        this.executionSemester = executionSemester;
    }

    public CycleCourseGroup getCycleCourseGroupToEnrol() {
        return this.cycleCourseGroupToEnrol;
    }

    public void setCycleCourseGroupToEnrol(CycleCourseGroup cycleCourseGroup) {
        this.cycleCourseGroupToEnrol = cycleCourseGroup;
    }

    public CycleType getSourceCycleAffinity() {
        return this.sourceCycleAffinity;
    }

    public void setSourceCycleAffinity(CycleType sourceCycleAffinity) {
        this.sourceCycleAffinity = sourceCycleAffinity;
    }

    public CycleType getCycleTypeToEnrol() {
        return this.cycleTypeToEnrol;
    }

    public void setCycleTypeToEnrol(CycleType cycleTypeToEnrol) {
        this.cycleTypeToEnrol = cycleTypeToEnrol;
    }

    public Collection<CycleCourseGroup> getCycleDestinationAffinities() {
        Collection<CycleCourseGroup> affinities = this.getDegreeCurricularPlan().getDestinationAffinities(this.getSourceCycleAffinity());
        if (affinities.isEmpty()) {
            return Collections.emptyList();
        }
        if (!this.isStudent()) {
            return affinities;
        }
        ArrayList<CycleCourseGroup> result = new ArrayList<CycleCourseGroup>();
        for (CycleCourseGroup cycleCourseGroup : affinities) {
            DegreeCurricularPlan degreeCurricularPlan = cycleCourseGroup.getParentDegreeCurricularPlan();
            if (!degreeCurricularPlan.hasEnrolmentPeriodInCurricularCourses(this.getExecutionPeriod())) continue;
            result.add(cycleCourseGroup);
        }
        return result;
    }

    private boolean isStudent() {
        return RoleType.STUDENT.isMember(Authenticate.getUser().getPerson().getUser());
    }

    private DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.getStudentCurricularPlan().getDegreeCurricularPlan();
    }

    public CycleCurriculumGroup getSourceCycle() {
        return this.getStudentCurricularPlan().getCycle(this.getSourceCycleAffinity());
    }
}

