/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.dto.InfoPerson;
import org.fenixedu.academic.dto.InfoProfessorship;
import pt.ist.fenixframework.FenixFramework;

public class InfoTeacher
extends InfoObject {
    private Person person;

    public InfoTeacher() {
    }

    public InfoTeacher(Person person) {
        this.person = person;
    }

    public InfoTeacher(Teacher teacher) {
        this.person = teacher.getPerson();
    }

    public List getProfessorShipsExecutionCourses() {
        ArrayList<InfoProfessorship> infoProfessorships = new ArrayList<InfoProfessorship>();
        for (Professorship professorship : this.getPerson().getProfessorshipsSet()) {
            infoProfessorships.add(InfoProfessorship.newInfoFromDomain(professorship));
        }
        return infoProfessorships;
    }

    public List getResponsibleForExecutionCourses() {
        ArrayList<InfoProfessorship> infoProfessorships = new ArrayList<InfoProfessorship>();
        for (Professorship professorship : this.getPerson().getProfessorshipsSet()) {
            if (!professorship.isResponsibleFor()) continue;
            infoProfessorships.add(InfoProfessorship.newInfoFromDomain(professorship));
        }
        return infoProfessorships;
    }

    public String getTeacherId() {
        return this.getTeacher().getPerson().getUsername();
    }

    public InfoPerson getInfoPerson() {
        return InfoPerson.newInfoFromDomain(this.getPerson());
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getPerson() == ((InfoTeacher)obj).getPerson();
    }

    public String toString() {
        return this.getTeacher().toString();
    }

    public static InfoTeacher newInfoFromDomain(Person person) {
        return person == null ? null : new InfoTeacher(person);
    }

    public static InfoTeacher newInfoFromDomain(Teacher teacher) {
        return teacher == null ? null : new InfoTeacher(teacher);
    }

    @Override
    public String getExternalId() {
        return this.getTeacher().getExternalId();
    }

    @Override
    public void setExternalId(String integer) {
        this.person = ((Teacher)FenixFramework.getDomainObject((String)integer)).getPerson();
    }

    public Teacher getTeacher() {
        return this.person.getTeacher();
    }

    public Person getPerson() {
        return this.person;
    }
}

