/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProcessStateType;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public enum PhdIndividualProgramProcessState implements PhdProcessStateType
{
    ABANDON,
    CANDIDACY(true),
    NOT_ADMITTED,
    CANCELLED,
    WORK_DEVELOPMENT(true),
    SUSPENDED,
    THESIS_DISCUSSION(true),
    FLUNKED,
    CONCLUDED(true),
    TRANSFERRED;

    private boolean activeState;

    private PhdIndividualProgramProcessState(boolean activeState) {
        this.activeState = activeState;
    }

    private PhdIndividualProgramProcessState() {
        this(false);
    }

    public boolean isActive() {
        return this.activeState;
    }

    public boolean isPhdActive() {
        return this == WORK_DEVELOPMENT || this == THESIS_DISCUSSION;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getLocalizedName() {
        return this.getLocalizedName(I18N.getLocale());
    }

    @Override
    public String getLocalizedName(Locale locale) {
        return BundleUtil.getString((String)"resources.PhdResources", (Locale)locale, (String)this.getQualifiedName(), (String[])new String[0]);
    }

    public String getQualifiedName() {
        return this.getClass().getSimpleName() + "." + this.name();
    }

    public static List<PhdIndividualProgramProcessState> getPossibleNextStates(PhdIndividualProgramProcess process2) {
        PhdIndividualProgramProcessState activeState = process2.getActiveState();
        if (activeState == null) {
            return Collections.singletonList(CANDIDACY);
        }
        switch (activeState) {
            case CANDIDACY: {
                return Arrays.asList(WORK_DEVELOPMENT, NOT_ADMITTED, SUSPENDED, FLUNKED, CANCELLED);
            }
            case WORK_DEVELOPMENT: {
                if (process2.getThesisProcess() != null) {
                    return Arrays.asList(THESIS_DISCUSSION, NOT_ADMITTED, SUSPENDED, FLUNKED, CANCELLED, TRANSFERRED, ABANDON);
                }
                return Arrays.asList(NOT_ADMITTED, SUSPENDED, FLUNKED, CANCELLED, TRANSFERRED, ABANDON);
            }
            case THESIS_DISCUSSION: {
                return Arrays.asList(NOT_ADMITTED, SUSPENDED, FLUNKED, CANCELLED, CONCLUDED, ABANDON);
            }
            case ABANDON: 
            case SUSPENDED: 
            case FLUNKED: {
                return Arrays.asList(process2.getLastActiveState().getType());
            }
            case NOT_ADMITTED: 
            case CANCELLED: 
            case CONCLUDED: {
                return Collections.emptyList();
            }
            case TRANSFERRED: {
                return Collections.singletonList(WORK_DEVELOPMENT);
            }
        }
        throw new DomainException("error.PhdIndividualProgramProcess.unknown.process.state.types", new String[0]);
    }

    public static List<PhdIndividualProgramProcessState> getPossibleNextStates(PhdIndividualProgramProcessState stateType) {
        if (stateType == null) {
            return Collections.singletonList(CANDIDACY);
        }
        switch (stateType) {
            case CANDIDACY: {
                return Arrays.asList(WORK_DEVELOPMENT, NOT_ADMITTED, SUSPENDED, FLUNKED, CANCELLED);
            }
            case WORK_DEVELOPMENT: {
                return Arrays.asList(THESIS_DISCUSSION, NOT_ADMITTED, SUSPENDED, FLUNKED, CANCELLED, TRANSFERRED);
            }
            case THESIS_DISCUSSION: {
                return Arrays.asList(NOT_ADMITTED, SUSPENDED, FLUNKED, CANCELLED, CONCLUDED);
            }
            case SUSPENDED: 
            case FLUNKED: {
                return Arrays.asList(WORK_DEVELOPMENT, THESIS_DISCUSSION);
            }
            case NOT_ADMITTED: 
            case CANCELLED: {
                return Collections.emptyList();
            }
            case CONCLUDED: {
                return Collections.emptyList();
            }
            case TRANSFERRED: {
                return Collections.emptyList();
            }
        }
        throw new DomainException("error.PhdIndividualProgramProcess.unknown.process.state.types", new String[0]);
    }
}

