/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import com.google.common.base.Strings;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.PartySocialSecurityNumber_Base;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.bennu.core.domain.Bennu;

public class PartySocialSecurityNumber
extends PartySocialSecurityNumber_Base {
    public PartySocialSecurityNumber() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    private PartySocialSecurityNumber(Party party, Country fiscalCountry, String socialSecurityNumber) {
        this();
        super.setParty(party);
        super.setFiscalCountry(fiscalCountry);
        super.setSocialSecurityNumber(socialSecurityNumber);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getParty() == null) {
            throw new DomainException("error.PartySocialSecurityNumber.invalid.party", new String[0]);
        }
        if (!this.hasSocialSecurityNumber() && !this.hasFiscalCountry()) {
            return;
        }
        if (this.hasSocialSecurityNumber() && !this.hasFiscalCountry() || this.hasFiscalCountry() && !this.hasSocialSecurityNumber()) {
            throw new DomainException("error.PartySocialSecurityNumber.fiscal.information.is.not.complete", new String[0]);
        }
        String defaultSocialSecurityNumber = FenixEduAcademicConfiguration.getConfiguration().getDefaultSocialSecurityNumber();
        if (!Strings.isNullOrEmpty((String)defaultSocialSecurityNumber) && defaultSocialSecurityNumber.equals(this.getSocialSecurityNumber()) && Country.readDefault() != this.getFiscalCountry()) {
            throw new DomainException("error.PartySocialSecurityNumber.invalid.country.for.default.social.security.number", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)defaultSocialSecurityNumber) || !defaultSocialSecurityNumber.equals(this.getSocialSecurityNumber())) {
            for (PartySocialSecurityNumber otherPartySecurityNumber : Bennu.getInstance().getPartySocialSecurityNumbersSet()) {
                if (otherPartySecurityNumber == this || !this.getSocialSecurityNumber().equals(otherPartySecurityNumber.getSocialSecurityNumber())) continue;
                throw new DomainException("error.PartySocialSecurityNumber.number.already.exists", otherPartySecurityNumber.getParty().getName());
            }
        }
        if (!TreasuryBridgeAPIFactory.implementation().isValidFiscalNumber(this.getFiscalCountry().getCode(), this.getSocialSecurityNumber())) {
            throw new DomainException("error.PartySocialSecurityNumber.invalid.socialSecurityNumber", new String[0]);
        }
        if (this.getParty().isPerson()) {
            TreasuryBridgeAPIFactory.implementation().updateCustomer((Person)((Object)this.getParty()), this.getFiscalCountry().getCode(), this.getSocialSecurityNumber());
        }
    }

    public boolean hasSocialSecurityNumber(String socialSecurityNumber) {
        return this.getSocialSecurityNumber().equals(socialSecurityNumber);
    }

    public void delete() {
        this.setFiscalCountry(null);
        this.setParty(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    private void edit(Country fiscalCountry, String socialSecurityNumber) {
        if (this.hasFiscalCountry() && fiscalCountry == null) {
            throw new DomainException("error.PartySocialSecurityNumber.cannot.remove.fiscal.country", new String[0]);
        }
        if (this.hasSocialSecurityNumber() && Strings.isNullOrEmpty((String)socialSecurityNumber)) {
            throw new DomainException("error.PartySocialSecurityNumber.cannot.remove.social.security.number", new String[0]);
        }
        this.setFiscalCountry(fiscalCountry);
        this.setSocialSecurityNumber(socialSecurityNumber);
        this.checkRules();
    }

    protected boolean hasFiscalCountry() {
        return this.getFiscalCountry() != null;
    }

    protected boolean hasSocialSecurityNumber() {
        return !Strings.isNullOrEmpty((String)this.getSocialSecurityNumber());
    }

    public static PartySocialSecurityNumber editFiscalInformation(Party party, Country fiscalCountry, String socialSecurityNumber) {
        PartySocialSecurityNumber partySocialSecurityNumber = party.getPartySocialSecurityNumber();
        if (partySocialSecurityNumber == null) {
            return new PartySocialSecurityNumber(party, fiscalCountry, socialSecurityNumber);
        }
        partySocialSecurityNumber.edit(fiscalCountry, socialSecurityNumber);
        return partySocialSecurityNumber;
    }

    public static Party readPartyBySocialSecurityNumber(String socialSecurityNumber) {
        if (socialSecurityNumber == null || socialSecurityNumber.length() == 0) {
            return null;
        }
        for (PartySocialSecurityNumber securityNumber : Bennu.getInstance().getPartySocialSecurityNumbersSet()) {
            if (!securityNumber.hasSocialSecurityNumber(socialSecurityNumber)) continue;
            return securityNumber.getParty();
        }
        return null;
    }
}

