/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.erasmus;

import java.util.Comparator;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusAlertEntityType;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusAlert_Base;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.util.MultiLanguageString;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;

public class ErasmusAlert
extends ErasmusAlert_Base {
    public static final Comparator<ErasmusAlert> WHEN_CREATED_COMPARATOR = new Comparator<ErasmusAlert>(){

        @Override
        public int compare(ErasmusAlert o1, ErasmusAlert o2) {
            return o1.getWhenCreated().compareTo((ReadableInstant)o2.getWhenCreated());
        }
    };

    public ErasmusAlert() {
    }

    public ErasmusAlert(MobilityIndividualApplicationProcess process2, Boolean sendEmail2, LocalDate whenToFire, MultiLanguageString subject, MultiLanguageString body, ErasmusAlertEntityType entity) {
        this();
        this.init(process2, sendEmail2, whenToFire, subject, body, entity);
    }

    protected void init(MobilityIndividualApplicationProcess process2, Boolean sendEmail2, LocalDate whenToFire, MultiLanguageString subject, MultiLanguageString body, ErasmusAlertEntityType entity) {
        super.init(subject, body);
        String[] args = new String[]{};
        if (whenToFire == null) {
            throw new DomainException("org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusIndividualCandidacyProcess.fireDate.cannot.be.null", args);
        }
        super.setSendEmail(sendEmail2);
        super.setWhenToFire(whenToFire);
        super.setEntity(entity);
        super.setProcess(process2);
        super.setWhoCreated(AccessControl.getPerson());
    }

    protected void generateMessage() {
    }

    protected String buildMailBody() {
        StringBuilder result = new StringBuilder();
        for (String eachContent : this.getFormattedBody().getAllContents()) {
            result.append(eachContent).append("\n").append(" ------------------------- ");
        }
        result.delete(result.lastIndexOf("\n") + 1, result.length());
        return result.toString();
    }

    protected String buildMailSubject() {
        StringBuilder result = new StringBuilder();
        for (String eachContent : this.getFormattedSubject().getAllContents()) {
            result.append(eachContent).append(" / ");
        }
        if (result.toString().endsWith(" / ")) {
            result.delete(result.length() - 3, result.length());
        }
        return result.toString();
    }

    public String getDescription() {
        return null;
    }

    protected boolean isToDiscard() {
        return !this.isToSendMail();
    }

    public boolean isToFire() {
        return this.getFireDate() == null;
    }

    public boolean isToSendMail() {
        return this.getSendEmail() != false && this.getProcess().getCandidacyProcess().hasOpenCandidacyPeriod();
    }
}

