/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsuranceExemptionJustificationByDispatch_Base;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsuranceExemptionJustificationType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.util.LabelFormatter;
import org.joda.time.YearMonthDay;

public class AdministrativeOfficeFeeAndInsuranceExemptionJustificationByDispatch
extends AdministrativeOfficeFeeAndInsuranceExemptionJustificationByDispatch_Base {
    protected AdministrativeOfficeFeeAndInsuranceExemptionJustificationByDispatch() {
    }

    public AdministrativeOfficeFeeAndInsuranceExemptionJustificationByDispatch(Exemption exemption, AdministrativeOfficeFeeAndInsuranceExemptionJustificationType justificationType, String reason, YearMonthDay dispatchDate) {
        this();
        this.init(exemption, justificationType, reason, dispatchDate);
    }

    private void init(Exemption exemption, AdministrativeOfficeFeeAndInsuranceExemptionJustificationType justificationType, String reason, YearMonthDay dispatchDate) {
        this.checkParameters(exemption, justificationType, reason, dispatchDate);
        super.init(exemption, justificationType, reason);
        super.setDispatchDate(dispatchDate);
    }

    private void checkParameters(Exemption exemption, AdministrativeOfficeFeeAndInsuranceExemptionJustificationType justificationType, String reason, YearMonthDay dispatchDate) {
        if (!exemption.isForAdministrativeOfficeFee()) {
            throw new DomainException("error.accounting.events.AdministrativeOfficeFeeAndInsuranceExemptionJustificationByDispatch.exemption.must.be.form.administrativeOfficeFee.exemption", new String[0]);
        }
        if (dispatchDate == null || StringUtils.isEmpty((String)reason)) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.events.AdministrativeOfficeFeeAndInsuranceExemptionJustificationByDispatch.dispatchDate.and.reason.are.required", new LabelFormatter(justificationType.getQualifiedName(), "resources.EnumerationResources"));
        }
    }

    public LabelFormatter getDescription() {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(this.getJustificationType().getQualifiedName(), "resources.EnumerationResources");
        String dispatchDate = this.getDispatchDate() != null ? this.getDispatchDate().toString("dd/MM/yyyy") : "-";
        labelFormatter.appendLabel(" (").appendLabel("label.in", "resources.ApplicationResources").appendLabel(" ").appendLabel(dispatchDate).appendLabel(")");
        return labelFormatter;
    }
}

